/*
 * File:     wx_main.h
 * Purpose:  wxApp declaration and a few other functions.
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_mainh
#define wx_mainh

#include "common.h"
#include "wx_obj.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

class wxFrame;

// Represents the application. Derive OnInit and declare
// a new App object to start application
class wxApp: public wxObject
{
 public:
  wxFrame *wx_frame;
  int argc;
  char **argv;
  Bool death_processed;
#ifdef wx_motif
  XtAppContext appContext;
  Widget topLevel;
#endif
#ifdef wx_msw
  HANDLE hInstance;
  MSG current_msg;
#endif

  wxApp(void);
  ~wxApp(void);
  virtual wxFrame *OnInit(void);
  virtual int OnExit(void);
  virtual int MainLoop(void);
  Bool Initialized(void);
#ifdef wx_msw
  virtual BOOL DoMessage(void);
  virtual BOOL ProcessMessage(MSG* pMsg);
  virtual BOOL OnIdle(void);
#endif
};

extern wxApp *wxTheApp;

// Force an exit from main loop
void wxExit(void);

// Yield to other apps/messages
Bool wxYield(void);

#ifdef wx_msw
extern HANDLE wxhInstance;
#endif

#endif
