/*
 * File:     wx_panel.h
 * Purpose:  wxPanel subwindow, for panel items (widgets/controls)
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_panelh
#define wx_panelh

#include "common.h"
#include "wx_win.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#ifdef wx_motif
#define PANEL_HSPACING  8
#define PANEL_VSPACING  8
#endif

#ifdef wx_msw
#define PANEL_LEFT_MARGIN 4
#define PANEL_TOP_MARGIN  4
#define PANEL_HSPACING  8
#define PANEL_VSPACING  8
#endif

class wxItem;
class wxFrame;
class wxPanel: public wxWindow
{
 public:
#ifdef wx_motif
  int hSpacing;
  int vSpacing;
  Widget borderWidget;
  Widget panelWidget;
  Widget lastWidget;
  Widget firstRowWidget;
#endif
#ifdef wx_msw
  int cursor_x;
  int cursor_y;
  int max_width;
  int max_height;
  int max_line_height;
  int hspacing;
  int vspacing;
#endif

  Bool new_line;
  int label_position;

  wxPanel(wxFrame *frame,
          int x=-1, int y=-1, int width=-1, int height=-1, int style=0);
  ~wxPanel(void);
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int w, int h);
  void GetPosition(int *x, int *y);

  // Set current label position, i.e. will label be on top or to the left
  // Doesn't do anything right now.
  void SetLabelPosition(int pos);  // wxHORIZONTAL or wxVERTICAL

  // Start a new line
  void NewLine(void);
  // Tab specified number of pixels
  void Tab(int pixels);

  void GetCursor(int *x, int *y);

  // Set/get horizontal spacing
  void SetHorizontalSpacing(int sp);
  int GetHorizontalSpacing(void);

  // Set/get vertical spacing
  void SetVerticalSpacing(int sp);
  int GetVerticalSpacing(void);

  // Fits the panel around the items
  void Fit(void);

  // Update next cursor position
  void AdvanceCursor(wxWindow *item);

  // If x or y are not specified (i.e. < 0), supply
  // values based on left to right, top to bottom layout.
  // Internal use only.
  void GetValidPosition(int *x, int *y);
};

#endif // wx_panelh
