/*
 * File:     wx_privt.h
 * Purpose:  Private class declarations.
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_privth
#define wx_privth

#ifdef wx_motif
#include <Xm/Xm.h>
#include "wx_hash.h"
extern wxHashTable *wxWidgetHashTable;

void wxWidgetResizeProc(Widget w, XConfigureEvent *event, String args[], int *num_args);
// void wxWidgetRepaintProc(Widget w, XtPointer clientData, XtPointer);
#endif

#ifdef wx_msw

/*
 * This is a generic Windows 3 window.
 * I derive from this to create windows for panels, canvases,
 * status bar, text window, frame etc.
 */

class wxWnd : public wxObject
{
public:
    UINT last_msg;
    WPARAM last_wparam;
    LPARAM last_lparam;
    Bool x_scrolling_enabled;
    Bool y_scrolling_enabled;

    int xscroll_pixels_per_line;
    int yscroll_pixels_per_line;
    int xscroll_lines;
    int yscroll_lines;
    int xscroll_lines_per_page;
    int yscroll_lines_per_page;
    int xscroll_position;
    int yscroll_position;
    float last_x_pos;
    float last_y_pos;
    int last_event;
    HWND handle;
    HANDLE accelerator_table;

    Bool is_canvas;
    Bool is_dialog;
    HDC cdc;
    HBRUSH background_brush;

    wxWindow *wx_window;

    wxWnd(void);
    ~wxWnd(void);

    void Create(wxWnd *parent, char *wclass, wxWindow *wx_win, char *title,
               int x, int y, int width, int height,
               DWORD style, char *dialog_template = NULL);

    // Calculates the position of a point on the window
    // taking into account the position of scrollbars.
    // Windows doesn't automatically reflect the position of the
    // scrollbars - (0, 0) is always the top left of the visible window,
    // whereas in XView, (0, 0) moves according to scrollbar positions.
    virtual void CalcScrolledPosition(int x, int y, int *xx, int *yy);

    // Actually defined in wx_canvs.cc since requires wxCanvas declaration
    void DeviceToLogical(float *x, float *y);

    // Calculate logical (scroll-bar/scaling aware) position from
    // device (pixel) position
    virtual void CalcUnscrolledPosition(int x, int y, float *xx, float *yy);

    // Handlers
    virtual void OnCreate(LPCREATESTRUCT cs);
    virtual BOOL OnPaint(void);
    virtual void OnSize(int x, int y, UINT flag);
    virtual void OnHScroll(WORD nSBCode, WORD pos, HWND control);
    virtual void OnVScroll(WORD nSBCode, WORD pos, HWND control);
    virtual BOOL OnCommand(WORD id, WORD cmd, HWND control);
    virtual HBRUSH OnCtlColor(HDC dc, HWND pWnd, UINT nCtlColor);
    virtual BOOL OnEraseBkgnd(HDC pDC);
    virtual void OnMenuSelect(WORD item, WORD flags, HMENU sysmenu);
    virtual BOOL OnClose(void);
    virtual BOOL OnDestroy(void);
    virtual BOOL OnSetFocus(HWND wnd);
    virtual BOOL OnKillFocus(HWND wnd);

    // Canvas-type events
    virtual void OnLButtonDown(int x, int y, UINT flags);
    virtual void OnLButtonUp(int x, int y, UINT flags);

    virtual void OnRButtonDown(int x, int y, UINT flags);
    virtual void OnRButtonUp(int x, int y, UINT flags);

    virtual void OnMouseMove(int x, int y, UINT flags);

    virtual void OnChar(WORD wParam);

    virtual BOOL OnActivate(BOOL flag, BOOL minimized, HWND activate);
    virtual BOOL OnMDIActivate(BOOL flag, HWND activate, HWND deactivate);

    virtual LONG DefWindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam);
    virtual BOOL ProcessMessage(MSG* pMsg);
    virtual void DestroyWindow(void);
};


/*
 * This is a Windows 3 subwindow - panel or canvas
 */

class wxSubWnd : public wxWnd
{
public:
    wxSubWnd(wxWnd *parent, char *wclass, wxWindow *wx_win,
                int x, int y, int width, int height,
                DWORD style, char *dialog_template = NULL);
    ~wxSubWnd(void);

    // Handlers
    BOOL OnPaint(void);
    void OnSize(int x, int y, UINT flag);
    BOOL OnCommand(WORD id, WORD cmd, HWND control);

    // Canvas-type events
    void OnLButtonDown(int x, int y, UINT flags);
    void OnLButtonUp(int x, int y, UINT flags);

    void OnRButtonDown(int x, int y, UINT flags);
    void OnRButtonUp(int x, int y, UINT flags);

    void OnMouseMove(int x, int y, UINT flags);

    void OnChar(WORD wParam);

    void OnHScroll(WORD nSBCode, WORD pos, HWND control);
    void OnVScroll(WORD nSBCode, WORD pos, HWND control);
};

class wxCanvasWnd : public wxSubWnd
{
public:
  wxCanvasWnd(wxWnd *parent, wxWindow *wx_win,
              int x, int y, int width, int height,
              DWORD style);

  // Handlers
  BOOL OnEraseBkgnd(HDC pDC);
};

class wxFrameWnd : public wxWnd
{
public:
    Bool iconized;
    HICON icon;

    wxFrameWnd(wxWnd *parent, char *wclass, wxWindow *wx_win, char *title,
                   int x, int y, int width, int height,
                   DWORD style);
    ~wxFrameWnd(void);

    // Handlers
    BOOL OnPaint(void);
    void OnSize(int x, int y, UINT flag);
    BOOL OnCommand(WORD id, WORD cmd, HWND control);
    BOOL OnClose(void);
    void OnMenuSelect(WORD item, WORD flags, HMENU sysmenu);
};

class wxStatusWnd : public wxWnd
{
public:
    char *status_text;
    int height;
    HBRUSH light_grey_brush;

    wxStatusWnd(wxFrameWnd *parent, int the_height);
    ~wxStatusWnd(void);

    BOOL OnPaint(void);
};

class wxMDIFrame : public wxWnd
{
public:
    HWND client_hwnd;
    wxWnd *current_child;
    Bool iconized;
    HICON icon;
    HMENU window_menu;
    Bool parent_frame_active; // TRUE if MDI Frame is intercepting
                              // commands, not child

    wxMDIFrame(wxWnd *parent, wxWindow *wx_win, char *title=NULL,
                int x=-1, int y=-1, int width=-1, int height=-1);
    ~wxMDIFrame(void);

    void OnCreate(LPCREATESTRUCT cs);
    BOOL OnPaint(void);
    BOOL OnClose(void);
    void OnSize(int x, int y, UINT);
    BOOL OnCommand(WORD id, WORD cmd, HWND control);
    void OnMenuSelect(WORD, WORD, HMENU);
    long DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
    BOOL ProcessMessage(MSG *msg);
    BOOL OnEraseBkgnd(HDC pDC);
};

class wxMDIChild : public wxWnd
{
public:
    Bool active;
    Bool iconized;
    HICON icon;
    wxMDIChild(wxMDIFrame *parent, wxWindow *wx_win, char *title=NULL,
                int x=-1, int y=-1, int width=-1, int height=-1);
    ~wxMDIChild(void);

    BOOL OnMDIActivate(BOOL bActivate, HWND, HWND);
    BOOL OnPaint(void);
    BOOL OnClose(void);
    void OnSize(int x, int y, UINT);
    BOOL OnCommand(WORD id, WORD cmd, HWND control);
    void OnMenuSelect(WORD, WORD, HMENU);
    long DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
    BOOL ProcessMessage(MSG *msg);
    void DestroyWindow(void);
};

#define         wxTYPE_XWND              1
#define         wxTYPE_HWND              2
#define         wxTYPE_HMENU             3
#define         wxTYPE_MDICHILD          4

void wxGetCharSize(HWND wnd, int *x, int *y);
void wxSliderEvent(HWND control, WORD wParam, WORD pos);
wxWnd *wxFindWinFromHandle(HWND hWnd);
extern HICON wxSTD_FRAME_ICON;
#endif

#ifdef wx_xview
#include <xview/server.h>
extern Xv_Server xview_server;
#endif


#endif // wx_privth

