/*
 * File:     wx_timer.h
 * Purpose:  wxTimer - provides simple timer functionality
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_timerh
#define wx_timerh

#ifdef wx_xview
#include <xview/notify.h>
#endif

#ifdef wx_x
#include <sys/time.h>
#endif

#include "common.h"
#include "wx_obj.h"

class wxTimer: public wxObject
{
 public:
#ifdef wx_motif
  int milli;
  long timerId;
#endif
#ifdef wx_xview
  struct itimerval timerval;
#endif
#ifdef wx_msw
  long id;
  int milli;
#endif
 public:
  wxTimer(void);
  ~wxTimer(void);
  virtual Bool Start(int milliseconds = -1); // Start timer
  virtual void Stop(void);                   // Stop timer
  virtual void Notify(void);                 // Override this member
};

// Timer functions (milliseconds)
void wxStartTimer(void);
// Gets time since last wxStartTimer or wxGetElapsedTime
long wxGetElapsedTime(void);

#endif wx_timerh
