/*
 * File:     objects.h
 * Purpose:  Object graphics library demo for wxWindows.
 *           Defines a canvas which repaints its own graphics objects.
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};

// Define a new frame
class MyFrame: public wxFrame
{
  public:
    ObjectCanvas *canvas;
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    Bool OnClose(void);
    void OnMenuCommand(int id);
};

class MyLine: public LineObject
{
 public:
  MyLine(void);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

class MyRectangle: public RectangleObject
{
 public:
  char *label;

  MyRectangle(float width, float height);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);

  // N.B. You could override the OnDraw function to supply additional
  // graphic elements; call RectangleObject::OnDraw first though.
};

class MyEllipse: public EllipseObject
{
 public:
  char *label;

  MyEllipse(float width, float height);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

// Callbacks
void GenericOk(wxButton& but, wxEvent& event);

#define OBJECTS_QUIT         1
#define OBJECTS_ABOUT        2
#define OBJECTS_ELLIPSE      3
#define OBJECTS_RECTANGLE    4
#define OBJECTS_DELETE       5
#define OBJECTS_CONNECT      6
#define OBJECTS_EDIT_TEXT    7

