/*
 * File:     wx_event.cc
 * Purpose:  wxEvent class definition
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-3-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <windows.h>
#include <iostream.h>

#include "common.h"
#include "wx_frame.h"
#include "wx_dc.h"
#include "wx_canvs.h"

wxEvent::wxEvent()
{
#ifdef wx_motif
  event_handle = NULL;
#endif
#ifdef wx_xview
  event_handle = NULL;
#endif
#ifdef wx_msw
  event = 0;
  flags = 0;
  x = 0.0;
  y = 0.0;
#endif
  index = 0;
  string = NULL;
  client_data = NULL;
}

#ifdef wx_xview
wxEvent::wxEvent(Event *x_event)
{
  event_handle = x_event;
  if (x_event)
  {
    x = (float)event_x(event_handle);
    y = (float)event_y(event_handle);
  }
  index = 0;
  string = NULL;
  client_data = NULL;
}
#endif

Bool wxEvent::ControlDown(void)
{
#ifdef wx_motif
  return event_handle->state & ControlMask;
#endif
#ifdef wx_xview
  return event_ctrl_is_down(event_handle);
#endif
#ifdef wx_msw
  return (flags & MK_CONTROL);
#endif
}

Bool wxEvent::ShiftDown(void)
{
#ifdef wx_motif
  return event_handle->state & ShiftMask;
#endif
#ifdef wx_xview
  return event_shift_is_down(event_handle);
#endif
#ifdef wx_msw
  return (flags & MK_SHIFT);
#endif
}

// Is a button event (*doesn't* mean: is any button *down*?)
Bool wxEvent::IsButton(void)
{
#ifdef wx_motif
  return TRUE;
#endif
#ifdef wx_xview
  return event_is_button(event_handle);
#endif
#ifdef wx_msw
  return (event == wxLEFTUP || event == wxLEFTDOWN ||
          event == wxRIGHTUP || event == wxRIGHTDOWN ||
          event == wxMIDDLEUP || event == wxMIDDLEDOWN);
#endif
}

// Any button is down
Bool wxEvent::ButtonDown(void)
{
  return (Button(1) || Button(2) || Button(3));
}

// True if button down (1 = left, 2 = middle, 3 = right)
Bool wxEvent::Button(int but)
{
#ifdef wx_motif
  switch (but)
  {
    case 1:
      return button1Pressed;
      break;
    case 2:
      return button2Pressed;
      break;
    case 3:
      return button3Pressed;
      break;
  }
  return FALSE;
#endif
#ifdef wx_xview
  return event_id(event_handle) == BUT(but);
#endif
#ifdef wx_msw
  return ((but == 1 && (flags & MK_LBUTTON)) ||
          (but == 2 && (flags & MK_MBUTTON)) ||
          (but == 3 && (flags & MK_RBUTTON)));
#endif
}

Bool wxEvent::LeftDown(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonPress && (event_handle->button == Button1));
#endif
#ifdef wx_xview
  return (event_is_down(event_handle) && event_id(event_handle) == BUT(1));
#endif
#ifdef wx_msw
  return (event == wxLEFTDOWN);
#endif
}

Bool wxEvent::MiddleDown(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonPress && (event_handle->button == Button2));
#endif
#ifdef wx_xview
  return (event_is_down(event_handle) && event_id(event_handle) == BUT(2));
#endif
#ifdef wx_msw
  return (event == wxMIDDLEDOWN);
#endif
}

Bool wxEvent::RightDown(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonPress && (event_handle->button == Button3));
#endif
#ifdef wx_xview
  return (event_is_down(event_handle) && event_id(event_handle) == BUT(3));
#endif
#ifdef wx_msw
  return (event == wxRIGHTDOWN);
#endif
}

Bool wxEvent::LeftUp(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonRelease && (event_handle->button == Button1));
#endif
#ifdef wx_xview
  return (event_is_button(event_handle) && event_id(event_handle) == BUT(1) && 
          event_is_up(event_handle));
#endif
#ifdef wx_msw
  return (event == wxLEFTUP);
#endif
}

Bool wxEvent::MiddleUp(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonRelease && (event_handle->button == Button2));
#endif
#ifdef wx_xview
  return (event_is_button(event_handle) && event_id(event_handle) == BUT(2) &&
          event_is_up(event_handle));
#endif
#ifdef wx_msw
  return (event == wxMIDDLEUP);
#endif
}

Bool wxEvent::RightUp(void)
{
#ifdef wx_motif
  return (event_handle->type == ButtonRelease && (event_handle->button == Button3));
#endif
#ifdef wx_xview
  return (event_is_button(event_handle) && event_id(event_handle) == BUT(3) &&
          event_is_up(event_handle));
#endif
#ifdef wx_msw
  return (event == wxRIGHTUP);
#endif
}

Bool wxEvent::Dragging(void)
{
#ifdef wx_motif
  return ((event_handle->type == MotionNotify) && ButtonDown());
  return FALSE;
#endif
#ifdef wx_xview
  return (event_id(event_handle) == LOC_DRAG);
#endif
#ifdef wx_msw
  return ((event == wxMOVE) && ButtonDown());
#endif
}

void wxEvent::Position(float *xpos, float *ypos)
{
#ifdef wx_motif
  *xpos = x;
  *ypos = y;
#endif
#ifdef wx_xview
  *xpos = x;
  *ypos = y;
#endif
#ifdef wx_msw
  *xpos = x;
  *ypos = y;
#endif
}

int wxEvent::Index(void)
{
  return index;
}

char *wxEvent::String(void)
{
  return string;
}

