/*
 * File:     wx_main.cc
 * Purpose:  wxApp implementation
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <windows.h>
#include <iostream.h>
#include <string.h>

#include "common.h"
#include "wx_frame.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_gdi.h"
#include "wx_dc.h"
#include "wx_dialg.h"
#include "wx_privt.h"

wxApp *wxTheApp = NULL;

#ifdef wx_motif
#include <Xm/Xm.h>
wxHashTable *wxWidgetHashTable = NULL;
#endif

#ifdef wx_msw
HANDLE wxhInstance = 0;
extern wxList *wxWinHandleList;
char *wxFrameClassName = "wxFrameClass";
char *wxMDIFrameClassName = "wxMDIFrameClass";
char *wxMDIChildFrameClassName = "wxMDIChildFrameClass";
char *wxPanelClassName = "wxPanelClass";
char *wxCanvasClassName = "wxCanvasClass";
HICON wxSTD_FRAME_ICON = NULL;
HICON wxSTD_MDICHILDFRAME_ICON = NULL;
LONG FAR PASCAL _export
  wxWndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam);
#endif

void wxCleanUp(void);

#ifdef wx_xview
Xv_Server xview_server;
#endif

#ifdef wx_x
main(int argc, char *argv[])
{
  if (!wxTheApp)
  {
    cerr << "wxWindows error: You have to define an instance of wxApp!\n";
    _exit(0);
  }
#ifdef wx_xview
  xview_server = xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
#endif
#ifdef wx_motif
  wxTheApp->topLevel = XtVaAppInitialize(&wxTheApp->appContext, "wxApp",
                         NULL, 0, &argc, argv, NULL, NULL);

  // Add general resize proc
  XtActionsRec rec;
  rec.string = "resize";
  rec.proc = (XtActionProc)wxWidgetResizeProc;
  XtAppAddActions(wxTheApp->appContext, &rec, 1);
  wxWidgetHashTable = new wxHashTable(wxKEY_INTEGER);
#endif
  wxTheColourDatabase = new wxColourDatabase(wxKEY_STRING);
  wxTheColourDatabase->Initialize();

  wxInitializeStockObjects();

  wxTheApp->argc = argc;
  wxTheApp->argv = argv;

  wxTheApp->wx_frame = wxTheApp->OnInit();

  // In XView, must ALWAYS have a main window.
  if (wxTheApp->wx_frame)
    wxTheApp->MainLoop();

  wxCleanUp();
  return wxTheApp->OnExit();
}
#endif

#ifdef wx_msw
void wxInitialize(HANDLE hInstance)
{
  wxSTD_FRAME_ICON = LoadIcon(hInstance, "wxSTD_FRAME");
  wxSTD_MDICHILDFRAME_ICON = LoadIcon(hInstance, "wxSTD_MDICHILDFRAME");

  // Register the frame window class.
  WNDCLASS wndclass;   // Structure used to register Windows class.

  wndclass.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass.lpfnWndProc   = wxWndProc;
  wndclass.cbClsExtra    = 0;
  wndclass.cbWndExtra    = 4;
  wndclass.hInstance     = hInstance;
  wndclass.hIcon         = wxSTD_FRAME_ICON;
  wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
  wndclass.lpszMenuName  = NULL;
  wndclass.lpszClassName = wxFrameClassName;
  RegisterClass( &wndclass );

  // Register the MDI frame window class.
  WNDCLASS wndclass1;   // Structure used to register Windows class.

  wndclass1.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass1.lpfnWndProc   = wxWndProc;
  wndclass1.cbClsExtra    = 0;
  wndclass1.cbWndExtra    = 4;
  wndclass1.hInstance     = hInstance;
  wndclass1.hIcon         = wxSTD_FRAME_ICON;
  wndclass1.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass1.hbrBackground = NULL;
  wndclass1.lpszMenuName  = NULL;
  wndclass1.lpszClassName = wxMDIFrameClassName;
  RegisterClass( &wndclass1 );

  // Register the MDI child frame window class.
  WNDCLASS wndclass4;   // Structure used to register Windows class.

  wndclass4.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass4.lpfnWndProc   = wxWndProc;
  wndclass4.cbClsExtra    = 0;
  wndclass4.cbWndExtra    = 4;
  wndclass4.hInstance     = hInstance;
  wndclass4.hIcon         = wxSTD_MDICHILDFRAME_ICON;
  wndclass4.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass4.hbrBackground = NULL;
  wndclass4.lpszMenuName  = NULL;
  wndclass4.lpszClassName = wxMDIChildFrameClassName;
  RegisterClass( &wndclass4 );

  // Register the panel window class.
  WNDCLASS wndclass2;   // Structure used to register Windows class.
  memset(&wndclass2, 0, sizeof(WNDCLASS));   // start with NULL defaults
  // Use CS_OWNDC to avoid messing about restoring the context
  // for every graphic operation.
  wndclass2.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass2.lpfnWndProc   = wxWndProc;
  wndclass2.cbClsExtra    = 0;
  wndclass2.cbWndExtra    = 4;
  wndclass2.hInstance     = hInstance;
  wndclass2.hIcon         = NULL;
  wndclass2.hCursor       = NULL;
  wndclass2.hbrBackground = GetStockObject( LTGRAY_BRUSH );
  wndclass2.lpszMenuName  = NULL;
  wndclass2.lpszClassName = wxPanelClassName;
  RegisterClass( &wndclass2 );

  // Register the canvas and textsubwindow class name
  WNDCLASS wndclass3;   // Structure used to register Windows class.
  memset(&wndclass3, 0, sizeof(WNDCLASS));   // start with NULL defaults
  // Use CS_OWNDC to avoid messing about restoring the context
  // for every graphic operation.
  wndclass3.style         = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wndclass3.lpfnWndProc   = wxWndProc;
  wndclass3.cbClsExtra    = 0;
  wndclass3.cbWndExtra    = 4;
  wndclass3.hInstance     = hInstance;
  wndclass3.hIcon         = NULL;
  wndclass3.hCursor       = NULL;
  wndclass3.hbrBackground = NULL;
  wndclass3.lpszMenuName  = NULL;
  wndclass3.lpszClassName = wxCanvasClassName;
  RegisterClass( &wndclass3);

  wxWinHandleList = new wxList(wxKEY_INTEGER);
  wxTheColourDatabase = new wxColourDatabase(wxKEY_STRING);
  wxTheColourDatabase->Initialize();
  wxInitializeStockObjects();
}

#endif

// Cleans up any wxWindows internal structures left lying around
void wxCleanUp(void)
{
#ifdef wx_msw
  if (wxSTD_FRAME_ICON)
    DestroyIcon(wxSTD_FRAME_ICON);
  if (wxSTD_MDICHILDFRAME_ICON)
    DestroyIcon(wxSTD_MDICHILDFRAME_ICON);
#endif

  // Destroy all GDI lists, etc.
  delete wxTheBrushList;
  delete wxThePenList;
  delete wxTheIconList;
  delete wxTheFontList;
  delete wxTheBitmapList;

  delete wxTheColourDatabase;

#ifdef wx_xview
  delete wxFontPool;
#endif
}

#ifdef wx_msw

#ifndef _WINDLL

// Main windows entry point
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR m_lpCmdLine,
                    int nCmdShow )
{
  wxhInstance = hInstance;
  wxInitialize(hInstance);

  // Split command line into tokens, as in usual main(argc, argv)
  // form
  char **command = new char*[50];
  int count = 0;
  char *token = 0;
  char *buf = new char[500]; // Hangs around until end of app. in case
                             // user carries pointers to the tokens

  Bool flag = TRUE;
  int i = 0;
  buf[0] = 0;

#ifndef _WINDLL // m_lpCmdLine isn't accessible from a DLL,
                // (it seems to crash anyhow)
  while (flag)
  {
    if (m_lpCmdLine[i] == 0)
    {
      buf[i] = 0;
      flag = FALSE;
    }
    else
    {
      buf[i] = m_lpCmdLine[i];
      i ++;
    }
  }
#endif

  // Get application name
  char name[200];
  ::GetModuleFileName(hInstance, name, 199);
  command[count] = copystring(name);
  count ++;

  token = strtok(buf, " ");
  if (token)
  {
    command[count] = token;
    count ++;

    while (token != NULL)
    {
      token = strtok(NULL, " ");
      if (token)
      {
        command[count] = token;
        count ++;
      }
    }
  }

  if (!wxTheApp)
  {
    wxMessageBox("wxWindows error: You have to define an instance of wxApp!\n");
    return 0;
  }


  wxTheApp->argc = count;
  wxTheApp->argv = command;
  wxTheApp->hInstance = hInstance;

  wxTheApp->wx_frame = wxTheApp->OnInit();
  if (wxTheApp->wx_frame && wxTheApp->wx_frame->handle)
    wxTheApp->wx_frame->Show(TRUE);

  return wxTheApp->MainLoop();
}

#endif // not _WINDLL

#ifdef _WINDLL
extern "C"
int FAR PASCAL LibMain(HINSTANCE hInstance,
	WORD wDataSegment, WORD wHeapSize, LPSTR lpszCmdLine)
{
  wxInitialize(hInstance);

  wxTheApp->argc = 0;
  wxTheApp->argv = NULL;
  wxTheApp->hInstance = hInstance;

  wxTheApp->wx_frame = wxTheApp->OnInit();
  if (wxTheApp->wx_frame && wxTheApp->wx_frame->handle)
    wxTheApp->wx_frame->Show(TRUE);

  return 1;
}
#endif // _WINDLL


#endif // wx_msw

wxApp::wxApp(void)
{
  wx_frame = NULL;
  wxTheApp = this;
  death_processed = FALSE;
}

wxApp::~wxApp(void)
{
}

Bool wxApp::Initialized(void)
{
#ifndef _WINDLL
  if (wx_frame)
    return TRUE;
  else
    return FALSE;
#endif
#ifdef _WINDLL // Assume initialized if DLL (no way of telling)
  return TRUE;
#endif
}

wxFrame *wxApp::OnInit(void)
{
  return NULL;
}

int wxApp::OnExit(void)
{
  return 0;
}

#ifdef wx_msw
/*
 * Get and process a message, returning FALSE if WM_QUIT
 * received.
 *
 */
BOOL wxApp::DoMessage(void)
{
  if (!::GetMessage(&current_msg, NULL, NULL, NULL))
  {
    return FALSE;
  }

  // Process the message
  if (!ProcessMessage(&current_msg))
  {
    ::TranslateMessage(&current_msg);
    ::DispatchMessage(&current_msg);
  }
  return TRUE;
}
#endif

/*
 * Keep trying to process messages until WM_QUIT
 * received
 */

int wxApp::MainLoop(void)
{
#ifdef wx_motif
//  XtRealizeWidget(wxTheApp->topLevel);
  XtAppMainLoop(wxTheApp->appContext);
  return 0;
#endif
#ifdef wx_xview
  Frame frame = (Frame)(wx_frame->GetHandle());
  xv_main_loop(frame);
  return 0;
#endif
#ifdef wx_msw
  Bool keep_going = TRUE;
  while (keep_going)
  {
    while (!::PeekMessage(&current_msg, NULL, NULL, NULL, PM_NOREMOVE) &&
           OnIdle()) {}
    if (!DoMessage())
      keep_going = FALSE;
  }
  wxCleanUp();
  return current_msg.wParam;
#endif
}

#ifdef wx_msw
/*
 * Give all windows a chance to preprocess
 * the message. Some may have accelerator tables, or have
 * MDI complications.
 */
BOOL wxApp::ProcessMessage(MSG *msg)
{
  HWND hWnd;
  wxWnd *wnd = NULL;

  // Anyone for a message? Try youngest descendants first.
  for (hWnd = msg->hwnd; hWnd != NULL; hWnd = ::GetParent(hWnd))
  {
    wxWnd *wnd = wxFindWinFromHandle(hWnd);
    if (wnd)
    {
       if (wnd->ProcessMessage(msg))
         return TRUE;

       // STOP if we've reached the top of the hierarchy!
       if (wx_frame && (wnd == (wxWnd *)wx_frame->handle))
          return FALSE;
    }
  }

  if (wx_frame && ((wxWnd *)wx_frame->handle)->ProcessMessage(msg))
     return TRUE;
  else return FALSE;
}

BOOL wxApp::OnIdle(void)
{
  return FALSE;
}
#endif

void wxExit(void)
{
#ifdef wx_x
  if (wxTheApp)
    wxTheApp->OnExit();
  wxCleanUp();

  _exit(0);
#endif
#ifdef wx_msw
 if (wxTheApp && wxTheApp->wx_frame)
   delete wxTheApp->wx_frame;
#endif
}

// Yield to incoming messages
Bool wxYield(void)
{
#ifdef wx_msw
  MSG msg;
  // We want to go back to the main message loop
  // if we see a WM_QUIT. (?)
  while (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) && msg.message != WM_QUIT)
  {
    if (!wxTheApp->DoMessage())
      break;
  }
#endif

  return TRUE;
}

#ifdef wx_motif
/*
 * Not yet used but may be useful.
 *
 */
void wxSetDefaultResources(const Widget w, const char **resourceSpec, const char *name)
{
   int         i;	
   Display    *dpy = XtDisplay (w);	  // Retrieve the display pointer
   XrmDatabase rdb = NULL;             // A resource data base

   // Create an empty resource database
   rdb = XrmGetStringDatabase ("");

   // Add the Component resources, prepending the name of the component

   i = 0;
   while ( resourceSpec[i] != NULL )
   {
       char buf[1000];

       sprintf(buf, "*%s%s", name, resourceSpec[i++]);
       XrmPutLineResource( &rdb, buf );
   }

   // Merge them into the Xt database, with lowest precendence

   if ( rdb )
   {
#if (XlibSpecificationRelease>=5)
        XrmDatabase db = XtDatabase(dpy);
	XrmCombineDatabase(rdb, &db, FALSE);
#else
        XrmMergeDatabases ( dpy->db, &rdb );
        dpy->db = rdb;
#endif
    }
}
#endif
