/*
 * File:     c2help.cc
 * Purpose:  CLIPS function documentation --> XLP
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <windows.h> // Included only for benefit of MSC7 precompiled headers
#include "tex2any.h"

FILE *Library = NULL;
FILE *Members = NULL;
FILE *Index = NULL;

void Go(void)
{
  char *file = wxFileSelector("Choose LaTeX input file", NULL, NULL, "tex", "*.tex");
  if (file)
  {
    TexLoadFile(file);

    Library = fopen("library.xlp", "w");
    Members = fopen("functions.xlp", "w");
    Index = fopen("index.xlp", "w");

    SetCurrentOutput(Library);

    long id = NewId();
    fprintf(Library, "\\hy-%d{%ld}{CLIPS for HARDY functions}\n",
             BLOCK_LARGE_SECTION, id);
    fprintf(Index, "\n\\hyindex{\n\"CLIPS for HARDY Help\"\n");
    TraverseDocument();
    fprintf(Index, "}\n");

    fclose(Library);
    fclose(Members);
    fclose(Index);

    wxConcatFiles("library.xlp", "functions.xlp", "tmp1.xlp");
    wxConcatFiles("tmp1.xlp", "index.xlp", "clips.xlp");
    wxRemoveFile("tmp1.xlp");

    wxRemoveFile("library.xlp");
    wxRemoveFile("functions.xlp");
    wxRemoveFile("index.xlp");
  }
}

// Define a new application type
class MyApp: public wxApp
{ public:
    wxFrame *OnInit(void);
};

// Define a new frame type
class MyFrame: public wxFrame
{ public:
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    void OnMenuCommand(int id);
};

// ID for the menu quit command
#define TEX_QUIT 1
#define TEX_GO   2

// This statement initializes the whole application and calls OnInit
MyApp myApp;

// `Main program' equivalent, creating windows and returning main app frame
wxFrame *MyApp::OnInit(void)
{
  // Create the main frame window
  MyFrame *frame = new MyFrame(NULL, "c2help", 0, 0, 400, 300);

  // Put names which subsume other names at the TOP
  // so they get recognized first
  AddMacroDef("verbatim", 1);
  AddMacroDef("comment", 1, TRUE);
  AddMacroDef("helpignore", 1, TRUE);
  AddMacroDef("itemize", 1);
  AddMacroDef("enumerate", 1);
  AddMacroDef("item", 0);
  AddMacroDef("chapter", 1);
  AddMacroDef("section", 1);
  AddMacroDef("subsection", 1);
  AddMacroDef("newpage", 0, TRUE);
  AddMacroDef("special", 1, TRUE);
  AddMacroDef("caption", 1, TRUE);
  AddMacroDef("figure", 1, TRUE);
  AddMacroDef("class", 1);
  AddMacroDef("functionsection", 1);
  AddMacroDef("member", 2);
  AddMacroDef("hardy", 0);
  AddMacroDef("func", 3);
  AddMacroDef("pfunc", 3);
  AddMacroDef("param", 2);
  AddMacroDef("destruct", 1);
  AddMacroDef("void", 0);
  AddMacroDef("cinsert", 0);
  AddMacroDef("cextract", 0);
  AddMacroDef("label", 1, TRUE);
  AddMacroDef("ref", 1);
  AddMacroDef("helpref", 1);
  AddMacroDef("it", 1);
  AddMacroDef("bf", 1);
  AddMacroDef("tt", 1);
  AddMacroDef(" ", 0);
  AddMacroDef("\\", 0);
  AddMacroDef("/", 0);
  AddMacroDef("_", 0);
  AddMacroDef("&", 0);


  TexInitialize();

  // Make a menubar
  wxMenu *file_menu = new wxMenu;
  file_menu->Append(TEX_GO, "Go");
  file_menu->Append(TEX_QUIT, "Quit");
  wxMenuBar *menu_bar = new wxMenuBar;
  menu_bar->Append(file_menu, "File");
  frame->SetMenuBar(menu_bar);

  frame->Show(TRUE);

  // Return the main frame window
  return frame;
}

// My frame constructor
MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{}

// Intercept menu commands
void MyFrame::OnMenuCommand(int id)
{
  switch (id) {
    case TEX_QUIT:
      delete this;
      break;
    case TEX_GO:
      Go();
      break;
    break;
  }
}

// Called on start/end of macro examination
void OnMacro(char *name, int no_args, Bool start)
{
  char buf[100];

  if (strcmp(name, "section") == 0)
  {
    if (start)
    {
      SetCurrentOutputs(Library, Members);
      long id1 = NewId();
      long id2 = NewId();
      fprintf(Library, "  \\hy-%d{%ld}{", BLOCK_RED, id1);
      fprintf(Members, "\n\\hy-%d{%ld}{", BLOCK_LARGE_SECTION, id2);
      fprintf(Index, "%ld %ld\n", id1, id2);
    }
    else
    {
      fprintf(Library, "}\n\n");
      fprintf(Members, "}");
      SetCurrentOutput(Members);
    }
  }
  else if (strcmp(name, "functionsection") == 0)
  {
    if (start)
    {
      SetCurrentOutputs(Library, Members);
      long id1 = NewId();
      long id2 = NewId();
      fprintf(Library, "\\hy-%d{%ld}{", BLOCK_RED, id1);
      fprintf(Members, "\\hy-%d{%ld}{", BLOCK_LARGE_SECTION, id2);
      fprintf(Index, "%ld %ld\n", id1, id2);
    }
    else
    {
      fprintf(Library, "}\n\n");
      fprintf(Members, "}");
      SetCurrentOutput(Members);
    }
  }
/*
  else if (strcmp(name, "func") == 0)
  {
    SetCurrentOutput(Members);
    if (start)
    {
      long id = NewId();
      fprintf(Members, "\\hy-%d{%ld}{", BLOCK_BOLD, id);
    }
    else
      fprintf(Members, "}");
  }
*/
  else if ((strcmp(name, "void") == 0) && start)
    TexOutput("void");
  else if ((strcmp(name, "hardy") == 0) && start)
    TexOutput("HARDY");
  else if ((strcmp(name, "cinsert") == 0) && start)
    TexOutput("<<");
  else if ((strcmp(name, "cextract") == 0) && start)
    TexOutput(">>");
  else if ((strcmp(name, "destruct") == 0) && start)
    TexOutput("~");
  else if ((strcmp(name, "_") == 0) && start)
    TexOutput("_");
  else if ((strcmp(name, "&") == 0) && start)
    TexOutput("&");
  else if (strcmp(name, "verbatim") == 0)
  {
    if (start)
    {
      long id = NewId();
      sprintf(buf, "\\hy-%d{%ld}{", BLOCK_TELETYPE, id);
      TexOutput(buf);
    }
    else TexOutput("}");
  }
  else if ((strcmp(name, "subsection") == 0) || (strcmp(name, "bf") == 0) || (strcmp(name, "helpref") == 0))
  {
    if (start)
    {
      long id = NewId();
      sprintf(buf, "\\hy-%d{%ld}{", BLOCK_BOLD, id);
      TexOutput(buf);
    }
    else TexOutput("}");
  }
  else if (strcmp(name, "it") == 0)
  {
    if (start)
    {
      long id = NewId();
      sprintf(buf, "\\hy-%d{%ld}{", BLOCK_ITALIC, id);
      TexOutput(buf);
    }
    else TexOutput("}");
  }
  else if (strcmp(name, "item") == 0)
  {
    if (start)
    {
      TexOutput(" -- ");
    }
  }
  else
  {
  }
}

// Called on start/end of argument examination
void OnArgument(char *macro_name, int arg_no, Bool start)
{
  char buf[100];
  if (strcmp(macro_name, "func") == 0)
  {
    if (!start && (arg_no == 1))
      TexOutput(" ");
    if (start && (arg_no == 2))
    {
      TexOutput("(");
      long id = NewId();
      sprintf(buf, "\\hy-%d{%ld}{", BLOCK_BOLD, id);
      TexOutput(buf);
    }
    if (!start && (arg_no == 2))
    {
      TexOutput("}");
    }
    if (!start && (arg_no == 3))
     TexOutput(")");
  }
  if (strcmp(macro_name, "param") == 0)
  {
    if (start && (arg_no == 2))
    {
      long id = NewId();
      sprintf(buf, " \\hy-%d{%ld}{", BLOCK_BOLD, id);
      TexOutput(buf);
    }
    if (!start && (arg_no == 2))
    {
      TexOutput("}");
    }
  }
}

