/* Copyright (C) 1992, 1993 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* nmman.h */
/* New memory manager internal definitions for Ghostscript */
/****** FIX THIS ******/
/*#include "gxbitmap.h" **/
#define align_bitmap_mod 4

/* ====== Allocator ====== */

/* Define the alignment modulus for aligned objects. */
#define alloc_align_mod\
  max(max(arch_align_long_mod, arch_align_ptr_mod),\
      max(arch_align_double_mod, align_bitmap_mod))
#define log2_alloc_align_mod small_exact_log2(alloc_align_mod)
#define alloc_align_mask (alloc_align_mod-1)
#define alloc_align_round(siz)\
  (uint)(((siz) + alloc_align_mask) & -alloc_align_mod)
#define alloc_size_round(siz)\
  alloc_align_round((siz) + sizeof(struct_header_t))

/* Structure header. */
/* There are 3 different formats, as indicated below. */
/* Note that we force the size of a structure header to be a multiple of */
/* alloc_align_mod.  The structure size does not include the header, */
/* and is not rounded. */
typedef union struct_header_s struct_header_t;
	/* Flags in all formats */
struct struct_header_h_s {
	unsigned mark : 1, large : 1, bytes : 1;
};
	/* Ordinary typed structure: large = 0, bytes = 0 */
struct struct_header_s_s {
	unsigned _ : 3, reloc8 : 13;
	at_ptr_t type;
};
	/* Plain (but aligned) bytes: large = 0, bytes = 1 */
struct struct_header_b_s {
	unsigned _ : 3, reloc8 : 13;
	ushort size;
};
	/* Large bytes (in a chunk by themselves): large = 1, bytes = 1 */
struct struct_header_l_s {
	unsigned _ : 3, lsize : 13;
	ushort size;
};
union struct_header_s {
	struct struct_header_h_s h;
	struct struct_header_s_s s;
	struct struct_header_b_s b;
	struct struct_header_l_s l;
	/* Force size up to a multiple of alloc_align_mod */
	byte _[alloc_align_round(sizeof(struct struct_header_s_s))];
};
#define struct_contents_size(shp)\
  ((shp)->h.bytes ? (shp)->b.size : (shp)->s.type->size)
#define struct_rounded_size(shp)\
  alloc_size_round(struct_contents_size(shp))
#define struct_large_size(shp)\
  (((ulong)(shp)->l.lsize << 16) + (shp)->l.size)
#define struct_next(shp)\
  ((struct_header_t *)((byte *)(shp) + struct_rounded_size(shp)))

/* ====== Chunks ====== */

#define declare_chunk_procs(dscope, ctype, init, status, gc_init, next_component, gc_set_reloc, gc_do_reloc, gc_compact)\
\
		/* Initialize the chunk. */\
	dscope void init(P3(ctype *, byte *, usize_t));\
\
		/* Return the space allocated and used. */\
	dscope void status(P2(ctype *, alloc_status_t *));\
\
	/**** The rest of the procedures are only for the GC. ****/\
\
		/* Initialize for a GC by clearing marks. */\
	dscope void gc_init(P1(ctype *));\
\
		/* Return a pointer to the next component. */\
	dscope ptr_type_t next_component(P2(ctype *, void **));\
\
		/* Compute and store relocation amounts. */\
	dscope void gc_set_reloc(P2(ctype *, cl_ptr_t));\
\
		/* Relocate pointers. */\
	dscope void gc_do_reloc(P2(ctype *, cl_ptr_t));\
\
		/* Compact to remove unmarked components. */\
	dscope void gc_compact(P1(ctype *))

#define chunk_procs_struct(ctype)\
  struct {\
    declare_chunk_procs(, ctype, (*init), (*status), (*gc_init), (*next_component), (*gc_set_reloc), (*gc_do_reloc), (*gc_compact));\
  }
typedef chunk_procs_struct(chunk_t) chunk_procs_t;
#define chunk_common\
  const chunk_procs_t _ds *procs;\
  byte *cbot, *ctop;\
  chunk_t *cprev, *cnext		/* sorted by address */
struct chunk_s {
  chunk_common;
};

/* Find the chunk for a pointer. */
#define ptr_is_in_chunk(ptr, cp)\
  ptr_between((byte *)ptr, (cp)->cbot, (cp)->ctop)
struct chunk_locator_s {
  chunk_t *cp;				/* one-element cache */
};
extern bool chunk_locate_ptr(P2(byte *, cl_ptr_t));
#define chunk_locate(ptr, clp)\
  (ptr_is_in_chunk((byte *)(ptr), (clp)->cp) ||\
   chunk_locate_ptr((byte *)(ptr), clp))

/* Allocate a chunk. */
extern chunk_t *alloc_add_chunk(P4(as_ptr_t, at_ptr_t, uint,
  const chunk_procs_t _ds *));

/* ------ Concrete chunks ------ */

/* Many small structures. */
typedef struct {
  chunk_common;
  struct_header_t *top;
} chunk_structs_t;

/* One large structure. */
typedef struct {
  chunk_common;
} chunk_large_struct_t;

/* Refs and strings. */
typedef struct {
  chunk_common;
  struct ref_s *rtop;
  byte *ibot, *itop;
  /* Rest is for GC */
  byte *ibits;
  byte *ibase;
  usize_t ibitsize;
  ushort *ireloc;
  uint imove;
} chunk_refs_t;

/* ====== Definition of allocator state ====== */

typedef struct std_alloc_state_s std_alloc_state_t;
struct std_alloc_state_s {
  alloc_state_common;
  chunk_structs_t ccs;			/* current structs chunk */
  chunk_structs_t *pccs;		/* where to put ccs */
  chunk_refs_t ccrs;			/* current refs chunk */
  chunk_refs_t *pccrs;			/* where to put ccrs */
  uint chunk_size;
  uint large_size;			/* min size for large chunk */
  gc_root_t *roots;
  chunk_t chunk_min, chunk_max;		/* head and tail of chunk list */
};

/* Cast an as_ptr_t argument to a std_alloc_state_t. */
#define asp ((std_alloc_state_t *)ap)
