/*
class FileName


deals with File names
				OtherDir(char * a) - this directory will also be searched

 BOOL   ValidFile(char * a) - finds the file in the current directory,
					 or path, or default directory (if given)

 char * ShortenName(int n)
					- Returns the fully qualified file name
					limited to n characters.  Removes whole subdirectories from
					the begginning of of the full file name until the remaining
					text is shorter than n.  "..." is added to the beginning of
					the returned text.
					- Values of n less than 16 are not accepted.
					- If no file is present, returns null

*/

	#include <iostream.h>
	#include <fstream.h>

	#ifndef __STRING_H
		#include <string.h>
	#endif

	#ifndef __DIR_H
		#include <dir.h>
	#endif


	#ifndef __WINDOWS_H
		#include <windows.h>
	#endif


	#ifndef __NOD1_H
	#include "nod1.h"
	#endif

	#ifndef __FILE_H
		#include "file.h"
	#endif


	BOOL FileName::ValidFile(void)
	{
		return bValidFile;
	}
	char * FileName::JustName(void)
	{
		return szFile;
	}

	char * FileName::ShortName(int n)
	{
		char szTemp[MAXPATH];

		if (!bValidFile)
			return NULL;
		if (n < 16)
			return NULL;

		if (strlen(szFile) > n)
		{
			strcpy(szTemp,szFullQFile);
			n=n-4;

			do
				strcpy(szTemp,(char *)strchr(szTemp,'\\')+1);
			while (strlen(szTemp)>n);

			strcpy(szShortFile,"...\\");
			strcat(szShortFile,szTemp);

			return szShortFile;
		}
		else
		{
			return szFullQFile;
		}
	}

	char * FileName::LongName(void)
	{
		return szFullQFile;
	}


/* Evaluate the filename as follows:

- If the filename is a valid fully qualified filename,
	go to that directory and set the file name.
- If the command line is just a filename, search in the current directory
	then the XtrDir.  If the file is valid, go to that directory and
	set the file name.
- If the command line is a valid directory, go to that directory and set
	XtrDir to that directory.

*/

	BOOL FileName::SetFile(char * szA)
	{
		OFSTRUCT o;
		int i;

		bValidFile=FALSE;

/* if the filename contains a colon, switch to that disk before
testing further */

		if (szA[1] == ':')
		{
			i=(int) (szA[0]-'A');

			if (i>31)
				i=i-32;

			setdisk(i);
		}

/* first test the file name as is.  If the name is fully qualified,
or the file is in the current or path directories this will test true.
If the file is not in any of these, it is considered to not exist. */

		if (-1 != OpenFile((char * far) szA,&o,OF_READ|OF_EXIST) )
		{
			bValidFile=TRUE;
			strcpy(szFullQFile,(char *)o.szPathName);

			if (_fstrrchr((char far *)o.szPathName,'\\') != NULL)
			{
				strcpy(szFile,
					(char *) (_fstrrchr((char far *)o.szPathName,'\\')+1) );
			}
			else
			{
				strcpy(szFile,(char *)o.szPathName);
			}

		}

		return bValidFile;

	}


