	#ifndef __FILE_H
	#define __FILE_H

	#ifndef __DIR_H
		#include <dir.h>
	#endif

/*---------------------------------------------------------
FileName class

used to deal with disk files

PUBLIC:

	BOOL SetFile(char *) - set the file name to the passed string.  The
			file must be on the current directory, or the PATH.  If the filename
			contains a drive indication (A:, B:, etc) the drive is changed first.
			Returns	TRUE if the file is found, FALSE otherwise.

	BOOL ValidFile(void) - returns TRUE if the current filename is of
			a valid disk file.

	char* JustName(void) - returns only the name of the current file, not
			the path.

	char* ShortName(int n) - returns the full file name shortened to n
			characters.	Subdirectories are removed from the beginning of
			the full file name until the length is less than or equal to n.
			"..." is prepended to the returned string to indicate part of the
			path has been dropped.

	char* LongName(void) - returns the fully qualified file name.

PROTECTED:

	BOOL bValidFile - TRUE if the current file is valid.
	char szFullQFile[] - the fully qualified file name.

-----------------------------------------------------------*/


	class FileName
	{
	public:
		BOOL SetFile(char *);

		BOOL ValidFile(void);
		char * JustName(void);
		char * ShortName(int);
		char * LongName(void);

	protected:
		BOOL bValidFile;
		char szFullQFile[MAXPATH];

	private:
		char szFile[MAXPATH];
		char szShortFile[MAXPATH];
	};

	#endif

