/*
NODCHILD.CPP

code for child windows for the NoD program

*/

	#ifndef __WINDOWS_H
		#include <Windows.h>
	#endif  // __WINDOWS_H

	#ifndef __NODCHILD_H
		#include "Nodchild.h"
	#endif

	#ifndef __STRING_H
		#include <string.h>
	#endif

	#ifndef __NOD1_H
		#include "nod1.h"
	#endif




/*------------------------------------------------ Child Classes

*/

	void DBox::create(HWND hA)
	{

		HDC hdc;
		TEXTMETRIC tm;
		int cxChar,cyChar;
		char *text="ICK!";

		hParent=hA;

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		ReleaseDC(hParent,hdc);

		hwndChild=CreateWindow
			("button",text,WS_CHILD|WS_VISIBLE|SS_CENTER,
			XDBOX,YDBOX,CXDBOX,CYDBOX,
			hParent,MYCW_ICKBUTTON,WinBase::hInst,NULL);
		set(FALSE);
	}

	void DBox::set(BOOL a=TRUE)
	{
		if (a)
		{
			ShowWindow(hwndChild,SW_SHOWNORMAL);
			EnableWindow(hwndChild,TRUE);
		}
		else
		{
			ShowWindow(hwndChild,SW_HIDE);
			EnableWindow(hwndChild,FALSE);
		}

	}

/*-----------------------------------------------
*/


	void GoButton::create(HWND hA)
	{

		HDC hdc;
		TEXTMETRIC tm;
		int cxChar,cyChar;
		text="Take It Out";

		hParent=hA;

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		ReleaseDC(hParent,hdc);

		hwndChild=CreateWindow
			("button",text,WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
			XGOBUTTON,YGOBUTTON,CXGOBUTTON,CYGOBUTTON,
			hParent,MYCW_GOBUTTON,WinBase::hInst,NULL);
	}

/*------------------------------------------------------------*/


	void FirstLine::create(HWND hA)
	{
		HDC hdc;
		TEXTMETRIC tm;
		int cxChar,cyChar;
		text="nothing yet";

		hParent=hA;

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		ReleaseDC(hParent,hdc);

		hwndChild=CreateWindow
			("static",text,WS_CHILDWINDOW|WS_VISIBLE|SS_LEFT,
			XFILEFIELD,YFILEFIELD,CXFILEFIELD,CYFILEFIELD,
			hParent,MYCW_FIRSTLINE,WinBase::hInst,NULL);
	}

	void FirstLine::set(char* a)
	{
		SetWindowText(hwndChild,(LPSTR) a);
	}

/*--------------------------------------------------------------------*/

	void FileList::create(HWND hA)
	{
		HDC hdc;
		TEXTMETRIC tm;
		int cxChar,cyChar;

		hParent=hA;
		if (strlen(szMask)==0)
			mask("*.*");

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight;
		ReleaseDC(hParent,hdc);

		hwndChild=CreateWindow
			("listbox",NULL,WS_CHILDWINDOW|WS_VISIBLE|LBS_STANDARD,
			XFILELIST,YFILELIST,CXFILELIST,CYFILELIST,
			hParent,MYCW_FILELIST,WinBase::hInst,NULL);

		reset();

		bValidFile=FALSE;
	}

	DWORD FileList::send(WORD msg,WORD wParam,long lParam)
	{
		return SendMessage(hwndChild,msg,wParam,lParam);
	}

	void FileList::mask(char *a)
	{
		strcpy(szMask,a);
	}


	BOOL FileList::fileClick(void)
	{
		int index;
		char szBuffer[MAXPATH];
		OFSTRUCT ofs;

		if (LB_ERR ==	(index= (WORD) send(LB_GETCURSEL,0,0L)) )
				return FALSE;

		send(LB_GETTEXT,index,(LONG) (char far *) szBuffer);

		bValidFile =
			( OpenFile(szBuffer,&ofs,OF_EXIST|OF_READ) != -1 ? TRUE : FALSE ) ;
		if (bValidFile)
			strcpy(szFileName,(char *)ofs.szPathName);

		return TRUE;
	}


	BOOL FileList::validFile(void)
	{
		return bValidFile;
	}

	char* FileList::getFile(void)
	{
		return szFileName;
	}

	void FileList::reset(void)
	{
		send(LB_RESETCONTENT,0,0L);
		send(LB_DIR,0x0,(LONG)(LPSTR) szMask);
	}

/*--------------------------------------------------------------------
DirList code
*/

	void DirList::create(HWND hA)
	{
		HDC hdc;
		TEXTMETRIC tm;
		char szTemp[MAXPATH];
		int cxChar,cyChar;

		hParent=hA;

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight;
		ReleaseDC(hParent,hdc);

		hwndChild=CreateWindow
			("listbox",NULL,WS_CHILDWINDOW|WS_VISIBLE|LBS_STANDARD,
			XDIRLIST,YDIRLIST,CXDIRLIST,CYDIRLIST,
			hParent,MYCW_DIRLIST,WinBase::hInst,NULL);

		reset();


/* This object creates this box and keeps the handle.
Control is not allowed outside the object. */

		hDirField=CreateWindow
			("static"," ",WS_CHILDWINDOW|WS_VISIBLE|SS_LEFT,
			XDIRFIELD,YDIRFIELD,CXDIRFIELD,CYDIRFIELD,
			hParent,MYCW_DIRFIELD,WinBase::hInst,NULL);

		getcwd(szDirName,MAXPATH);

		if (strlen(szDirName) > WIDTHDIRFIELD)
		{
			strcpy(szTemp,szDirName);
			do
				strcpy(szTemp,(char *)strchr(szTemp,'\\')+1);
			while (strlen(szTemp)>WIDTHDIRFIELD-4);

			strcpy(szDirName,"...\\");
			strcat(szDirName,szTemp);
		}
		SetWindowText(hDirField,szDirName);

	}

	DWORD DirList::send(WORD msg,WORD wParam,long lParam)
	{
		return SendMessage(hwndChild,msg,wParam,lParam);
	}


	BOOL DirList::dirClick(void)
	{
		int index;

		char szBuffer[MAXPATH];

		if (LB_ERR ==	(index= (WORD) send(LB_GETCURSEL,0,0L)) )
				return FALSE;

		send(LB_GETTEXT,index,(LONG) (char far *) szBuffer);

		if (strstr(szBuffer,"[-") != 0)
		{
			setdisk((int) (szBuffer[2]) -  'a');
		}

		else
		{
			szBuffer[strlen(szBuffer)-1] = '\0';
			chdir(szBuffer+1);
		}

		getcwd(szDirName,MAXPATH);
		reset();

		if (strlen(szDirName) > WIDTHDIRFIELD)
		{
			strcpy(szBuffer,szDirName);
			do
				strcpy(szBuffer,(char *)strchr(szBuffer,'\\')+1);
			while (strlen(szBuffer)>WIDTHDIRFIELD-4);

			strcpy(szDirName,"...\\");
			strcat(szDirName,szBuffer);
		}
		SetWindowText(hDirField,szDirName);


		return TRUE;
	}

	void DirList::reset(void)
	{
		send(LB_RESETCONTENT,0,0L);
		send(LB_DIR,0xc010,(LONG)(LPSTR) "*.*");
	}

/*---------------------------------------------------------------
FileFinder code
-------------------------------------------------------------*/

	void FileFinder::create(HWND hParent)
	{
		HDC hdc;
		TEXTMETRIC tm;
		int cxChar,cyChar;

		hdc=GetDC(hParent);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight;
		ReleaseDC(hParent,hdc);

		FileList::create(hParent);
		DirList::create(hParent);


	}

	void FileFinder::reset(void)
	{
		FileList::reset();
		DirList::reset();
	}

	BOOL FileFinder::dirClick()
	{
		BOOL i;
		i=DirList::dirClick();
		FileList::reset();
		return i;
	}

	void FileFinder::send(void)
	{
	}
