/*

NODCL.CPP
version 1.1

Command line version of No ^D program.
This program will remove the ^D from the first line of a Postscript
file.  Since it is a Windows program, it can be set up as an association
and used easily from the file manager.

written by James D. Rudnicki
jdrudnicki@lbl.gov
last update Septmeber 1991

written with Borland C++ 2.0 */


// Access the libraries needed

	#if !defined(__WINDOWS_H)
		#include <windows.h>
	#endif

	#include <stdlib.h>
	#include <stdio.h>
	#include <iostream.h>
	#include <fstream.h>


	#ifndef __STRING_H
		#include <string.h>
	#endif

	#ifndef __DIR_H
		#include <dir.h>
	#endif

// symbol table

	#ifndef __NOD1_H
		#include "nod1.h"
	#endif

	#ifndef __PS_H
		#include "ps.h"
	#endif

/*-------------------------------------------------------------
	No Window is opened by this program.  All proccesing takes place
in WinMain.

The command line should contain a file name.
The program will search for the file in the current directory or
anywhere on the PATH.  If it is not found there, it will change to
the directory defined in the private profile file, PRIVATEINI.
If the file is found, it is tested to determine if it is a
Postscript file with a ^D on the first line.  If it is, the ^D is
removed.

-------------------------------------------------------------*/


	int PASCAL WinMain
		(HANDLE hInstance,HANDLE hPrev,LPSTR lpszCmdLine,int nCmdShow)
	{
		char szDefDir[MAXPATH];
		char szNearCmd[MAXPATH];

		_fstrcpy((char * far)szNearCmd,lpszCmdLine);

		PSFile A;

		if (A.SetFile(szNearCmd))
		{
			if(A.test())
				if(1==A.strip())
					MessageBox(NULL,"File Cleaned","No ^D",MB_OK);
		}
		else
		{
			GetPrivateProfileString
				("NoDee","DefDir","",szDefDir,MAXPATH,PRIVATEINI);

			if (0==chdir(szDefDir))
				if (A.SetFile(szNearCmd))
					if(A.test())
						if(1==A.strip())
							MessageBox(NULL,"File Cleaned","No ^D",MB_OK);
		}
		return 0;
	}

