/*

NOCTRL.CPP
version 1.2

written by James D. Rudnicki
jdrudnicki@lbl.gov
last update Septmeber 1991

written with Borland C++ 2.0 */

// Access the libraries needed

	#ifndef __WINDOWS_H
		#include <windows.h>
	#endif

	#include <stdlib.h>
	#include <stdio.h>
	#include <iostream.h>
	#include <fstream.h>

	#ifndef __STRING_H
		#include <string.h>
	#endif

	#ifndef __DIR_H
		#include <dir.h>
	#endif


// symbol tables
	#ifndef __NOD1_H
	#include "nod1.h"
	#endif

	#ifndef __PS_H
		#include "ps.h"
	#endif


/*-------------------------------------------
All dialog boxes are included from a separate file.
An independent symbol table is used. */

	#ifndef __CLASSWIN_H
		#include <classwin.h>
	#endif
	#ifndef _NODDLGS_H
		#include "noddlgs.h"
	#endif
	#ifndef __NODCHILD_H
		#include "nodchild.h"
	#endif


/*------------------------------------------------------------
 The Main Window class

NoDWindow - constructor reads the private profile strings

~NoDWindow - writes out the private profile strings

*/

	#pragma arsused

	class NoDWindow : public Window
	{
	public:
		NoDWindow();
		~NoDWindow();

	protected:
		virtual LONG dispatch(WORD,WORD,LONG);
		virtual BOOL registerClass();
		virtual BOOL createWindow();

	private:

/* defaults from Private profile*/

		char szDefDir[MAXPATH];
		BOOL bOneClick;
		BOOL bInstantStrip;
		BOOL bUseFileMask;
		BOOL bFirstRun;
		char szFileMask[MAXFULLFILE];

// member data

		static char szClassName[14];
		int cxChar,cxCaps,cyChar;
		int cxClient,cyClient,cxBit,cyBit;
		HMENU hMenu;

// these member functions process commands

		BOOL processMenuCommand(WORD,long);
		BOOL processChildCommand(WORD,long);

// these member functions are the workers

		void flash(BOOL);

		void helpAboutBox(void);
		void paint( void );

// child windows are declared here and created later

		GoButton gb;
		FirstLine fl;
		FileFinder childFileList;

// one Postscript file is needed

		PSFile PSCleanFile;

	};


	char NoDWindow::szClassName[] = "No ^D !";

/* The constructor and destructors read and write the default
values to the private initialization file */

	NoDWindow::NoDWindow()
	{
		if	(GetPrivateProfileString
				("NoDee","Mask","",szFileMask,MAXFULLFILE,PRIVATEINI) != 0)
		{
			bFirstRun=FALSE;

			GetPrivateProfileString
				("NoDee","DefDir","",szDefDir,MAXPATH,PRIVATEINI);

			bOneClick =
				(GetPrivateProfileInt("NoDee","OneClick",1,PRIVATEINI) == 0)
				? FALSE : TRUE;

			bInstantStrip =
				(GetPrivateProfileInt("NoDee","InstantStrip",1,PRIVATEINI) == 0)
				 ? FALSE : TRUE;

			bUseFileMask =
				(GetPrivateProfileInt("NoDee","UseMask",1,PRIVATEINI) == 0)
				 ? FALSE : TRUE;

		}
		else
		{
			bFirstRun=TRUE;
			strcpy(szFileMask,"*.PS");
			bOneClick=FALSE;
			bInstantStrip=FALSE;
			bUseFileMask=FALSE;
		}
	}

	NoDWindow::~NoDWindow()
	{
		WritePrivateProfileString
			("NoDee","Mask",szFileMask,PRIVATEINI);

		WritePrivateProfileString
			("NoDee","DefDir",szDefDir,PRIVATEINI);

		WritePrivateProfileString
			("NoDee","OneClick",bOneClick ? "1" : "0",PRIVATEINI);

		WritePrivateProfileString
			("NoDee","InstantStrip",bInstantStrip ? "1":"0",PRIVATEINI);

		WritePrivateProfileString
			("NoDee","UseMask",bUseFileMask ? "1" : "0",PRIVATEINI);
	}

/* Define the members of NoDWindow */


		BOOL NoDWindow::registerClass( void )
		{
			WNDCLASS wc;

			wc.style         = CS_HREDRAW | CS_VREDRAW;
			wc.lpfnWndProc   = &Window::wndProc;
			wc.cbClsExtra    = 0;
			wc.cbWndExtra    = 0;
			wc.hInstance     = hInst;
			wc.hIcon         = LoadIcon( hInst, "nodee" );
			wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
			wc.hbrBackground = GetStockObject( WHITE_BRUSH );
			wc.lpszMenuName  = "MENU";
			wc.lpszClassName = (LPSTR)szClassName;

			return RegisterClass( &wc ) ;
		}


		BOOL NoDWindow::createWindow( void )
		{
			HDC hdc;
			TEXTMETRIC tm;
			char szTemp[MAXPATH];

			hdc=CreateIC("DISPLAY",NULL,NULL,NULL);
			SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
			GetTextMetrics(hdc,&tm);
			cxChar=tm.tmAveCharWidth;
			cyChar=tm.tmHeight+tm.tmExternalLeading;
			ReleaseDC(hWindow,hdc);

			hWindow = CreateWindow
				( szClassName,
					szClassName,
					WS_OVERLAPPED|WS_SYSMENU|WS_CAPTION|
					WS_DLGFRAME|WS_VISIBLE|WS_MINIMIZEBOX,
					CW_USEDEFAULT,CW_USEDEFAULT,
					CXMYWINDOW,CYMYWINDOW,
					NULL,
					NULL,
					hInst,
					NULL);

			if ( hWindow==0 )	return( FALSE );
			insert();

/* Evaluate the command line as follows:

- If the command line is a valid fully qualified filename,
	go to that directory and set the file name.
- If the command line is just a filename, search in the current directory
	then the DefDir.  If the file is valid, go to that directory and
	set the file name.
- If the command line is a valid directory, go to that directory.
- Go to the default directory.

*/

			OFSTRUCT o;
			char * i;

			_fstrncpy((char far *)szTemp,(char far *) (WinBase::cmd),MAXPATH);

			if (szTemp[1] == ':')
			{
				strlwr(szTemp);
				setdisk((int) (szTemp[0]) -  'a');
			}

			if (_fstrlen(WinBase::cmd) != 0)
			{
				if (-1 != OpenFile(WinBase::cmd,&o,OF_READ|OF_EXIST) )
				{

					if (_fstrrchr((char far *)o.szPathName,'\\') != NULL)
					{
						strcpy(szTemp,(char *)o.szPathName);
						i = strrchr(szTemp,'\\') ;
						*i = '\0';
						chdir(szTemp);
						PSCleanFile.SetFile((char *)o.szPathName);
					}
					else
					{
						PSCleanFile.SetFile((char *)o.szPathName);
					}

				}
				else
				{
					chdir(szDefDir);

					if (-1 != OpenFile(WinBase::cmd,&o,OF_READ|OF_EXIST) )
					{
						PSCleanFile.SetFile((char *)o.szPathName);
					}
					else
					{
						_fstrncpy((char far *)szTemp,(char far *) (WinBase::cmd),MAXPATH);
						if (chdir(szTemp) != 0 )
							chdir(szDefDir);
					}
				}
			}
			else
			{
				chdir(szDefDir);
			}


/* Initialize the menu states. The checks are set and the
menu text is adjusted to indicate the mask indicated in the
private profile file */

			hMenu=GetMenu(hWindow);
			strcpy(szTemp,"Use Mask ");
			strcat(szTemp,szFileMask);
			ModifyMenu(hMenu, IDM_OPT1C, MF_BYCOMMAND||MF_STRING,
				IDM_OPT1C, (LPSTR) szTemp);

			CheckMenuItem(hMenu,IDM_OPT1A,bInstantStrip ? MF_CHECKED:MF_UNCHECKED);
			CheckMenuItem(hMenu,IDM_OPT1B,bOneClick ? MF_CHECKED:MF_UNCHECKED);
			CheckMenuItem(hMenu,IDM_OPT1C,bUseFileMask ? MF_CHECKED:MF_UNCHECKED);

/* create child windows */

			gb.create(hWindow);
			fl.create(hWindow);

			EnableWindow(gb.getHandle(),FALSE);

			if(PSCleanFile.ValidFile())
				fl.set(PSCleanFile.JustName());
			else
				fl.set("nothing selected");

			childFileList.mask(bUseFileMask ? szFileMask : "*.*" );
			childFileList.create(hWindow);

			if (PSCleanFile.ValidFile())
				PSCleanFile.test();

/* initialize the cursor */

			SetClassWord
				(childFileList.FileList::getHandle(), GCW_HCURSOR,	bInstantStrip ?
				LoadCursor(hInst,"NODEE"):LoadCursor(NULL,IDC_ARROW) );


			ShowWindow(hWindow,show );
			UpdateWindow(hWindow);


/* if first time running the program launch the
help application */

			if (bFirstRun)
				WinHelp(hWindow,HELPFILE,HELP_INDEX,NULL);

			return TRUE;
		}


	void NoDWindow::paint( void )
	{
		PAINTSTRUCT ps;
		HDC hdc;
		hdc=BeginPaint( hWindow, &ps );
		TextOut(hdc,XFILETAG,YFILETAG,"Testing File:",13);
		TextOut(hdc,XDIRTAG,YDIRTAG,"Directory:",10);
		EndPaint( hWindow, &ps );
	}

	void NoDWindow::flash(BOOL a)
	{
		BITMAP bm;
		HDC hdcMem;
		DWORD dwSize;
		POINT ptSize,ptOrg;
		HANDLE hPoint,hDC;
		DWORD lParam;

		if (a)
		{

		hPoint=LoadBitmap(WinBase::hInst,"D1");

		hDC=GetDC(hWindow);
		hdcMem=CreateCompatibleDC(hDC);
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		DeleteDC(hdcMem);
		ReleaseDC(hWindow,hDC);

		}
		else
		{


		hDC=GetDC(hWindow);
		hdcMem=CreateCompatibleDC(hDC);

		hPoint=LoadBitmap(WinBase::hInst,"D1");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D2");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D3");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D4");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D4");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D5");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		DeleteDC (hdcMem);
		ReleaseDC(hWindow,hDC);

		}

	}


	void NoDWindow::helpAboutBox()
	{
		AboutBox x(hWindow);
		x.run();
	}

	BOOL NoDWindow::processMenuCommand(WORD wParam, long lParam)
	{
		switch(wParam)
		{
		case IDM_OPT1A:
			bInstantStrip=!bInstantStrip;
			if (bInstantStrip)
			{
				CheckMenuItem(hMenu,IDM_OPT1A,MF_CHECKED);
				SetClassWord
					(childFileList.FileList::getHandle(),GCW_HCURSOR,LoadCursor(hInst,"NODEE"));
			}
			else
			{
				CheckMenuItem(hMenu,IDM_OPT1A,MF_UNCHECKED);
				SetClassWord
					(childFileList.FileList::getHandle(),GCW_HCURSOR,LoadCursor(NULL,IDC_ARROW));
			}
			if (bInstantStrip && PSCleanFile.test())
				PSCleanFile.strip();
			return TRUE;

		case IDM_OPT1B:
			CheckMenuItem(hMenu,IDM_OPT1B,(bOneClick = !bOneClick) ?
				MF_CHECKED:MF_UNCHECKED);
			return TRUE;

		case IDM_OPT1C:
			CheckMenuItem(hMenu,IDM_OPT1C,(bUseFileMask = !bUseFileMask) ?
				MF_CHECKED:MF_UNCHECKED);
			childFileList.mask(bUseFileMask ? szFileMask : "*.*" );
			childFileList.reset();
			return TRUE;


		case IDM_H1B:
			helpAboutBox();
			flash(FALSE);
			return TRUE;

		case IDM_H1C:
			WinHelp(hWindow,HELPFILE,HELP_INDEX,NULL);
			return TRUE;

		default:
			return FALSE;
		}
	}

	BOOL NoDWindow::processChildCommand(WORD wParam, long lParam)
	{
		int i;
		switch(wParam)
		{
		case MYCW_ICKBUTTON:
		case MYCW_GOBUTTON:
			PSCleanFile.strip();
			if (PSCleanFile.test())
			{
				EnableWindow(gb.getHandle(),TRUE);
				SetFocus(gb.getHandle());
			}
			else
			{
				EnableWindow(gb.getHandle(),FALSE);
				SetFocus(hWindow);
			}
			return TRUE;

		case MYCW_FILELIST:
			if ( (HIWORD (lParam) == LBN_DBLCLK ) ||
					 bOneClick && (HIWORD (lParam) == LBN_SELCHANGE) )
			{
				if (childFileList.fileClick())
				{
					if (childFileList.validFile())
					{
						PSCleanFile.SetFile(childFileList.getFile());
						fl.set(PSCleanFile.JustName());
						if (PSCleanFile.test())
						{
							if (bInstantStrip)
							{
								PSCleanFile.strip();
							}
							else
							{
							EnableWindow(gb.getHandle(),TRUE);
							SetFocus(gb.getHandle());
							}
						}
						else
						{
							EnableWindow(gb.getHandle(),FALSE);
							SetFocus(hWindow);
						}
					}
					return TRUE;
				}
			}
			return FALSE;

		case MYCW_DIRLIST:
		case MYCW_DIRFIELD:
			if ( (HIWORD (lParam) == LBN_DBLCLK ) ||
					 bOneClick && (HIWORD (lParam) == LBN_SELCHANGE) )
			{
				if (childFileList.dirClick())
				{
					fl.set("none selected");
					EnableWindow(gb.getHandle(),FALSE);
					SetFocus(hWindow);
					return TRUE;
				}
			}
			return FALSE;

		}
		return FALSE;
	}

/* This is the big switch

NOTE: Do no process the WM_CREATE message here.
Upon the WM_CREATE message, the handle hWnd is not yet
valid.  Do not use the handle until the CreateWindow call in the
constructor has completed execution.  Any code which need be executed
on creation can be placed in the create function .

This differs from normal C programs.  When CreateWindow sends the WM_CREATE
message, the window handle is also passed to WndProc.  Thereby, the
first processing of WM_CREATE will have access to the handle. */

	long NoDWindow::dispatch( WORD iMessage, WORD wParam, LONG lParam )
	{
		switch (iMessage)
		{

			case WM_PAINT:
				paint();
				return 0;

			case WM_SIZE:
				cxClient=LOWORD(lParam);
				cyClient=HIWORD(lParam);
				return 0;

/* commands are send to the Menu processor, and then the Child processor
If neither of these routines indicates it handled the command, the
default procedure will be called. */

			case WM_COMMAND:
				if(processMenuCommand(wParam,lParam))
					return 0;
				if(processChildCommand(wParam,lParam))
					return 0;
				break;

/* catch this message - The file list should be updated when the
program has not been active. */

			case WM_ACTIVATEAPP:
				if(wParam != 0)
				{
					childFileList.reset();
					SetClassWord
						(childFileList.FileList::getHandle(),GCW_HCURSOR,bInstantStrip?
						LoadCursor(hInst,"NODEE"):LoadCursor(NULL,IDC_ARROW) );
				}
				else
				{
					SetClassWord
						(childFileList.FileList::getHandle(), GCW_HCURSOR,
						 LoadCursor(NULL,IDC_ARROW) );
				}

				return 0;

			case WM_DESTROY:
				SetClassWord
				(childFileList.FileList::getHandle(), GCW_HCURSOR,
				 LoadCursor(NULL,IDC_ARROW) );
				WinHelp(hWindow,HELPFILE,HELP_QUIT,NULL);

				PostQuitMessage( 0 );
				return 0;

		}

		return Window::dispatch( iMessage, wParam, lParam );

	}


/*-------------------------------------------------------------
This is the end of the Main program.  The following procedures are
called from Windows directly */



	int PASCAL WinMain
		(HANDLE hInstance,HANDLE hPrev,LPSTR lpszCmdLine,int nCmdShow)
	{
		WinBase::hInst = hInstance;
		WinBase::hPrevInst = hPrev;
		WinBase::cmd = lpszCmdLine;
		WinBase::show = nCmdShow;

		NoDWindow A;
		A.create();
		return A.run();
	}

