/*  No control D
NOCTRL.CPP

written by James D. Rudnicki

written in  C++ Version */

// Access the libraries needed

	#if !defined(__WINDOWS_H)
		#include <windows.h>
	#endif

	#include <stdlib.h>
	#include <stdio.h>
	#include <iostream.h>
	#include <fstream.h>

	#ifndef __STRING_H
		#include <string.h>
	#endif

/* Attach a debug header - to remove debug code compile
with compiler switch -D NDEBUG  */

//	#include "debug.h"

// symbol tables
	#ifndef __NOD1_H
	#include "nod1.h"
	#endif


/*-------------------------------------------
All dialog boxes are included from a separate file.
An independent symbol table is used. */

	#ifndef __CLASSWIN_H
		#include "classwin.h"
	#endif
	#ifndef _NODDLGS_H
		#include "noddlgs.h"
	#endif
	#ifndef __NODCHILD_H
		#include "nodchild.h"
	#endif


/*------------------------------------------------------------
 The Main Window class

NoDWindow - constructor reads the private profile strings

~NoDWindow - writes out the private profile strings

*/

	#pragma arsused

	class NoDWindow : public Window
	{
	public:
		NoDWindow();
		~NoDWindow();

	protected:
		virtual LONG dispatch(WORD,WORD,LONG);
		virtual BOOL registerClass();
		virtual BOOL createWindow();

	private:

/* defaults */

		char szDefDir[MAXPATH];
		BOOL bOneClick;
		BOOL bInstantStrip;
		BOOL bUseFileMask;
		BOOL bFirstRun;
		char szFileMask[MAXFULLFILE];

// member data

		static char szClassName[14];
		char szBuffer[MAXPATH];
		char szFile[MAXPATH];
		char szCleanFile[MAXPATH];
		int cxChar,cxCaps,cyChar;
		int cxClient,cyClient,cxBit,cyBit;
		BOOL bValidFile;
		HMENU hMenu;
		OFSTRUCT ofs;

// these member functions process commands

		BOOL processMenuCommand(WORD,long);
		BOOL processChildCommand(WORD,long);

// these member functions are the workers

		void flash(BOOL);

		void helpAboutBox(void);
		void helpWroteBox(void);
		void paint( void );
		int strip();
		BOOL test();


// child windows are declared here and created later

		GoButton gb;
		FirstLine fl;
		FileFinder childFileList;
		DBox dbox;


	};


	char NoDWindow::szClassName[] = "No ^D !";

/* The constructor and destructors read and write the default
values to the private initialization file */

	NoDWindow::NoDWindow()
	{
		if	(GetPrivateProfileString
				("NoDee","Mask","",szFileMask,MAXFULLFILE,"nodee.ini") != 0)
		{
			bFirstRun=FALSE;

			GetPrivateProfileString
				("NoDee","DefDir","",szDefDir,MAXPATH,"nodee.ini");

			bOneClick =
				(GetPrivateProfileInt("NoDee","OneClick",1,"nodee.ini") == 0)
				? FALSE : TRUE;

			bInstantStrip =
				(GetPrivateProfileInt("NoDee","InstantStrip",1,"nodee.ini") == 0)
				 ? FALSE : TRUE;

			bUseFileMask =
				(GetPrivateProfileInt("NoDee","UseMask",1,"nodee.ini") == 0)
				 ? FALSE : TRUE;

		}
		else
		{
			bFirstRun=TRUE;
			strcpy(szFileMask,"*.PS");
			bOneClick=FALSE;
			bInstantStrip=FALSE;
			bUseFileMask=FALSE;
		}
	}

	NoDWindow::~NoDWindow()
	{
		WritePrivateProfileString
			("NoDee","Mask",szFileMask,"nodee.ini");

		WritePrivateProfileString
			("NoDee","DefDir",szDefDir,"nodee.ini");

		WritePrivateProfileString
			("NoDee","OneClick",bOneClick ? "1" : "0","nodee.ini");

		WritePrivateProfileString
			("NoDee","InstantStrip",bInstantStrip ? "1":"0","nodee.ini");

		WritePrivateProfileString
			("NoDee","UseMask",bUseFileMask ? "1" : "0","nodee.ini");
	}

/* Define the members of NoDWindow */


		BOOL NoDWindow::registerClass( void )
		{
			WNDCLASS wc;

			wc.style         = CS_HREDRAW | CS_VREDRAW;
			wc.lpfnWndProc   = &Window::wndProc;
			wc.cbClsExtra    = 0;
			wc.cbWndExtra    = 0;
			wc.hInstance     = hInst;
			wc.hIcon         = LoadIcon( hInst, "nodee" );
			wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
			wc.hbrBackground = GetStockObject( WHITE_BRUSH );
			wc.lpszMenuName  = "MENU";
			wc.lpszClassName = (LPSTR)szClassName;

			return RegisterClass( &wc ) ;
		}


		BOOL NoDWindow::createWindow( void )
		{
			HDC hdc;
			TEXTMETRIC tm;
			int cx,cy;
			cx=GetSystemMetrics(SM_CXSCREEN);
			cy=GetSystemMetrics(SM_CYSCREEN);

			hWindow = CreateWindow
				( szClassName,
					szClassName,
					WS_OVERLAPPED|WS_SYSMENU|WS_CAPTION|
					WS_DLGFRAME|WS_VISIBLE|WS_MINIMIZEBOX,
					CW_USEDEFAULT,CW_USEDEFAULT,
					3*cx/4,3*cy/4,
					NULL,
					NULL,
					hInst,
					NULL);

			if ( hWindow==0 )	return( FALSE );
			insert();

/* the window handle is now valid - initialize global parameters */

			hdc=GetDC(hWindow);
			SelectObject(hdc,GetStockObject(SYSTEM_FONT));
			GetTextMetrics(hdc,&tm);
			cxChar=tm.tmAveCharWidth;
			cyChar=tm.tmHeight+tm.tmExternalLeading;
			cxCaps=(tm.tmPitchAndFamily & 1 ? 3 : 2) * cxChar/2;
			ReleaseDC(hWindow,hdc);

			hMenu=GetMenu(hWindow);

/* create child windows */

			dbox.create(hWindow);
			gb.create(hWindow);
			fl.create(hWindow);
			fl.set(szCleanFile);

			childFileList.mask(bUseFileMask ? szFileMask : "*.*" );
			childFileList.create(hWindow);

/* initialize the menu states and child windows */

			SetClassWord
				(childFileList.FileList::getHandle(), GCW_HCURSOR,	bInstantStrip ?
				LoadCursor(hInst,"NODEE"):LoadCursor(NULL,IDC_ARROW) );

			CheckMenuItem(hMenu,IDM_OPT1A,bInstantStrip ? MF_CHECKED:MF_UNCHECKED);
			CheckMenuItem(hMenu,IDM_OPT1B,bOneClick ? MF_CHECKED:MF_UNCHECKED);
			CheckMenuItem(hMenu,IDM_OPT1C,bUseFileMask ? MF_CHECKED:MF_UNCHECKED);


			if (_fstrlen(WinBase::cmd)==0)
				strcpy(szCleanFile,"nothing selected");
			else
				strcpy(szCleanFile,(char *)WinBase::cmd);

			test();

			ShowWindow(hWindow,show );
			UpdateWindow(hWindow);

			if (bFirstRun)
				WinHelp(hWindow,HELPFILE,HELP_INDEX,NULL);

			return TRUE;
		}


	void NoDWindow::paint( void )
	{
		PAINTSTRUCT ps;
		HDC hdc;
		RECT rect;
		hdc=BeginPaint( hWindow, &ps );
		TextOut(hdc,cxChar,cyChar,
			"Stripping ^D from:",18);
		EndPaint( hWindow, &ps );
	}

	void NoDWindow::flash(BOOL a)
	{
		BITMAP bm;
		HDC hdcMem;
		DWORD dwSize;
		POINT ptSize,ptOrg;
		HANDLE hPoint,hDC;
		DWORD lParam;

		if (a)
		{

		hPoint=LoadBitmap(WinBase::hInst,"D1");

		hDC=GetDC(hWindow);
		hdcMem=CreateCompatibleDC(hDC);
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		DeleteDC(hdcMem);
		ReleaseDC(hWindow,hDC);

		}
		else
		{


		hDC=GetDC(hWindow);
		hdcMem=CreateCompatibleDC(hDC);

		hPoint=LoadBitmap(WinBase::hInst,"D1");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D2");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D3");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D4");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D4");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		hPoint=LoadBitmap(WinBase::hInst,"D5");
		SelectObject(hdcMem,hPoint);
		SetMapMode(hdcMem,GetMapMode(hDC));
		GetObject(hPoint,sizeof(BITMAP),(LPSTR) &bm);
		ptSize.x=bm.bmWidth;
		ptSize.y=bm.bmHeight;
		DPtoLP(hDC,&ptSize,1);
		ptOrg.x=0;
		ptOrg.y=0;
		DPtoLP(hdcMem,&ptOrg,1);
		BitBlt(hDC,cxClient-ptSize.x,0,ptSize.x,ptSize.y,
						hdcMem,ptOrg.x,ptOrg.y,SRCCOPY);

		DeleteDC (hdcMem);
		ReleaseDC(hWindow,hDC);

		}

	}

	int NoDWindow::strip()
	{
		char str[80];
		int j,i;
		OFSTRUCT o;

		OpenFile((LPSTR)szCleanFile,&o,OF_READ|OF_EXIST);

		ifstream io((char *)o.szPathName);
		if ( !io )
		{
			MessageBox(hWindow,"File did not open",
				(LPSTR)szCleanFile,MB_ICONSTOP|MB_OK);
			return 0;
		}
		else
		{
			io.getline(str,80);
			io.close();
			if (strchr(str,4) != NULL);
			{
				fstream io((char *)o.szPathName,ios::in|ios::out);
				io.seekp(0,ios::beg);

				j=strlen(str);
				for(i=0;i<j;i++)
					if ( str[i] != 0x4)
						io.put(str[i]);
				io.close();

				if (! bInstantStrip)
				MessageBox(hWindow,"File cleaned",
					(LPSTR)szCleanFile,MB_ICONEXCLAMATION|MB_OK);

				dbox.unset();
				EnableWindow(gb.getHandle(),FALSE);
				SetFocus(hWindow);
				return 1;
			}
		}
		return 0;
	}

#define SZPOSTSCRIPT "%!PS"
	#pragma argsused
	BOOL NoDWindow::test()
	{
		char str[80];
		char str2[80];
		BOOL i,j;
		OFSTRUCT o;

		OpenFile((LPSTR)szCleanFile,&o,OF_READ|OF_EXIST);

		ifstream io((char *)o.szPathName);
		if ( io )
		{
			io.getline(str,80);
			io.close();
			i=(strstr(str,SZPOSTSCRIPT) != (char*)NULL) ;
			j=(strchr(str,4) != (char *)NULL);
			if (i && j)
			{
				dbox.set();
				EnableWindow(gb.getHandle(),TRUE);
				SetFocus(gb.getHandle());
				return TRUE;
			}
		}
		dbox.unset();
		EnableWindow(gb.getHandle(),FALSE);
		SetFocus(hWindow);
		return FALSE;
	}


	void NoDWindow::helpWroteBox()
	{
		WhoWroteBox x(hWindow);
		x.run();
	}

	void NoDWindow::helpAboutBox()
	{
		AboutBox x(hWindow);
		x.run();
	}

	#pragma argsused
	BOOL NoDWindow::processMenuCommand(WORD wParam, long lParam)
	{
		switch(wParam)
		{
		case IDM_OPT1A:
			bInstantStrip=!bInstantStrip;
			if (bInstantStrip)
			{
				CheckMenuItem(hMenu,IDM_OPT1A,MF_CHECKED);
				SetClassWord
					(childFileList.FileList::getHandle(),GCW_HCURSOR,LoadCursor(hInst,"NODEE"));
			}
			else
			{
				CheckMenuItem(hMenu,IDM_OPT1A,MF_UNCHECKED);
				SetClassWord
					(childFileList.FileList::getHandle(),GCW_HCURSOR,LoadCursor(NULL,IDC_ARROW));
			}
			if (bInstantStrip && test())
				strip();
			return TRUE;

		case IDM_OPT1B:
			CheckMenuItem(hMenu,IDM_OPT1B,(bOneClick = !bOneClick) ?
				MF_CHECKED:MF_UNCHECKED);
			return TRUE;

		case IDM_OPT1C:
			CheckMenuItem(hMenu,IDM_OPT1C,(bUseFileMask = !bUseFileMask) ?
				MF_CHECKED:MF_UNCHECKED);
			childFileList.mask(bUseFileMask ? szFileMask : "*.*" );
			childFileList.reset();
			return TRUE;


		case IDM_H1A:
			helpWroteBox();
			flash(TRUE);
			return TRUE;

		case IDM_H1B:
			helpAboutBox();
			flash(FALSE);
			return TRUE;

		case IDM_H1C:
			WinHelp(hWindow,HELPFILE,HELP_INDEX,NULL);
			return TRUE;

		default:
			return FALSE;
		}
	}

	BOOL NoDWindow::processChildCommand(WORD wParam, long lParam)
	{
		int i;
		switch(wParam)
		{
		case MYCW_ICKBUTTON:
		case MYCW_GOBUTTON:
			strip();
			return TRUE;

		case MYCW_FILELIST:
			if ( (HIWORD (lParam) == LBN_DBLCLK ) ||
					 bOneClick && (HIWORD (lParam) == LBN_SELCHANGE) )
			{
				if (childFileList.fileClick())
				{
					if (childFileList.validFile())
					{
						strcpy(szCleanFile,childFileList.getFile());
						fl.set(szCleanFile);
						if (test() && bInstantStrip)
							strip();
					}
					return TRUE;
				}
			}
			return FALSE;

		case MYCW_DIRLIST:
		case MYCW_DIRFIELD:
			if ( (HIWORD (lParam) == LBN_DBLCLK ) ||
					 bOneClick && (HIWORD (lParam) == LBN_SELCHANGE) )
			{
				if (childFileList.dirClick())
				{
					fl.set("none selected");
					return TRUE;
					dbox.unset();
					EnableWindow(gb.getHandle(),FALSE);
					SetFocus(hWindow);
				}
			}
			return FALSE;

		}
		return FALSE;
	}

/* This is the big switch

NOTE: Do no process the WM_CREATE message here.
Upon the WM_CREATE message, the handle hWnd is not yet
valid.  Do not use the handle until the CreateWindow call in the
constructor has completed execution.  Any code which need be executed
on creation can be placed in the create function .

This differs from normal C programs.  When CreateWindow sends the WM_CREATE
message, the window handle is also passed to WndProc.  Thereby, the
first processing of WM_CREATE will have access to the handle. */

	long NoDWindow::dispatch( WORD iMessage, WORD wParam, LONG lParam )
	{
		switch (iMessage)
		{

			case WM_PAINT:
				paint();
				return 0;

			case WM_SIZE:
				cxClient=LOWORD(lParam);
				cyClient=HIWORD(lParam);
				return 0;

/* commands are send to the Menu processor, and then the Child processor
If neither of these routines indicates it handled the command, the
default procedure will be called. */

			case WM_COMMAND:
				if(processMenuCommand(wParam,lParam))
					return 0;
				if(processChildCommand(wParam,lParam))
					return 0;
				break;

/* catch this message - The file list should be updated when the
program has not been active. */

			case WM_ACTIVATEAPP:
				if(wParam != 0)
				{
					childFileList.reset();
					SetClassWord
						(childFileList.FileList::getHandle(),GCW_HCURSOR,bInstantStrip?
						LoadCursor(hInst,"NODEE"):LoadCursor(NULL,IDC_ARROW) );
				}
				else
				{
					SetClassWord
						(childFileList.FileList::getHandle(), GCW_HCURSOR,
						 LoadCursor(NULL,IDC_ARROW) );
				}

				return 0;

			case WM_DESTROY:
				SetClassWord
				(childFileList.FileList::getHandle(), GCW_HCURSOR,
				 LoadCursor(NULL,IDC_ARROW) );
				WinHelp(hWindow,HELPFILE,HELP_QUIT,NULL);

				PostQuitMessage( 0 );
				return 0;

		}

		return Window::dispatch( iMessage, wParam, lParam );

	}


/*-------------------------------------------------------------
This is the end of the Main program.  The following procedures are
called from Windows directly */



	int PASCAL WinMain
		(HANDLE hInstance,HANDLE hPrev,LPSTR lpszCmdLine,int nCmdShow)
	{
		WinBase::hInst = hInstance;
		WinBase::hPrevInst = hPrev;
		WinBase::cmd = lpszCmdLine;
		WinBase::show = nCmdShow;

		NoDWindow A;
		A.create();
		return A.run();
	}

