/* program to mark windows executables so win3 does not nag about
 * compatibility.  does not solve problems of compatibility, however.
 */
#define LINT_ARGS
#include <stdio.h>
#include <stdlib.h>

/*----------------------------------------------- prototypes ---------------*/
int main( int ac, char *av[] );

/*----------------------------------------------- main ---------------------*/
int main( int ac, char *av[] )
{
    FILE *ioExe;
    int uBuffer[0x21C], uIndex;

    if (ac != 2) {
	fprintf( stderr,
		 "usage is\n\tnonag <windows .exe file with extension>\n" );
	exit( 1 );
    }
    else if (!(ioExe = fopen( av[1], "r+b" ))) {
	perror( av[1] );
	exit( 1 );
    }
    if (fread( uBuffer, 0x9F, 1, ioExe ) != 1) {
	fprintf( stderr, "Can't read header from %s\n", av[1] );
	exit( 1 );
    }
    if (uBuffer[0] != 0x5A4D) {
	fprintf( stderr, "File %s format not as expected; file not marked.\n", av[1] );
	exit( 1 );
    }
    uIndex = uBuffer[0x1E];
    if (fseek( ioExe, (unsigned long)uIndex, SEEK_SET )) {
	fprintf( stderr, "Can't seek on file %s to read new .exe header\n", av[1] );
	exit( 1 );
    }
    if (fread( uBuffer, 0x1C * sizeof( uBuffer[0] ), 1, ioExe ) != 1) {
	fprintf( stderr, "Can't read new .exe header from %s\n", av[1] );
	exit( 1 );
    }
    if (uBuffer[0] != 0x454E || uBuffer[0x1B] != 0x0002) {
	fprintf( stderr, "File %s format not as expected; file not marked.\n", av[1] );
	exit( 1 );
    }
    uBuffer[0x1B] = 0x0402;
    if (fseek( ioExe, (unsigned long)uIndex, SEEK_SET )) {
	fprintf( stderr, "Can't seek on file %s for re-write\n", av[1] );
	exit( 1 );
    }
    else if (fwrite( uBuffer, 0x1C * sizeof( uBuffer[0] ), 1, ioExe ) != 1) {
	fprintf( stderr, "Re-write to %s failed.\n", av[1] );
	exit( 1 );
    }
    return( 0 );
}
