
The subdirectories of this directory contain source code for the Emacs
facilities written in Emacs Lisp.  *.el files are Elisp source, and *.elc
files are byte-compiled versions of the corresponding *.el files.
Byte-compiled files are architecture-independent.

When emacs starts up, it adds all subdirectories of this directory to the
load-path (the list of directories to be searched when loading files.)  To
speed up this process, this directory has been rearranged to have very few
files at the top-level, so that emacs doesn't have to stat() several hundred
files to find the dozen or so which are actually subdirectories.

Directories whose names begin with "-" or "." are not added to the default
load-path.

The only files which remain at top-level are those which you might reasonably
want to alter when installing or customizing emacs at your site.  The files
at top level are:

	paths.el	You may need to change the default pathnames here.

	site-init.el	To pre-load additional libraries into emacs, load them
			from this file.

	site-load.el	This is like site-init.el, but if you want the 
			docstrings of your preloaded libraries to be kept in
			the DOC file instead of in the executable, you should
			load them from this file instead.  To do this, you must
			also cause them to be scanned when the DOC file is
			generated by editing ../src/ymakefile.

	version.el	This file is automatically altered when emacs is built.


These are the main subdirectories:

	prim		Fundamental emacs functionality.  Some of this is
			pre-dumped with emacs, some is autoloaded.

	utils		Various utility functions that some other emacs
			packages build on.  These are not user commands.

	modes		Text-editing and programming-language-sensitive modes.

	emulators	Emacs can emulate a few different editors.  These are
			a bit more than what `modes' generally are.

	term		Terminal-specific customization files.  When Emacs
			starts, it checks the $TERM environment variable to
			see what type of terminal the user is running on, and
			loads a file named $TERM.el from this directory, if
			that file exists.

	sunview		SunView-specific code.

	vms		VMS-specific code.

	x11		X Window System-specific code.

	packages	Random other utilities that are not primarily about
			editing text.  For example, code for automatically
			uncompressing .Z files would be here.  This is an
			`everything else' sort of directory.

Some packages are fairly large; those have been given their own	directories:

	bytecomp	The emacs-lisp compiler.

	calendar	A calendar and appointment manager.

	comint		General code for interacting with inferior processes,
			like shell buffers and lisp interpreters.

	dired		The directory editor.

	electric	The "electric" commands; these implement temporary
			windows for help, list-buffers, etc.

	gnus		An NNTP-based newsreader; version 3.13.

	ilisp		A comint-based package for interacting with inferior
			lisp processes.

	rmail		A BABYL-format mail reader.

	vm		View Mail, an UNIX-format alternative to RMAIL.
