/*
 * Windows Kermit dialog box routines
 *
 * Copyright (c) 1990, 1991 by
 * William S. Hall
 * 3665 Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOKANJI
#define NOMINMAX
#define NOATOM
#define NOSOUND
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>	
#ifdef COLUMBIA
#include "wkasci.h"
#include "wkkerm.h"
#include "wkkdlg.h"
#else
#include "ascii.h"
#include "wnkerm.h"
#include "wnkdlg.h"
#endif

#define MAXPATHLEN	128
static char *defstring = "*.*";		/* default file type */
BOOL fOverflow;

/* local function declarations */
static	void	NEAR	krmProtocolInit(HWND hDlg);
static	void	NEAR	krmProtocolSet(HWND hDlg);
static	void	NEAR	krmPacketsInit(HWND hDlg);
static	void	NEAR	krmPacketsSet(HWND hDlg);
static	void	NEAR	krmSetCancelFlags(HWND hDlg);
static	void	NEAR	krmSendFileInit(HWND hDlg);
static	int	NEAR	krmCheckSelect(HWND hDlg);
static	void	NEAR	krmGetSendFileList(HWND hDlg, LONG lParam);
static	BOOL	NEAR	krmListSelect(HWND hDlg, LONG lParam);
static	void	NEAR	krmListBoxOK(HWND hDlg, LONG lParam);
static	void	NEAR	krmPathSelect(HWND hDlg, LONG lParam);
static	int	NEAR	GetCheckedRadioButton(HWND hDlg, WORD start, WORD end);
static  int	NEAR	GetComboboxSelection(HWND hDlg, WORD id, char * buffer);
static	int	NEAR	GetComboboxIndex(HWND hDlg, int id);
static  char*   NEAR    getnamestr(char *str, int len);
static  void	NEAR	krmGetFileInit(HWND hDlg);
static  HANDLE	NEAR	krmGetFileSet(HWND hDlg);
static	void	NEAR	krmCWDInit(HWND hDlg);
static	HANDLE	NEAR	krmCWDSet(HWND hDlg);
static	void	NEAR	krmInitRemoteBox(HWND hDlg);
static	void	NEAR	krmRemote1ParamInit(register HWND hDlg, int mode);
static	HANDLE	NEAR	krmRemote1ParamSet(register HWND hDlg, int mode);
static	void	NEAR	krmRemote1ParamEnable(HWND hDlg, HWND hctl, int mode);
static	HANDLE	NEAR	krmRemote1ParamCommand(HWND hDlg);
static	HANDLE	NEAR	krmRemote1ParamGeneric(HWND hDlg, char cmd);
static	void	NEAR	krmLocalInit(HWND hDlg);
static	void	NEAR	krmLocalFilesOK(HWND hDlg);
static	void	NEAR	krmLocalDirs(HWND hDlg, LONG lParam);
static	void	NEAR	setoemconvert(HWND hDlg, WORD id);

/*
 * krmOpenDlgBox
 *
 * Open a modal dialog box
 */
int FAR krmOpenDlgBox(HWND hWnd, FARPROC fpProc, WORD boxnum)
{

    FARPROC fp;
    BOOL result;

  /* make a proc instance for the about box window function */
    fp = MakeProcInstance(fpProc, Kermit.hInst);
  /* create a modal dialog box */
    result = DialogBox(Kermit.hInst, MAKEINTRESOURCE(boxnum),hWnd,fp);
    FreeProcInstance(fp);
    return result;

}

/*
 * krmProtocol
 *
 * This dialog box sets general parameters affecting the
 * Kermit protocol.
 */
BOOL FAR PASCAL krmProtocol(HWND hDlg,unsigned message,WORD wParam,LONG lParam)
{
    switch(message) {
	case WM_INITDIALOG:
	krmProtocolInit(hDlg);
	break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDOK:
		    krmProtocolSet(hDlg);
		    EndDialog(hDlg, TRUE);
		    break;
		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;
		default:
		    return FALSE;
	    }
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

/*
 * krmProtocolSet
 *
 * In response to values chosen by the user, this
 * routine sets the various protocol data structures.
 * If requested, values are saved to WIN.INI
 */
static void NEAR krmProtocolSet(HWND hDlg)
{

    char szAppStr[80];
    char szKeyStr[80];
    char szValStr[80];

    KermParams.Bell = IsDlgButtonChecked(hDlg, IDD_KRM_BELL);
    KermParams.Timer = IsDlgButtonChecked(hDlg, IDD_KRM_TIMER);
    KermParams.DiscardPartialFile = IsDlgButtonChecked(hDlg, IDD_KRM_DISCARD);
    KermParams.FileWarning = IsDlgButtonChecked(hDlg, IDD_KRM_FILEWARNING);
//    KermParams.verbose = IsDlgButtonChecked(hDlg, IDD_KRM_VERBOSE);

    KermParams.BlockCheckType = GetCheckedRadioButton(hDlg, 
					IDD_KRM_1BYTECHK,
					IDD_KRM_3BYTECHK)
				- IDD_KRM_1BYTECHK + 1;

    GetComboboxSelection(hDlg, IDD_KRM_RETRYLIMIT, szValStr);
    KermParams.RetryLimit = atoi(szValStr);

    GetComboboxSelection(hDlg, IDD_KRM_SENDDELAY, szValStr);
    KermParams.SendDelay = atoi(szValStr);

  /* user wants to save the values, so write them to WIN.INI */
    if (IsDlgButtonChecked(hDlg, IDD_KRM_SAVE)) {
	LoadString(Kermit.hInst,IDS_KRM_KERMIT,szAppStr,sizeof(szAppStr));

        LoadString(Kermit.hInst, IDS_KRM_TIMER, szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.Timer, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);
/*
        LoadString(Kermit.hInst, IDS_KRM_VERBOSE, szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.verbose, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);
*/
        LoadString(Kermit.hInst, IDS_KRM_DISCARD, szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.DiscardPartialFile, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_BELL, szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.Bell, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_FILEWARN, szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.FileWarning, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_BLOCKCHECKTYPE,
		   szKeyStr,sizeof(szKeyStr));
        itoa(KermParams.BlockCheckType, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_RETRYLIMIT,
		   szKeyStr, sizeof(szKeyStr));
        itoa(KermParams.RetryLimit, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDDELAY,szKeyStr,sizeof(szKeyStr));
        itoa(KermParams.SendDelay, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

	SendMessage((HWND)(-1), WM_WININICHANGE, 0, (LONG)(LPSTR)szAppStr);
    }
}

/*
 * krmProtocolInit
 *
 * Initialize the Kermit protocol settings
 * dialog box.
 */
static void NEAR krmProtocolInit(HWND hDlg)
{
    register int i;
    char buf[80];

    CheckDlgButton(hDlg, IDD_KRM_BELL, KermParams.Bell);
    CheckDlgButton(hDlg, IDD_KRM_TIMER, KermParams.Timer);
    CheckDlgButton(hDlg, IDD_KRM_DISCARD, KermParams.DiscardPartialFile);
    CheckDlgButton(hDlg, IDD_KRM_FILEWARNING, KermParams.FileWarning);
//    CheckDlgButton(hDlg, IDD_KRM_VERBOSE, KermParams.verbose);
    CheckRadioButton(hDlg, IDD_KRM_1BYTECHK, IDD_KRM_3BYTECHK,
			   IDD_KRM_1BYTECHK + KermParams.BlockCheckType - 1);

    for (i = 1; i <= 63; i++)
	SendDlgItemMessage(hDlg, IDD_KRM_RETRYLIMIT, CB_INSERTSTRING,
				-1, (LONG)(LPSTR)itoa(i, buf, 10));
    SendDlgItemMessage(hDlg, IDD_KRM_RETRYLIMIT, CB_SELECTSTRING,
			-1, (LONG)(LPSTR)itoa(KermParams.RetryLimit, buf, 10));
				
    for (i = 0; i <= 63; i++)
	SendDlgItemMessage(hDlg, IDD_KRM_SENDDELAY, CB_INSERTSTRING,
				-1, (LONG)(LPSTR)itoa(i, buf, 10));
    SendDlgItemMessage(hDlg, IDD_KRM_SENDDELAY, CB_SELECTSTRING,
			-1, (LONG)(LPSTR)itoa(KermParams.SendDelay, buf, 10));
}

/*
 * krmPackets
 *
 * This dialog box sets the various Kermit packet parameters.
 */
BOOL FAR PASCAL krmPackets(HWND hDlg,unsigned message,WORD wParam,LONG lParam)
{
    switch(message) {
	case WM_INITDIALOG:
	krmPacketsInit(hDlg);
	break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDOK:
		    krmPacketsSet(hDlg);
		    EndDialog(hDlg, TRUE);
		    break;
		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;
		default:
		    return FALSE;
	    }
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

/*
 * krmPacketsSet
 *
 * In response to values chosen by the user, this
 * routine sets the various packet data structures.
 * If requested, values are saved to WIN.INI
 */
static void NEAR krmPacketsSet(HWND hDlg)
{
    char szAppStr[80];
    char szKeyStr[80];
    char szValStr[80];

    sndparams.mark = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_SENDMARK);
    rcvparams.mark = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_RECEIVEMARK);
    sndparams.maxpktsize = (short)GetComboboxIndex(hDlg,IDD_KRM_SENDMAXSIZE)
			   + KRM_MINPACKETSIZE;
    rcvparams.maxpktsize = (short)GetComboboxIndex(hDlg,IDD_KRM_RECEIVEMAXSIZE)
			   + KRM_MINPACKETSIZE;
    sndparams.timeout = (short)GetComboboxIndex(hDlg, IDD_KRM_SENDTIMEOUT)
			   + KRM_MINTIMEOUT;
    rcvparams.timeout = (short)GetComboboxIndex(hDlg, IDD_KRM_RECEIVETIMEOUT)
			   + KRM_MINTIMEOUT;
    sndparams.padcount = (short)GetComboboxIndex(hDlg,IDD_KRM_SENDPADCOUNT);
    rcvparams.padcount = (short)GetComboboxIndex(hDlg,IDD_KRM_RECEIVEPADCOUNT);
    sndparams.padchar = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_SENDPADCHAR);
    if (sndparams.padchar >= ' ')
	sndparams.padchar = DEL;
    rcvparams.padchar = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_RECEIVEPADCHAR);
    if (rcvparams.padchar >= ' ')
	sndparams.padchar = DEL;
    sndparams.eol = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_SENDEOL);
    rcvparams.eol = (BYTE)GetComboboxIndex(hDlg, IDD_KRM_RECEIVEEOL);
    sndparams.quote = (BYTE)(GetComboboxIndex(hDlg, IDD_KRM_SENDQUOTE) + '!');
    if (sndparams.quote >= '?')
	sndparams.quote += 30;
    rcvparams.quote = (BYTE)(GetComboboxIndex(hDlg,IDD_KRM_RECEIVEQUOTE)+'!');
    if (rcvparams.quote >= '?')
	rcvparams.quote += 30;

    if (IsDlgButtonChecked(hDlg, IDD_KRM_SAVE)) {
	LoadString(Kermit.hInst,IDS_KRM_KERMIT,szAppStr,sizeof(szAppStr));

        LoadString(Kermit.hInst, IDS_KRM_SENDMARK, szKeyStr, sizeof(szKeyStr));
        itoa(sndparams.mark, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_RCVMARK, szKeyStr, sizeof(szKeyStr));
        itoa(rcvparams.mark, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDMAXLEN,szKeyStr,sizeof(szKeyStr));
        itoa(sndparams.maxpktsize, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_RCVMAXLEN,szKeyStr,sizeof(szKeyStr));
        itoa(rcvparams.maxpktsize, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDTIMEOUT,szKeyStr,sizeof(szKeyStr));
        itoa(sndparams.timeout, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_RCVTIMEOUT,szKeyStr,sizeof(szKeyStr));
        itoa(rcvparams.timeout, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDPADCOUNT,
		   szKeyStr,sizeof(szKeyStr));
        itoa(sndparams.padcount, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_RCVPADCOUNT,szKeyStr,sizeof(szKeyStr));
        itoa(rcvparams.padcount, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDPADCHAR,szKeyStr,sizeof(szKeyStr));
        itoa(sndparams.padchar, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_RCVPADCHAR,szKeyStr,sizeof(szKeyStr));
        itoa(rcvparams.padchar, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_SENDEOL, szKeyStr, sizeof(szKeyStr));
        itoa(sndparams.eol, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_RCVEOL, szKeyStr, sizeof(szKeyStr));
        itoa(rcvparams.eol, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst,IDS_KRM_SENDQUOTE,szKeyStr,sizeof(szKeyStr));
        itoa(sndparams.quote, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

        LoadString(Kermit.hInst, IDS_KRM_RCVQUOTE, szKeyStr, sizeof(szKeyStr));
        itoa(rcvparams.quote, szValStr, 10);
        WriteProfileString(szAppStr, szKeyStr, szValStr);

	SendMessage((HWND)(-1), WM_WININICHANGE, 0, (LONG)(LPSTR)szAppStr);
    }
}

/*
 * krmPacketsInit
 *
 * Initialize the Kermit packets settings
 * dialog box.
 */
static void NEAR krmPacketsInit(HWND hDlg)
{

    register int i;
    char buf[80];

    for (i = 0; i < ' '; i++) {
	sprintf(buf, "CTRL-%c", '@'+i);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDMARK, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEMARK, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDMARK,CB_SETCURSEL,sndparams.mark, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEMARK,
		       CB_SETCURSEL,rcvparams.mark,0L);

    for (i = KRM_MINPACKETSIZE; i <= KRM_MAXPACKETSIZE; i++) {
	itoa(i, buf, 10);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDMAXSIZE, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEMAXSIZE, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDMAXSIZE, CB_SETCURSEL,
		       sndparams.maxpktsize - KRM_MINPACKETSIZE, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEMAXSIZE, CB_SETCURSEL,
		       rcvparams.maxpktsize - KRM_MINPACKETSIZE, 0L);

    for (i = KRM_MINTIMEOUT; i <= KRM_MAXTIMEOUT; i++) {
	itoa(i, buf, 10);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDTIMEOUT, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVETIMEOUT, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDTIMEOUT, CB_SETCURSEL,
		       sndparams.timeout - KRM_MINTIMEOUT, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVETIMEOUT, CB_SETCURSEL,
		       rcvparams.timeout - KRM_MINTIMEOUT, 0L);

    for (i = 0; i <= KRM_MAXPADCOUNT; i++) {
	itoa(i, buf, 10);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDPADCOUNT, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEPADCOUNT, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDPADCOUNT,CB_SETCURSEL,
		       sndparams.padcount, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEPADCOUNT,CB_SETCURSEL,
		       rcvparams.padcount, 0L);
    for (i = 0; i < ' '; i++) {
	sprintf(buf, "CTRL-%c", '@'+i);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDPADCHAR, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEPADCHAR, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    strcpy(buf, "CTRL ?");
    SendDlgItemMessage(hDlg, IDD_KRM_SENDPADCHAR, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEPADCHAR, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    SendDlgItemMessage(hDlg,IDD_KRM_SENDPADCHAR,CB_SETCURSEL,
		       sndparams.padchar != DEL ? sndparams.padchar : 32, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEPADCHAR,CB_SETCURSEL,
		       rcvparams.padchar != DEL ? rcvparams.padchar : 32, 0L);

    for (i = 0; i < 32; i++) {
	sprintf(buf, "CTRL-%c", '@'+i);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDEOL, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEEOL, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDEOL, CB_SETCURSEL,sndparams.eol, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEEOL,CB_SETCURSEL,rcvparams.eol,0L);

    for (i = 33; i <= 126; i++) {
	if ((i >= 63) && (i <= 95))
	    continue;
	sprintf(buf, "%c", i);
	SendDlgItemMessage(hDlg, IDD_KRM_SENDQUOTE, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
	SendDlgItemMessage(hDlg, IDD_KRM_RECEIVEQUOTE, CB_INSERTSTRING,
			   -1, (LONG)(LPSTR)buf);
    }
    SendDlgItemMessage(hDlg,IDD_KRM_SENDQUOTE, CB_SETCURSEL,
			(33 <= sndparams.quote) && (sndparams.quote < 63) ? 
			sndparams.quote - 33 : sndparams.quote - 63, 0L);
    SendDlgItemMessage(hDlg,IDD_KRM_RECEIVEQUOTE, CB_SETCURSEL,
			(33 <= rcvparams.quote) && (rcvparams.quote < 63) ? 
			rcvparams.quote - 33 : rcvparams.quote - 63, 0L);
    
}

/* 
 * krmSendFileProc
 *
 * This dialog box allows the user to choose a list of
 * files to send to a remote Kermit.
 */
BOOL FAR PASCAL krmSendFileProc(HWND hDlg,unsigned message,
				WORD wParam,LONG lParam)
{

    switch (message) {
	case WM_INITDIALOG:
	    krmSendFileInit(hDlg);
	    break;

	case WM_COMMAND:
	    switch (wParam) {

		/* turn off SEND button if no files selected */
		case IDD_KRM_LISTSELECT:
		    if (HIWORD(lParam) == LBN_SELCHANGE)
			EnableWindow(GetDlgItem(hDlg, IDD_KRM_SEND),
				      krmListSelect(hDlg, lParam));
		    break;

		/* in this dialog box, IDOK sets selections */
		case IDOK:		    
		    krmListBoxOK(hDlg, lParam);
		    EnableWindow(GetDlgItem(hDlg, IDD_KRM_SEND),
				 krmListSelect(hDlg, lParam));
		    break;
		
		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;

		/* get selected files into a buffer */
		case IDD_KRM_SEND:
		    krmGetSendFileList(hDlg, lParam);
		    break;

		/* move to another directory */
		case IDD_KRM_PATHSELECT:
		    krmPathSelect(hDlg, lParam);
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default:
	    return FALSE;
    }
    return TRUE;
}

/*
 * krmListSelect
 *
 * Look through the file name list box for a selection.
 */
static BOOL NEAR krmListSelect(HWND hDlg, LONG lParam)
{
    BOOL select = FALSE;
    register int i;
    register int num = (int)SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT,
     					       LB_GETCOUNT, 0, 0L);

    for (i = 0; i < num; i++) {
	select = (BOOL)SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT, 
					  LB_GETSEL, i, 0L);
	if (select)
	    break;
    }
    return select;
}

/*
 * krmPathSelect
 *
 * Move to a new directory in the Send File dialog box.
 */
static void NEAR krmPathSelect(HWND hDlg, LONG lParam)
{

    char buf[MAXPATHLEN];
    char str[MAXPATHLEN];
    int len;

    if (HIWORD(lParam) == LBN_SELCHANGE) {
	len = GetDlgItemText(hDlg, IDD_KRM_EDITSELECT,(LPSTR)str,80);
        DlgDirSelect(hDlg, (LPSTR)buf, IDD_KRM_PATHSELECT);
	if (strchr(str,'*') || strchr(str,'?'))
	    strcat(buf,getnamestr(str,len));
	else
	    strcat(buf, defstring);
        SetDlgItemText(hDlg, IDD_KRM_EDITSELECT, (LPSTR)buf);
    }
    else if (HIWORD(lParam) == LBN_DBLCLK) {
	GetDlgItemText(hDlg, IDD_KRM_EDITSELECT,(LPSTR)buf,80);
	DlgDirList(hDlg, buf, IDD_KRM_LISTSELECT,IDD_KRM_PATHDISPLAY, 0);
	DlgDirList(hDlg, buf,IDD_KRM_PATHSELECT,IDD_KRM_PATHDISPLAY,0xC010);
	SetDlgItemText(hDlg, IDD_KRM_EDITSELECT, (LPSTR)buf);
    }
}

/*
 * krmSendFileInit
 *
 * Initialize the Send File Select dialog box
 */
static void NEAR krmSendFileInit(HWND hDlg)
{

    char buf[10];
    strcpy(buf, defstring);

    DlgDirList(hDlg, buf, IDD_KRM_LISTSELECT,IDD_KRM_PATHDISPLAY, 0);
    DlgDirList(hDlg, buf, IDD_KRM_PATHSELECT,IDD_KRM_PATHDISPLAY, 0xC010);
    SetDlgItemText(hDlg, IDD_KRM_EDITSELECT, (LPSTR)buf);
    SendDlgItemMessage(hDlg, IDD_KRM_EDITSELECT,EM_LIMITTEXT,128,0L);
    EnableWindow(GetDlgItem(hDlg, IDD_KRM_SEND), FALSE);
    setoemconvert(hDlg, IDD_KRM_EDITSELECT);
}

/*
 * krmCheckSelect
 *
 * Count the number of files selected in the Send File Selection
 * dialog box.
 */
static int NEAR krmCheckSelect(HWND hDlg)
{

    register int num, i;
    register int count = 0;

    num = (int)SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT,LB_GETCOUNT,0,0L);

    for (i = 0; i < num; i++)
        if (SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,LB_GETSEL,(WORD)i,0L))
	    count += 1;

    return count;
}

/*
 * krmGetSendFileList
 *
 * Read the list box for the names of the files selected
 * to be sent by Kermit and store them in a locally allocated buffer
 * as a single string delimited by spaces.
 */
static void NEAR krmGetSendFileList(HWND hDlg, LONG lParam)
{

    char buf[MAXPATHLEN];
    int count, i, num;

    count = krmCheckSelect(hDlg);
    if (count > 0) {
        Kermit.hFilelist = LocalAlloc(LPTR, count * 13);
	if (Kermit.hFilelist != NULL) {
	    Kermit.pFilelist = LocalLock(Kermit.hFilelist);
	    num = (int)SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT,
						LB_GETCOUNT,0,0L);
	    for (i = 0; i < num; i++) {
	        if (SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,
				       LB_GETSEL,(WORD)i,0L)) {
	       	    SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT,LB_GETTEXT, 
						(WORD)i, (LONG)(LPSTR)buf);
		    strcat(Kermit.pFilelist, buf);
		    strcat(Kermit.pFilelist, " ");
	        }
            }
        }
        else
	    count = 0;
    }
    if (count == 0) {
	/* no files selected or local alloc error */
    }
    EndDialog(hDlg,count);
}

/*
 * krmListBoxOK
 *
 * If user chooses the SELECT button (IDOK), highlight those files
 * which match the specification in the associated edit select box.
 * If nothing selected, remove all highlighting.
 */
static void NEAR krmListBoxOK(HWND hDlg, LONG lParam)
{

    char buf[MAXPATHLEN];
    int validsspec, count;
    OFSTRUCT myoff;
    int hfile;
    char oldpath[MAXPATHLEN];
    char *ptr;

/* if nothing in the edit box */
    if (GetDlgItemText(hDlg, IDD_KRM_EDITSELECT,(LPSTR)buf,sizeof(buf)) == 0)
/* remove highlighting from file list box */
        SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,LB_SETSEL,FALSE,(LONG)(-1));
    else {
/* otherwise, save the path */
    	GetDlgItemText(hDlg, IDD_KRM_PATHDISPLAY,(LPSTR)oldpath,128);
/* see if valid search spec */
	SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT, WM_SETREDRAW, FALSE, 0L);
	SendDlgItemMessage(hDlg, IDD_KRM_PATHSELECT, WM_SETREDRAW, FALSE, 0L);
	validsspec = DlgDirList(hDlg,buf,IDD_KRM_LISTSELECT,
				IDD_KRM_PATHDISPLAY,0);
	SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT, WM_SETREDRAW, TRUE, 0L);
	SendDlgItemMessage(hDlg, IDD_KRM_PATHSELECT, WM_SETREDRAW, TRUE, 0L);
/* if valid, get the new path */
	if (validsspec) {
/* buf modified, so update it */
	    SetDlgItemText(hDlg, IDD_KRM_EDITSELECT, (LPSTR)buf);
	    GetDlgItemText(hDlg, IDD_KRM_PATHDISPLAY, (LPSTR)buf, sizeof(buf));
/* if the same as before */
	    if (strcmp(oldpath, buf) == 0)
/* select the whole list box */
                SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,
				   LB_SETSEL,TRUE,(LONG)(-1));
	    else {
/* update the directory change box */
                SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,
				   LB_SETSEL,FALSE,(LONG)(-1));
	        DlgDirList(hDlg,(LPSTR)buf,IDD_KRM_PATHSELECT,
			   IDD_KRM_PATHDISPLAY, 0xC010);
	    }
/* not a valid search spec */
	} else {
/* clear box */
            SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT, LB_RESETCONTENT,0,0L);
/* see if it exists */
	    hfile = OpenFile((LPSTR)buf, (OFSTRUCT FAR *)&myoff, OF_EXIST);
	    if (hfile != -1) {
/* get the file name and add it to list box */
	        ptr = strrchr(myoff.szPathName,'\\') + 1;
	        SendDlgItemMessage(hDlg, IDD_KRM_LISTSELECT,LB_ADDSTRING,0,
							(LONG)(LPSTR)ptr);
/* get the pathname */
	        strcpy(buf, myoff.szPathName);
	        count = strlen(buf) - strlen(ptr);
	        buf[count] = NUL;
/* select it */
                SendDlgItemMessage(hDlg,IDD_KRM_LISTSELECT,LB_SETSEL,TRUE,-1L);
/* update the path select box */
	        SetDlgItemText(hDlg, IDD_KRM_EDITSELECT, (LPSTR)ptr);
	        DlgDirList(hDlg,buf,IDD_KRM_PATHSELECT,
			   IDD_KRM_PATHDISPLAY,0xC010);
	    }
        }
    }
/* select text in edit box */
    SendDlgItemMessage(hDlg,IDD_KRM_EDITSELECT,EM_SETSEL,0,MAKELONG(0,32767));
}

/* 
 * krmXferDlgBox
 *
 * Show the progress of the file transfer
 */
BOOL FAR PASCAL krmXferDlgBox(HWND hDlg,unsigned message,
			      WORD wParam,LONG lParam)
{

    char buf[40];
    FARPROC fp;

    switch (message) {

	case WM_INITDIALOG:
	    if (Kermit.mode == IDM_KRM_SEND) {
    	        LoadString(Kermit.hInst,IDS_KRM_SENDING, buf, sizeof(buf));
		SetDlgItemText(hDlg, IDD_KRM_OPERATION, buf);
	    }
	    break;

	case WM_COMMAND:
	    switch (wParam) {
		case IDCANCEL:
		    if (Kermit.InTransfer) {
		        fp = MakeProcInstance((FARPROC)krmCancelBoxProc,
					       Kermit.hInst);
		        DialogBox(Kermit.hInst,
				  MAKEINTRESOURCE(DT_KRM_CANCEL),hDlg,fp);
		        FreeProcInstance(fp);
		    }
		    else {
		        DestroyWindow(hDlg);
		        Kermit.hWndXfer = NULL;
		    }
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default:
	    return FALSE;
    }
    return TRUE;
}

BOOL FAR PASCAL krmXferRemote(HWND hDlg,unsigned message,
			      WORD wParam,LONG lParam)
{

    FARPROC fp;

    switch (message) {

	case WM_INITDIALOG:
	    krmInitRemoteBox(hDlg);
	    fOverflow = FALSE;
	    break;

	case WM_DESTROY:
	    Kermit.hWndXfer = NULL;
	    break;

	case WM_COMMAND:
	    switch (wParam) {
		case IDD_KRM_REMOTEDATA:
		    if (HIWORD(lParam) == EN_MAXTEXT)
			fOverflow = TRUE;
		    break;

		case IDCANCEL:
		    if (Kermit.InTransfer) {
		        fp = MakeProcInstance((FARPROC)krmCancelBoxProc,
					       Kermit.hInst);
		        DialogBox(Kermit.hInst,
				  MAKEINTRESOURCE(DT_KRM_CANCEL),hDlg,fp);
		        FreeProcInstance(fp);
		    }
		    else {
		        DestroyWindow(hDlg);
		        Kermit.hWndXfer = NULL;
		    }
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default:
	    return FALSE;
    }
    return TRUE;
}

static void NEAR krmInitRemoteBox(HWND hDlg)
{
    char buf[80];

    SendDlgItemMessage(hDlg, IDD_KRM_REMOTEDATA, WM_SETFONT,
		       GetStockObject(SYSTEM_FIXED_FONT), 0L);
    SetDlgItemText(hDlg,IDD_KRM_BYTESMOVED, ultoa(Kermit.bytesmoved, buf, 10));
    SetDlgItemText(hDlg, IDD_KRM_PACKETS, ultoa(Kermit.packetcount, buf, 10));
    SetDlgItemText(hDlg,IDD_KRM_RETRIES, itoa(Kermit.totalretries, buf, 10));

}

/*
 * krmCancelBoxProc
 *
 * Check the file transfer cancel mode
 * and set the corresponding cancel flag
 */
BOOL FAR PASCAL krmCancelBoxProc(HWND hDlg, unsigned message,
				 WORD wParam, LONG lParam)
{

    switch (message) {
	case WM_INITDIALOG:
	    CheckRadioButton(hDlg,IDD_KRM_CANCELFILE, IDD_KRM_CANCELPROTOCOL,
				  IDD_KRM_CANCELFILE);
	    break;

	case WM_COMMAND:	/* system command */
	    switch (wParam) {

		case IDD_KRM_CANCELFILE:
		case IDD_KRM_CANCELBATCH:
		case IDD_KRM_CANCELERROR:
		case IDD_KRM_CANCELPROTOCOL:
		    CheckRadioButton(hDlg, IDD_KRM_CANCELFILE, 
					   IDD_KRM_CANCELPROTOCOL, wParam);
		    break;

		case IDOK:
		    krmSetCancelFlags(hDlg);
		    EndDialog(hDlg,TRUE);
		    break;

		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;

		default:
		    return FALSE;	/* windows will handle this */
	    }
	    break;

	default:
	    return FALSE;	/* and, windows will process this as well */
    }
    return TRUE;		/* if we process message, return TRUE */
}

/*
 * krmSetCancelFlags
 *
 * Set the file transfer cancel flags
 * chosen by the user
 */
static void NEAR krmSetCancelFlags(HWND hDlg)
{
    register int i;
    register WORD param;

    for (i = IDD_KRM_CANCELFILE; i <= IDD_KRM_CANCELPROTOCOL; i++) {
	if (SendDlgItemMessage(hDlg, i, BM_GETCHECK, 0, 0L)) {
	    switch(i) {
		default:
		case IDD_KRM_CANCELFILE:
		    param = IDM_KRM_FILEABORT;
		    break;
	        case IDD_KRM_CANCELBATCH:
		    param = IDM_KRM_BATCHABORT;
		    break;
		case IDD_KRM_CANCELERROR:
		    param = IDM_KRM_ERRORABORT;
		    break;
		case IDD_KRM_CANCELPROTOCOL:
		    param = IDM_KRM_CANCEL;
		    break;
	    }
	    SendMessage(Kermit.hWnd, WM_COMMAND, param, 0L);
	    break;
	}
    }
}

BOOL FAR PASCAL krmCWD(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

    switch(message) {

	case WM_INITDIALOG:
	    krmCWDInit(hDlg);
	    break;

	case WM_COMMAND:
	    switch(wParam) {

		case IDOK:
		    EndDialog(hDlg, krmCWDSet(hDlg));
		    break;

		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;

		default:
		    return FALSE;
	    }
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

static void NEAR krmCWDInit(HWND hDlg)
{

    SendDlgItemMessage(hDlg,IDD_KRM_FILENAME,EM_LIMITTEXT,KRM_MAXDATALEN,0L);
    SendDlgItemMessage(hDlg,IDD_KRM_PASSWORD,EM_LIMITTEXT,KRM_MAXDATALEN,0L);

}

static HANDLE NEAR krmCWDSet(HWND hDlg)
{
    register int len1, len2;

    len1 = (int)SendDlgItemMessage(hDlg,IDD_KRM_FILENAME,
				   WM_GETTEXTLENGTH,0,0L);
    len2 = (int)SendDlgItemMessage(hDlg,IDD_KRM_PASSWORD,
				   WM_GETTEXTLENGTH,0,0L);

    Kermit.hFilelist = LocalAlloc(LPTR, len1 + len2 + 4);
    if (Kermit.hFilelist != NULL) {
        Kermit.pFilelist = LocalLock(Kermit.hFilelist);
	*Kermit.pFilelist = 'C';
	*(Kermit.pFilelist + 1) = (BYTE)tochar(len1);
	GetWindowText(GetDlgItem(hDlg, IDD_KRM_FILENAME),
				 Kermit.pFilelist + 2, len1 + 1);
	*(Kermit.pFilelist + len1 + 2) = (BYTE)tochar(len2);
	GetWindowText(GetDlgItem(hDlg, IDD_KRM_PASSWORD),
				 Kermit.pFilelist + len1 + 3, len2 + 1);
    }
    return (Kermit.hFilelist);
    
}

BOOL FAR PASCAL krmRemote1ParamCmd(register HWND hDlg, unsigned message, 
				   register WORD wParam, LONG lParam)
{

    switch(message) {

	case WM_INITDIALOG:
	    krmRemote1ParamInit(hDlg, Kermit.mode);
	    break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDD_KRM_FILENAME:
		    if (HIWORD(lParam) == EN_CHANGE)
		        krmRemote1ParamEnable(hDlg,LOWORD(lParam),Kermit.mode);
		    break;

		case IDOK:
		    EndDialog(hDlg, krmRemote1ParamSet(hDlg, Kermit.mode));
		    break;

		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;

		default:
		    return FALSE;
	    }
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

static void NEAR krmRemote1ParamInit(register HWND hDlg, int mode)
{
    char buf[80];

    SendDlgItemMessage(hDlg,IDD_KRM_FILENAME,EM_LIMITTEXT,KRM_MAXDATALEN,0L);

    switch(mode) {
        case IDM_KRM_REMOTETYPE:
	    LoadString(Kermit.hInst, IDS_KRM_REMOTETYPE, buf, sizeof(buf));
            SetWindowText(hDlg, buf);
            EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
	    break;
        case IDM_KRM_REMOTEHELP:
            LoadString(Kermit.hInst, IDS_KRM_REMOTEHELP, buf, sizeof(buf));
            SetWindowText(hDlg, buf);
            LoadString(Kermit.hInst, IDS_KRM_HELPTOPIC, buf, sizeof(buf));
            SetDlgItemText(hDlg, IDD_KRM_EDITTITLE, buf);
	    break;
        case IDM_KRM_REMOTEDIR:
            LoadString(Kermit.hInst, IDS_KRM_REMOTEDIR, buf, sizeof(buf));
            SetWindowText(hDlg, buf);
	    break;
	case IDM_KRM_REMOTECOMMAND:
	    LoadString(Kermit.hInst, IDS_KRM_REMOTECOMMAND, buf, sizeof(buf));
	    SetWindowText(hDlg, buf);
	    LoadString(Kermit.hInst, IDS_KRM_CMDTOPIC, buf, sizeof(buf));
	    SetDlgItemText(hDlg, IDD_KRM_EDITTITLE, buf);
	    EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
	    break;
	case IDM_KRM_REMOTEERASE:
	    LoadString(Kermit.hInst, IDS_KRM_REMOTEERASE, buf, sizeof(buf));
	    SetWindowText(hDlg, buf);
	    EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
	    break;
	case IDM_KRM_REMOTESPACE:
	    LoadString(Kermit.hInst, IDS_KRM_REMOTESPACE, buf, sizeof(buf));
	    SetWindowText(hDlg, buf);
	    LoadString(Kermit.hInst, IDS_KRM_SPACETOPIC, buf, sizeof(buf));
	    SetDlgItemText(hDlg, IDD_KRM_EDITTITLE, buf);
	    break;
	case IDM_KRM_REMOTEWHO:
	    LoadString(Kermit.hInst, IDS_KRM_REMOTEWHO, buf, sizeof(buf));
	    SetWindowText(hDlg, buf);
	    LoadString(Kermit.hInst, IDS_KRM_WHOTOPIC, buf, sizeof(buf));
	    SetDlgItemText(hDlg, IDD_KRM_EDITTITLE, buf);
	    break;
	case IDM_KRM_GET:
	    EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
	    setoemconvert(hDlg, IDD_KRM_FILENAME);
	    break;
    }
}

static HANDLE NEAR krmRemote1ParamSet(register HWND hDlg, int mode)
{

    switch (mode) {
	case IDM_KRM_REMOTETYPE:
	    return krmRemote1ParamGeneric(hDlg, 'T');
        case IDM_KRM_REMOTEHELP:
	    return krmRemote1ParamGeneric(hDlg, 'H');
	case IDM_KRM_REMOTEDIR:
	    return krmRemote1ParamGeneric(hDlg, 'D');
	case IDM_KRM_REMOTEWHO:
	    return krmRemote1ParamGeneric(hDlg, 'W');
	case IDM_KRM_REMOTEERASE:
	    return krmRemote1ParamGeneric(hDlg, 'E');
	case IDM_KRM_REMOTESPACE:
	    return krmRemote1ParamGeneric(hDlg, 'U');
	case IDM_KRM_REMOTECOMMAND:
	case IDM_KRM_GET:
	    return krmRemote1ParamCommand(hDlg);
	    break;
    }
}

static HANDLE NEAR krmRemote1ParamCommand(HWND hDlg)
{
    register int len;

    len = (int)SendDlgItemMessage(hDlg,IDD_KRM_FILENAME,WM_GETTEXTLENGTH,0,0L);
    Kermit.hFilelist = LocalAlloc(LPTR, len + 1);
    if (Kermit.hFilelist != NULL) {
        Kermit.pFilelist = LocalLock(Kermit.hFilelist);
	GetWindowText(GetDlgItem(hDlg, IDD_KRM_FILENAME),
				 Kermit.pFilelist, len + 1);
    }
    return (Kermit.hFilelist);
}

static HANDLE NEAR krmRemote1ParamGeneric(HWND hDlg, char cmd)
{
    register int len;

    len = (int)SendDlgItemMessage(hDlg,IDD_KRM_FILENAME,WM_GETTEXTLENGTH,0,0L);
    Kermit.hFilelist = LocalAlloc(LPTR, len + 3);
    if (Kermit.hFilelist != NULL) {
        Kermit.pFilelist = LocalLock(Kermit.hFilelist);
	*Kermit.pFilelist = cmd;
	*(Kermit.pFilelist + 1) = (BYTE)tochar(len);
	GetWindowText(GetDlgItem(hDlg, IDD_KRM_FILENAME),
				 Kermit.pFilelist + 2, len + 1);
    }
    return (Kermit.hFilelist);
}

static void NEAR krmRemote1ParamEnable(HWND hDlg, HWND hctl, int mode)
{
    register int count;

    if ((mode == IDM_KRM_REMOTETYPE) ||
	(mode == IDM_KRM_REMOTECOMMAND) ||
	(mode == IDM_KRM_GET) ||
	(mode == IDM_KRM_REMOTEERASE)) {
        count = (int)SendMessage(hctl,WM_GETTEXTLENGTH,0,0L);
        EnableWindow(GetDlgItem(hDlg, IDOK), count);
    }
}

/*
 * GetComboboxSelection
 *
 * Utility function for combo boxes
 * Finds the highlighted string and returns its value.
 *
 */
static int NEAR GetComboboxSelection(HWND hDlg, WORD id, char * buffer)
{
    register int index;

    index = (int)SendDlgItemMessage(hDlg, id, CB_GETCURSEL, 0, 0L);
    if (index != CB_ERR)
	index = (int)SendDlgItemMessage(hDlg, id, CB_GETLBTEXT,
					index, (LONG)(LPSTR)buffer);
    return index;
}

/*
 * GetComboBoxIndex
 *
 * Utility function for combo boxes
 * Get the index of the current selection
 */
static int NEAR GetComboboxIndex(HWND hDlg, int id)
{
    return (int)SendDlgItemMessage(hDlg, id, CB_GETCURSEL, 0, 0L);
}

/*
 * GetCheckedRadioButton
 *
 * Utility function for radio buttons
 * Finds the checked button, if any, in a group
 * of radio buttons.  If none, then returns highest value
 * of the range plus 1
 */
static int NEAR GetCheckedRadioButton(HWND hDlg, WORD start, WORD end)
{

    register WORD i;

    for (i = start; i <= end; i++)
	if (SendDlgItemMessage(hDlg, i, BM_GETCHECK, 0, 0L))
	    break;

    return i;
}

/*
 * getnamestr
 *
 * Utility function to parse a path name for a file name
 */
static char* NEAR getnamestr(char *str, int len)
{
    char *tmp;

    tmp = str + len;

    while ((*tmp != ':') && (*tmp != '\\') && (tmp > str))
	tmp--;
    if (*tmp != ':' && *tmp != '\\')
	return(tmp);
    else
	return(tmp + 1);

}

/*
 * krmLocalFiles
 *
 * Dialog box to provide local directory services
 */
BOOL FAR PASCAL krmLocalFiles(HWND hDlg, unsigned message,
			      WORD wParam, LONG lParam)
{
    switch(message) {
	case WM_INITDIALOG:
	krmLocalInit(hDlg);
	break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDD_KRM_LOCALDIRS:
		    krmLocalDirs(hDlg, lParam);
		    break;

		case IDOK:
		    krmLocalFilesOK(hDlg);
		    break;

		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    break;
		default:
		    return FALSE;
	    }
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

/*
 * krmLocalFilesOK
 *
 * Execute a directory change in krmLocalFiles dialog
 */
static void NEAR krmLocalFilesOK(HWND hDlg)
{

    char buf[MAXPATHLEN];

    GetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT,buf,sizeof(buf));
    DlgDirList(hDlg, buf, IDD_KRM_LOCALFILES,IDD_KRM_LOCALPATH, 0);
    DlgDirList(hDlg, buf, IDD_KRM_LOCALDIRS,IDD_KRM_LOCALPATH, 0xC010);
    SetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT, buf);
    SendDlgItemMessage(hDlg, IDD_KRM_LOCALPATHEDIT, EM_SETSEL, 0,
			MAKELONG(0, 32767));
}

/*
 * krmLocalInit
 *
 * Initialize the krmLocalFiles dialog
 */
static void NEAR krmLocalInit(HWND hDlg)
{

    DlgDirList(hDlg, defstring, IDD_KRM_LOCALFILES,IDD_KRM_LOCALPATH, 0);
    DlgDirList(hDlg, defstring, IDD_KRM_LOCALDIRS,IDD_KRM_LOCALPATH, 0xC010);
    SetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT, defstring);
    SendDlgItemMessage(hDlg,IDD_KRM_LOCALPATHEDIT,EM_LIMITTEXT,MAXPATHLEN, 0L);
    setoemconvert(hDlg, IDD_KRM_LOCALPATHEDIT);

}

/*
 * krmLocalDirs
 *
 * Change the edit box display and directory in krmLocalDirs dialog
 */
static void NEAR krmLocalDirs(HWND hDlg, LONG lParam)
{

    char buf[MAXPATHLEN];
    char str[MAXPATHLEN];
    int len;

    if (HIWORD(lParam) == LBN_SELCHANGE) {
	len = GetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT,str,sizeof(buf) - 13);
        DlgDirSelect(hDlg, (LPSTR)buf, IDD_KRM_LOCALDIRS);
	if (strchr(str,'*') || strchr(str,'?'))
	    strcat(buf,getnamestr(str,len));
	else
	    strcat(buf, defstring);
        SetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT, (LPSTR)buf);
    }
    else if (HIWORD(lParam) == LBN_DBLCLK) {
	GetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT,buf,sizeof(buf));
        DlgDirList(hDlg, buf, IDD_KRM_LOCALFILES,IDD_KRM_LOCALPATH, 0);
        DlgDirList(hDlg, buf, IDD_KRM_LOCALDIRS,IDD_KRM_LOCALPATH, 0xC010);
	SetDlgItemText(hDlg, IDD_KRM_LOCALPATHEDIT, buf);
    }
}

/*
 * setoemconvert
 *
 * Utility function to set an edit box to ES_OEMCONVERT style
 */
static void NEAR setoemconvert(HWND hDlg, WORD id)
{
    HWND hctl;
    LONG style;

    hctl = GetDlgItem(hDlg, id);
    style = GetWindowLong(hctl, GWL_STYLE);
    style |= ES_OEMCONVERT;
    SetWindowLong(hctl, GWL_STYLE, style);
}
