/*********************************************************************\
* Header file for the Win600/Win100 programs
*
* Copyright 1990, 1991 by
* William S. Hall
* 3665  Benton Street, #66
* Santa Clara, CA 95051
*
\*********************************************************************/

/* This trick insures that globals are declared in only one place */
#if !defined(EXTERN)
#define EXTERN extern
#endif

/*********************************************************************\
*
* Miscellaneous constants
*
\*********************************************************************/
#define MAXCOMPORTS	4
#define MAXRCSTRLEN	80
#define	LINE_ON		2
#define LOCAL_ON	1
#define BUFSIZE		128
#define VK_SCROLL	0x91
#define MAXPROTOLEN	16	/* max len of accumulated ANSI commands */
#define SYMBOL_CHARSET  2
#define EXE_NAME_MAX_SIZE 128
/*********************************************************************\
*
* Structures
*
\*********************************************************************/
/* current buffer descriptor */
typedef struct curbuf_tag {
    BYTE *ptr;	/* pointer to buffer */
    int len;	/* remaining chars in buffer */
} CURBUF;
typedef CURBUF *PCURBUF;

/* currently active protocol paramters */
typedef struct curproto_tag {
    char type;		   /* current type (alphanumeric or graphics) */
    int (FAR *apf)(void);  /* alphanumeric protocol function */
    int atype;		   /* current alpha emulation type */
    int gtype;		   /* graphics type (alphagraphics, point plot, etc.) */
    BYTE mask;		   /* eight bit mask */
    int (FAR *pf)(void); /* processing function (alphanumerics or graphics) */
    void (FAR *spkeys)(int type); /* keyboard function */
} CURPROTO;

/* main window parameters */
typedef struct _MWND {
    HWND hWnd;		/* window handle */
    HBRUSH hBrush;	/* current background brush */
    int TextColor, BGColor;	/* keep these together */
    BOOL LFCR;
    BOOL Cursor;
    BOOL CursorType;
    BOOL Reverse;
    int PelSize;
    BOOL BreakEnabled;
    BOOL CurKeyMode;
    BOOL DeleteKey;
    BOOL AutoAnswer;
    RECT rect;		/* current client rectangle */
    BOOL ApplMode;	   /* application or numeric keypad */
    BOOL WarningBell;
    WORD CharSet[4];
    int ActiveCharSet;
    BOOL ControlRep;
    BOOL Wrap;
#ifdef WIN600
    BOOL DelNotLoY;
    BOOL LockOutGraphCtrlCodes;
#endif
} MWND;
typedef MWND *pMWND;

/* power-up conditions */
typedef struct _INITDATA {
    char portname[MAXCOMPORTS][5];	/* comm port strings in desired order */
    short TermRows, TermCols;   /* terminal size */
    WORD BaudRate;		/* comm parameters */
    BYTE ByteSize;
    BYTE Parity;
    BYTE StopBits;
    BYTE fParity;		/* check parity */
    BYTE XonXoff;
    WORD XoffLim;		/* Xoff limit */
    BOOL LocalEcho;
    BOOL Wrap;			/* wrap lines */
    BOOL LFCR;
    BOOL MarginBell;
    BOOL Cursor;
    BOOL CursorType;
    int TextColor;
    int BGColor;
    BOOL WarningBell;
    int AlphaEmulation;
    BOOL ReverseVideo;
    BOOL SmoothScroll;
    short ScrollUnits;
    BOOL LocalMode;
    int AltKeypad;
    BOOL BreakEnabled;
    BOOL AutoAnswer;
    BOOL DeleteKey;
    int CursorKeys;
    char Fontface[LF_FACESIZE];
    short NFontWidth, NFontHeight;
    short SFontWidth, SFontHeight;
    BOOL ControlRep;
    int EWidth;
} INITDATA;

typedef struct _PARITYREC {
    BYTE ByteSize;
    BYTE Parity;
} PARITYREC;

typedef struct GlobalBuf {
    HANDLE hBuf;
    LONG lBufSize;
    LONG lBufHead;
    LONG lBufTail;
} GLOBALBUF;
typedef GLOBALBUF *PGLOBALBUF;

/*********************************************************************\
*
* Function prototypes
*
\*********************************************************************/
/* from win600.c */
LONG FAR PASCAL MainWndProc(HWND,unsigned,WORD,LONG);
BOOL FAR PASCAL MainHasResized(HWND hWnd, LONG lParam);
BOOL FAR PASCAL ColorChange(HWND hWnd, LONG lParam);
void NEAR DoGetMessage(void);
void NEAR DoPeekMessage(void);

/* from win600nt.c */
BOOL FAR InitProgram(HANDLE, HANDLE, LPSTR, int);
void FAR MainWndCreate(HWND hWnd, LONG lParam);

/* from win600fn.c */
void NEAR MainWndPaint(HWND hWnd, LPPAINTSTRUCT lpps);
void CloseCommPort(HWND hWnd, int *pCid);
int ShowMessage(HWND hWnd, int msgnum, WORD style);
void BroadcastWinIniChange(void);
void NEAR WndCommand(HWND, WORD, LONG);
void WriteToComm(BYTE *buf, int len);
void AnswerEnq(BYTE lead, int mode);
void InvertScreen(BOOL flag);
void NEAR WndTimer(HWND hWnd, WORD id);
void IdentifyTerm(short id);
void ReportCursorPos(int r, int c);
void NEAR ProcessChars(BYTE ch, int count);
void SetCols(WORD cols);
void ShowAnswerBack(void);
void NEAR CloseLogFile(void);
void NEAR XCSpecialKeys(int item);
void NEAR AGSpecialKeys(int item);
void NEAR IPPSpecialKeys(int item);
void FAR MakeCaret(BOOL make);
void NEAR WriteClipData(void);
void FAR SetAlphaParams(int type);
void FAR SetGraphicsParams(int type);
int FAR vt100(void);
int FAR vt52(void);
void FAR pushback(void);
int FAR yywrap(void);
void FAR _cdecl dbs(const char *fmt, ...);

/* from win600ms.c */
BOOL OpenDlgBox(HWND hWnd, FARPROC fpProc, WORD boxnum);
BOOL FAR PASCAL AboutBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL ModemBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL DisplayBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL GeneralBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL MiniBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL CopyBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL EditFunctionKeys(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL LogFileBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL KeyboardBoxProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL FontsBoxProc(HWND, unsigned, WORD, LONG);

/* from lex modules */
void FAR vt52SetState(int state);
void FAR vt100SetState(int state);
void FAR VT52SpecialKeys(int item);
void FAR ANSISpecialKeys(int item);

/*********************************************************************\
*
* Resource file constants
*
\*********************************************************************/
/* String ids */
#define IDS_APPNAME		100
#define IDS_ICON		101
#define IDS_TITLE		102
#define IDS_ADDDEFAULTS		103
#define IDS_COM1		104		/* sequential */
#define IDS_COM2		105
#define IDS_COM3		106
#define IDS_COM4		107
#define IDS_FIRSTPORT		108		/* sequential */
#define IDS_SECONDPORT		109
#define IDS_THIRDPORT		110
#define IDS_FOURTHPORT		111

#define IDS_RXQUESIZE		112
#define IDS_TXQUESIZE		113
#define IDS_NOCOM		114
#define IDS_CANNOTCLOSECOM	115
#define IDS_ROWS		116
#define IDS_COLS		117
#define IDS_NOCOMSET		118
#define IDS_BAUD		119
#define IDS_PARITY		120
#define IDS_STOPBITS		121
#define IDS_BYTESIZE		122
#define IDS_PARCHECK		123
#define IDS_XONXOFF		124
#define IDS_XOFFLIM		125
#define IDS_LOCALECHO		126
#define IDS_AUTOLFCR		127
#define IDS_MARGINBELL		128
#define IDS_CURSOR		129
#define IDS_CURSORTYPE		130
#define IDS_WARNINGBELL		131
#define IDS_LINE		132
#define IDS_LOCAL		133
#define IDS_WRAP		134
#define IDS_TEXTCOLOR		135
#define IDS_BGCOLOR		136
#define IDS_TERMTYPE		137
#define IDS_REVERSEVIDEO	138
#define IDS_SMOOTHSCROLL	139
#define IDS_LOCALMODE		140
#define IDS_TRYANOTHER		141
#define IDS_LOGFILENAME		142
#define IDS_LOGSESSION		143
#define IDS_CLOSELOG		144
#define IDS_FILEEXISTS		145
#define IDS_OPENFILEERROR	146
#define IDS_ALTKEYPAD		147
#define IDS_BREAKKEYENABLED	148
#define IDS_AUTOANSWER		149
#define IDS_DELETEKEY		150
#define IDS_CURSORKEYS		151
#define IDS_ANSWERBACKKEY	152
#define IDS_FONTFACE		153
#define IDS_DEFAULTFONT		154
#define IDS_NORMALWIDTH		155
#define IDS_NORMALHEIGHT	156
#define IDS_SMALLWIDTH		157
#define IDS_SMALLHEIGHT		158
#define IDS_SCROLLUNITS		159
#define IDS_CONTROLREP		160
#define IDS_EMULATIONWIDTH	161

/* dialog box strings */
#define IDS_JUMP		200
#define IDS_SMOOTH1		201
#define IDS_SMOOTH2		202
#define IDS_SMOOTH4		203
#define IDS_SMOOTH8		204
#define IDS_VT1007BIT		205
#define IDS_VT1008BIT		206
#define IDS_VT527BIT		207
#define IDS_VT528BIT		208
#define IDS_BLACK		220
#define IDS_DARKRED		221
#define IDS_DARKGREEN		222
#define IDS_DARKYELLOW		223
#define IDS_DARKBLUE		224
#define IDS_DARKMAGENTA		225
#define IDS_DARKCYAN		226
#define IDS_DARKGRAY		227
#define IDS_LIGHTGRAY		228
#define IDS_LIGHTRED		229
#define IDS_LIGHTGREEN		230
#define IDS_LIGHTYELLOW		231
#define IDS_LIGHTBLUE		232
#define IDS_LIGHTMAGENTA	233
#define IDS_LIGHTCYAN		234
#define IDS_WHITE		235

/* help */
#define IDS_WINHELPNAME	300

/* menu items */
#define IDM_ABOUT	100
#define IDM_LINE	101
#define IDM_LOCAL	102
#define IDM_SCROLL	103
#define IDM_NORMAL	104
#define IDM_REVERSE	105
#define IDM_MINI	106
#define IDM_MODEM	110
#define IDM_DISPLAY	111
#define IDM_GENERAL	112
#define IDM_CLEARCOM	120
#define IDM_COPYLINES	121
#define IDM_EDITFKEYS	122
#define IDM_GETFILE	123
#define IDM_CLOSEFILE	124
#define IDM_PASTE	125
#define IDM_RECALLSAVED	126
#define IDM_RECALLDEFAULT 127
#define IDM_KEYBOARD	128
#define IDM_FONTS	129

#define IDM_HELP_INDEX	150
#define IDM_HELP_KEY	151
#define IDM_HELP_COM	152
#define IDM_HELP_PROC	153
#define IDM_HELP_GLOS	154
#define IDM_HELP_HELP	155

/* special keys .  Start these from 200 */
#define IDM_UP		200
#define IDM_DOWN	201
#define IDM_RIGHT	202
#define IDM_LEFT	203
#define IDM_HOME	204
#define IDM_END		205
#define IDM_PRIOR	206
#define IDM_NEXT	207
#define IDM_CLEAR	208
#define IDM_INSERT	209
#define IDM_DELETE	210

#define IDM_S_UP	220
#define IDM_S_DOWN	221
#define IDM_S_RIGHT	222
#define IDM_S_LEFT	223
#define IDM_S_HOME	224
#define IDM_S_END	225
#define IDM_S_PRIOR	226
#define IDM_S_NEXT	227
#define IDM_S_CLEAR	228
#define IDM_S_INSERT	229
#define IDM_S_DELETE	230

#define IDM_C_UP	240
#define IDM_C_DOWN	241
#define IDM_C_RIGHT	242
#define IDM_C_LEFT	243
#define IDM_C_HOME	244
#define IDM_C_END	245
#define IDM_C_PRIOR	246
#define IDM_C_NEXT	247
#define IDM_C_CLEAR	248
#define IDM_C_INSERT	249
#define IDM_C_DELETE	250

#define IDM_CS_UP	260
#define IDM_CS_DOWN	261
#define IDM_CS_RIGHT	262
#define IDM_CS_LEFT	263
#define IDM_CS_HOME	264
#define IDM_CS_END	265
#define IDM_CS_PRIOR	266
#define IDM_CS_NEXT	267
#define IDM_CS_CLEAR	268
#define IDM_CS_INSERT	269
#define IDM_CS_DELETE	270

/* function keys */
#define IDM_F1		300
#define IDM_F2		301
#define IDM_F3		302
#define IDM_F4		303
#define IDM_F5		304
#define IDM_F6		305
#define IDM_F7		306
#define IDM_F8		307
#define IDM_F9		308
#define IDM_F10		309
#define IDM_F11		310
#define IDM_F12		311

#define IDM_S_F1	320
#define IDM_S_F2	321
#define IDM_S_F3	322
#define IDM_S_F4	323
#define IDM_S_F5	324
#define IDM_S_F6	325
#define IDM_S_F7	326
#define IDM_S_F8	327
#define IDM_S_F9	328
#define IDM_S_F10	329
#define IDM_S_F11	330
#define IDM_S_F12	331

#define IDM_C_F1	340
#define IDM_C_F2	341
#define IDM_C_F3	342
#define IDM_C_F4	343
#define IDM_C_F5	344
#define IDM_C_F6	345
#define IDM_C_F7	346
#define IDM_C_F8	347
#define IDM_C_F9	348
#define IDM_C_F10	349
#define IDM_C_F11	350
#define IDM_C_F12	351

#define IDM_CS_F1	360
#define IDM_CS_F2	361
#define IDM_CS_F3	362
#define IDM_CS_F4	363
#define IDM_CS_F5	364
#define IDM_CS_F6	365
#define IDM_CS_F7	366
#define IDM_CS_F8	367
#define IDM_CS_F9	368
#define IDM_CS_F10	369
#define IDM_CS_F11	370
#define IDM_CS_F12	371

#define IDM_NUM0	400
#define IDM_NUM1	401
#define IDM_NUM2	402
#define IDM_NUM3	403
#define IDM_NUM4	404
#define IDM_NUM5	405
#define IDM_NUM6	406
#define IDM_NUM7	407
#define IDM_NUM8	408
#define IDM_NUM9	409
#define IDM_ADD		410
#define IDM_SUBTRACT	411
#define IDM_DECIMAL	412
#define IDM_MULTIPLY	413

#define IDM_S_NUM0	420
#define IDM_S_NUM1	421
#define IDM_S_NUM2	422
#define IDM_S_NUM3	423
#define IDM_S_NUM4	424
#define IDM_S_NUM5	425
#define IDM_S_NUM6	426
#define IDM_S_NUM7	427
#define IDM_S_NUM8	428
#define IDM_S_NUM9	429
#define IDM_S_ADD	430
#define IDM_S_SUBTRACT	431
#define IDM_S_DECIMAL	432
#define IDM_S_MULTIPLY	433

#define IDM_C_NUM0	440
#define IDM_C_NUM1	441
#define IDM_C_NUM2	442
#define IDM_C_NUM3	443
#define IDM_C_NUM4	444
#define IDM_C_NUM5	445
#define IDM_C_NUM6	446
#define IDM_C_NUM7	447
#define IDM_C_NUM8	448
#define IDM_C_NUM9	449
#define IDM_C_ADD	450
#define IDM_C_SUBTRACT	451
#define IDM_C_DECIMAL	452
#define IDM_C_MULTIPLY	453

#define IDM_CS_NUM0	460
#define IDM_CS_NUM1	461
#define IDM_CS_NUM2	462
#define IDM_CS_NUM3	463
#define IDM_CS_NUM4	464
#define IDM_CS_NUM5	465
#define IDM_CS_NUM6	466
#define IDM_CS_NUM7	467
#define IDM_CS_NUM8	468
#define IDM_CS_NUM9	469
#define IDM_CS_ADD	470
#define IDM_CS_SUBTRACT	471
#define IDM_CS_DECIMAL	472
#define IDM_CS_MULTIPLY	473

/* dialog box ids */
#define DT_ABOUT 	1
#define DT_MODEM 	2
#define DT_DISPLAY      3
#define DT_GENERAL	4
#define DT_MINI		5
#define DT_COPYLINES	6
#define DT_EDITFKEYS	7
#define DT_GETFILE	8
#define DT_KEYBOARD	9
#define DT_FONTS	10

/*************************************************************************
**
** Communications Initialization Error Codes
**
*************************************************************************/
#if RC_INVOKED
#define IE_BADID    -1	/* Invalid or unsupported id	   */
#define IE_OPEN	    -2	/* Device Already Open		   */
#define IE_NOPEN    -3	/* Device Not Open		   */
#define IE_MEMORY   -4	/* Unable to allocate queues	   */
#define IE_DEFAULT  -5	/* Error in default parameters	   */
#define IE_HARDWARE -10 /* Hardware Not Present		   */
#define IE_BYTESIZE -11 /* Illegal Byte Size		   */
#define IE_BAUDRATE -12 /* Unsupported BaudRate		   */
#endif
/*********************************************************************\
*
* Default values
*
\*********************************************************************/
#define DEFBAUD		1200
#define DEFBYTESIZE	8
#define DEFPARITY	NOPARITY
#define DEFSTOP		1
#define DEFPECHECK	FALSE
#define DEFPECHAR	'?'
#define DEFXONXOFF	TRUE
#define DEFXONCHAR	DC1
#define DEFXOFFCHAR	DC3
#define DEFRXQUE	1024
#define DEFTXQUE	128
#define DEFXONLIM	32
#define DEFXOFFLIM	64
#define DEFLOCALECHO	FALSE
#define DEFLFCR		FALSE
#define DEFMBELL	FALSE
#define DEFCURSOR	TRUE
#define DEFCURSORTYPE	FALSE
#define DEFWBELL	TRUE
#define DEFROWS		24
#define DEFCOLS		80
#define DEFWRAP		0
#define DEFTEXTCOLOR	15
#define DEFBGCOLOR	0
#define DEFTERMTYPE	100
#define DEFEWIDTH	7
#define DEFVIDEO	0
#define DEFSCROLL	0
#define DEFSCROLLUNITS	4
#define MAXSCROLLUNITS	8
#define DEFLOCALMODE	0
#define DEFALTKEYPAD	0
#define DEFCURSORKEYS	0
#define DEFBREAKENABLED	TRUE
#define DEFDELETEKEY	FALSE
#define DEFAUTOANSWER	FALSE
#define DEFCONTROLREP	0

/*********************************************************************\
*
* Global variables
*
\*********************************************************************/
EXTERN SMT Smt;			/* smart terminal window data */
EXTERN MWND MWnd;		/* main window structure */
EXTERN INITDATA Initdata;	/* power up conditions */
EXTERN CURPROTO curproto;	/* current protocol */
EXTERN CURBUF ComBuf;		/* comm buffer parameters */
EXTERN CURBUF CharBuf;		/* char buffer parameters */
EXTERN CURBUF *pBuf;		/* pointer to current buffer */
EXTERN char szAppName[10];	/* name of the application */
EXTERN char szIcon[5];		/* icon string */
EXTERN HWND hWndActive;		/* handle to active display window */
EXTERN int cid;			/* active com port id*/
EXTERN DCB CommData;		/* comm data structure */
EXTERN int LineState;		/* current line and local echo state */
EXTERN int LocalEcho;		/* local echo on or off */
EXTERN BYTE Buffer[BUFSIZE];	/* comm buffer */
EXTERN BOOL ScrollLock;		/* state of scroll lock key */
EXTERN HANDLE hAccel;
EXTERN void (NEAR *DoMessage)(void);  /* pointer to message function */
EXTERN BOOL BreakState;
EXTERN HANDLE hInst;
EXTERN OFSTRUCT ofLogFile;
EXTERN int hLogFile;
EXTERN HWND hWndNext;
EXTERN GLOBALBUF GB;
EXTERN char szHelpName[EXE_NAME_MAX_SIZE + 1];
EXTERN char szIniName[EXE_NAME_MAX_SIZE + 1];
EXTERN HWND hWndText;
#ifdef WIN600
EXTERN HWND hWndGraph;
#endif

#define BAUDRATETABLESIZE 9
EXTERN WORD BaudRateTable[BAUDRATETABLESIZE]
#if defined(INITIALIZE)
    = {110,134,300,600,1200,2400,4800,9600,19200}
#endif
;

#define PARITYTABLESIZE 8
EXTERN PARITYREC ParityTable[PARITYTABLESIZE]
#if defined(INITIALIZE)
    = {8,NOPARITY,8,ODDPARITY,8,EVENPARITY,
       7,NOPARITY,7,ODDPARITY,7,EVENPARITY,7,MARKPARITY,7,SPACEPARITY}
#endif
;

#define XOFFLIMSIZE 5
EXTERN WORD XoffSizeTable[]
#if defined(INITIALIZE)
    = {64,128,256,512,768}
#endif
;

#define COLORTABLESIZE 16
EXTERN DWORD ColorTable[]
#if defined(INITIALIZE)
    = {0x000000,0x000080,0x008000,0x008080,0x800000,0x800080,0x808000,0x808080,
       0xc0c0c0,0x0000ff,0x00ff00,0x00ffff,0xff0000,0xff00ff,0xffff00,0xffffff}
#endif
;

EXTERN char *szFKey[]
#if defined(INITIALIZE)
   = {"F1", "F2",  "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10",
      "F11", "F12"}
#endif
;

EXTERN char *szSFKey[]
#if defined(INITIALIZE)
     = {"SF1", "SF2", "SF3", "SF4", "SF5", "SF6", "SF7", "SF8", "SF9", "SF10", 
	"SF11", "SF12"}
#endif
;

EXTERN char *szCFKey[]
#if defined(INITIALIZE)
     = {"CF1", "CF2", "CF3", "CF4", "CF5", "CF6", "CF7", "CF8", "CF9", "CF10", 
	"CF11", "CF12"}
#endif
;

EXTERN char *szCSFKey[]
#if defined(INITIALIZE)
     = {"CSF1", "CSF2", "CSF3", "CSF4", "CSF5", "CSF6", "CSF7", "CSF8", "CSF9",
	"CSF10", "CSF11", "CSF12"}
#endif
;
