# Win100 - Windows VT100 terminal emulator with Kermit for Windows 3

# Copyright (c) 1990, 1991 by
# William S. Hall
# 3665 Benton Street, #66
# Santa Clara, CA 95051

# Required: Microsoft 6.0 C compiler
#	    Windows 3.0 SDK
#	    MKS (Mortice-Kern Systems) Lex

# no debug compile
cp=cl -c -FPa -AM -Gshw -W4 -Osle -Zpe -DWIN100 -DWIN3 -DCOLUMBIA

# Kermit source directory
KD=.\

# .EXE file
win100.exe :: win100.def wkt100.lnk $(KD)\wkkerm.lib \
	      wkt100.obj wktint.obj wktfns.obj wktmsc.obj \
	      vt100.obj vt52.obj wktsmt.obj wktsmi.obj
    link @wkt100.lnk
    rc win100.res

win100.exe :: win100.res
    rc win100.res

# .RES files
win100.res : wkt100.rc wktmnu.rc wkt100.h wktdlg.dlg wktdlg.h wkkerm.ico \
	     $(KD)\wkkerm.h $(KD)\wkkdlg.h \
	     $(KD)\wkkmnu.rc $(KD)\wkkerm.dlg
    rc -r -DCOLUMBIA -Fowin100.res wkt100.rc

# .OBJ files
wkt100.obj : wkt100.c wkt100.h wktsmt.h $(KD)\wkkerm.h
    $(cp) -I$(KD) -DKERMIT -NT _Win100RES wkt100.c

wktfns.obj : wktfns.c wkt100.h wktsmt.h wktdlg.h
    $(cp) -NT _Win100RES wktfns.c

wktmsc.obj : wktmsc.c wkt100.h wktsmt.h wktdlg.h
    $(cp) -NT _Win100NRES wktmsc.c
        
vt100.c : wktv10.l
    lex -a -o vt100.c wktv10.l

vt100.obj : vt100.c wkt100.h wktsmt.h
    $(cp) -DYY_STATIC -NT _VT100 vt100.c

vt52.c : wktv52.l
    lex -a -o vt52.c wktv52.l

vt52.obj : vt52.c wkt100.h wktsmt.h
    $(cp) -DYY_STATIC -NT _VT52 vt52.c

wktint.obj : wktint.c wkt100.h wktsmt.h
    $(cp) -NT _Win100INIT wktint.c
    
wktsmt.obj : wktsmt.c wktsmt.h
    $(cp) -NT _SMARTTERM wktsmt.c

wktsmi.obj : wktsmi.c wktsmt.h
    $(cp) -NT _Win100INIT wktsmi.c

#
# make the .DEF file
#
win100.def : wkt100.def $(KD)\wkkerm.def
    copy wkt100.def + $(KD)\wkkerm.def win100.def
