/*
 * Smart terminal init module
 * 
 * Copyright (c) 1990, 1991 by
 * William S. Hall
 * 3665 Benton Street  #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM
#define NOKANJI
#define NOSOUND
#define NOATOM
#include <windows.h>
#include <string.h>
#include <ascii.h>
#ifdef COLUMBIA
#include "wktsmt.h"
#else
#include "smterm.h"
#endif

static char szSmartTermClass[50];
static int winnum = 0;

/* register terminal emulator window */
BOOL NEAR RegisterTermWindow(HANDLE hInstance)
{

    WNDCLASS WndClass;

    memset((char *)&WndClass, 0, sizeof(WndClass));

    WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);  /* standard cursor */
    WndClass.hIcon = NULL;
    WndClass.lpszMenuName = NULL;
    WndClass.lpszClassName = (LPSTR)szSmartTermClass;
    WndClass.hbrBackground = (HBRUSH)NULL;
    WndClass.hInstance = hInstance;
    WndClass.style = CS_VREDRAW | CS_HREDRAW;
    WndClass.lpfnWndProc = SmartTermWndProc;
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = sizeof(PSMT);

    return RegisterClass((LPWNDCLASS)&WndClass);

}

/* create terminal emulation window */
HWND NEAR MakeAndShowTermWindow(HANDLE hInstance, HANDLE hPrevInstance,
				HWND hPar, PSMT pSmt,
				DWORD tcolor, DWORD bgcolor,
				short x, short y, short rows, short cols,
				BOOL wrap,
				char *fontface,
				short nwidth, short nheight, 
				short swidth, short sheight
				)
{

    GetClassName(hPar, szSmartTermClass, sizeof(szSmartTermClass));
    strcat(szSmartTermClass, "_SmartTerm");

    if (!hPrevInstance)
        if (!RegisterTermWindow(hInstance))
            return FALSE;

    pSmt->hMain = hPar;
    pSmt->TextColor = tcolor;
    pSmt->BGColor = bgcolor;
    pSmt->MaxCols = cols;
    pSmt->MaxLines = rows;
    pSmt->Wrap = wrap;
    strcpy(pSmt->lfnt.lfFaceName, fontface);
    pSmt->NFontWidth = nwidth;
    pSmt->NFontHeight = nheight;
    pSmt->SFontWidth = swidth;
    pSmt->SFontHeight = sheight;

    pSmt->vrect.left = x;
    pSmt->vrect.top = y;
    pSmt->rect.left = pSmt->srect.left = 0;
    pSmt->rect.top = pSmt->srect.top = 0;

    if (!(pSmt->hStatic = CreateWindow("STATIC",
				(LPSTR)NULL,
			        WS_CHILDWINDOW | WS_VISIBLE | WS_CLIPCHILDREN,
			        pSmt->vrect.left,
				pSmt->vrect.top,
				0,0,
			        hPar,
				winnum++,
			        (HANDLE)hInstance,
			        (LPSTR)NULL)))
	return FALSE;

    pSmt->hWnd = CreateWindow(szSmartTermClass,
		             (LPSTR)NULL,
			     WS_CHILDWINDOW | WS_VISIBLE | WS_CLIPSIBLINGS,
			     pSmt->rect.left,
			     pSmt->rect.top,
			     0,0,
			     pSmt->hStatic,
			     winnum++,
			     (HANDLE)hInstance,
			     (LPSTR)pSmt);

    if (pSmt->hWnd && pSmt->pVidBuffer)
	return (pSmt->hWnd);

    return 0;

}
           
void SmartTermWndCreate(HWND hWnd, LONG lParam)
{

    LPCREATESTRUCT pCS;
    PSMT pSmt;
    register int i,j;

    pCS = (LPCREATESTRUCT)lParam;
    pSmt = (PSMT)LOWORD(pCS->lpCreateParams);
    SetWindowWord(hWnd,0,(WORD)pSmt);

    pSmt->hFont = SetFontData(pSmt);
    pSmt->hbr = CreateSolidBrush(pSmt->BGColor);

    pSmt->srect.right = pSmt->rect.right = pSmt->CharWidth * pSmt->MaxCols;
    pSmt->srect.bottom = pSmt->rect.bottom = pSmt->CharHeight * pSmt->MaxLines;

    pSmt->BufSize = MAXTEXTBUFFERS * pSmt->MaxLines * MAXCOLUMNS;
    pSmt->pVidBuffer = (WORD *)LocalAlloc(LMEM_FIXED | LMEM_ZEROINIT,
					  pSmt->BufSize * sizeof(WORD));

    if (pSmt->pVidBuffer) {
        pSmt->MaxTextLines = MAXTEXTBUFFERS * pSmt->MaxLines;
	for (i = 0; i < pSmt->MaxTextLines; i++) {
	    pSmt->lines[i] = (pSmt->pVidBuffer + i * MAXCOLUMNS);
	    for (j = 0; j < MAXCOLUMNS; j++)
		*(pSmt->lines[i] + j) = SP;
	}
	pSmt->MaxScrollBack = pSmt->MaxTextLines - pSmt->MaxLines;

	pSmt->TopScroll = pSmt->TopOrgLine = 0;
	pSmt->BottomScroll = pSmt->BottomOrgLine = pSmt->MaxLines - 1;
	pSmt->CurLine = 0;
	pSmt->CurLineOffset = 0;
	pSmt->Pos.x = pSmt->Pos.y = 0;
	for (i = 0; i < MAXCOLUMNS; i++) {
	    if ((i > 0) && ((i % 8) == 0))
		pSmt->TabStops[i] = 'T';
	    else
		pSmt->TabStops[i] = SP;
	}
    }	   	    
}

