#include <windows.h>    /* required for all Windows applications */
#include <assert.h>    /* required for all Windows applications */
#include "wizunzip.h"                /* specific to this program              */
#include "unzip.h"     

/* Action.c module of WizUnzip.
 * Author: Robert A. Heath, 1992
 * I, Robert Heath, place this source code module in the public domain.
 */
char NoMemoryMsg[] = 
			"Insufficient memory for this operation!";

int	MsWinDoAll;

BOOL bIconSwitched = FALSE;	/* set true after 1st valid action	*/

/* Get Selection Count returns a count of the selected 
 * list box items. If the count is  greater than zero, it also returns
 * a pointer to a locked list in local memory of the item nos.
 * and their local memory handle.
 * A value of -1 indicates an error.
 */
int GetLBSelCount(HWND hListBox, int **ppnSelItems)
{
int	nSelCount = (int)SendMessage(hListBox, LB_GETSELCOUNT, 0, 0L);
int	nRetrieved;

	if (nSelCount)
	{
    	*ppnSelItems = (int *)LocalAlloc(LMEM_FIXED, nSelCount * sizeof(int));

		assert(*ppnSelItems); /* DEBUG */
		if (!*ppnSelItems)
		{
			return(-1);
		}
		nRetrieved = (int)SendMessage(hWndList, LB_GETSELITEMS, nSelCount, (LONG)(LPSTR)*ppnSelItems);
		assert(nRetrieved == nSelCount);
		if (nRetrieved != nSelCount)
		{
			LocalFree((HANDLE)*ppnSelItems);
			return(-1);
		}
	}
	return(nSelCount);
}

/* Re-select listbox contents from given list. The pnSelItems is a
 * list containing the indices of those items selected in the listbox.
 * This list was probably created by GetLBSelCount() above.
 */
void ReselectLB(HWND hListBox, int	nSelCount, int *pnSelItems)
{
int i;

	for (i = 0; i < nSelCount; i++)
	{
		SendMessage(hListBox, LB_SETSEL, TRUE, MAKELONG(pnSelItems[i],0));
	}
}


/* Action is called on double-clicking, or selecting one of the 3
 * main action buttons. The action code is the action
 * relative to the listbox or the button ID.
 */
void Action(WORD wActionCode)
{
int i;
int nLength;
int *pnSelItems;			/* pointer to list of selected items	*/
int	nSelCount = GetLBSelCount(hWndList, &pnSelItems);
char szBuffer[100];			/* scratch buffer		*/

	if (nSelCount < 1)		/* if no items were selected			*/
		return;

	/* Note: this global value can be overriden in replace.c
	 */
	MsWinDoAll = (bOverwrite) ? 1 : 0;
    hSaveCursor = SetCursor(hHourGlass);
    ShowCursor(TRUE);       /* show it      */

	/* march through list box checking what's selected
	 * and what is not.
	 */
	for (i = 0; i < nSelCount ; i++)
	{
		/* extract item from list box...		*/
		if ((nLength = (int)SendMessage(hWndList, LB_GETTEXT, 
							pnSelItems[i], (LONG)(LPSTR)szBuffer)) > 0)
		{
		WORD wIndex = !wFormat ? /* index of filename in buffer */
				SHORT_FORM_FNAME_INX:LONG_FORM_FNAME_INX;

		PSTR pfn = &szBuffer[wIndex]; /* points to filename */
		/* fake arg list for process_zipfile() */
		static char *FileNameVector[] = { "", "" }; 
		
			WinAssert(nLength < (sizeof(szBuffer)-1)); /* DEBUG */
			FileNameVector[0] = pfn; 	/* pass desired filename */
			switch (wActionCode) {
			case 0:			/* extract							*/
				if (SetUpToProcessZipFile(0, 0, 0, 1, 0, 
								(int)(bRecreateDirs ? 1 : 0), 
								MsWinDoAll, (int)(bTranslate ? 1 : 0),
									1, szFileName, FileNameVector))
					process_zipfile();	/* call into unzip.c		*/

				else 
					MessageBox(hMainWnd, NoMemoryMsg, NULL, 
								MB_OK|MB_ICONEXCLAMATION); 
				
				TakeDownFromProcessZipFile();	/* clean house	*/
				break;
			case 1:				/* display to message window		*/
				bRealTimeMsgUpdate = FALSE;
				if (SetUpToProcessZipFile(1, 0, 0, 1, 0,  0, 0, 0,
									1, szFileName, FileNameVector))
					process_zipfile();	/* call into unzip.c		*/

				else 
					MessageBox(hMainWnd, NoMemoryMsg, NULL, 
								MB_OK|MB_ICONEXCLAMATION); 
				
				TakeDownFromProcessZipFile();	/* clean house	*/
				bRealTimeMsgUpdate = TRUE;
				UpdateMsgWndPos();				/* update window now */
				break;
			case 2:				/* test							*/
				if (SetUpToProcessZipFile(0, 1, 0, 1, 0,  0, 0, 0,
									1, szFileName, FileNameVector))
					process_zipfile();	/* call into unzip.c		*/

				else 
					MessageBox(hMainWnd, NoMemoryMsg, NULL, 
								MB_OK|MB_ICONEXCLAMATION); 
				
				TakeDownFromProcessZipFile();	/* clean house	*/
				break;
			}
		}
	}
    pnSelItems = (int *)LocalFree((HANDLE)pnSelItems);  /* Returns it to Windows */
	assert(!pnSelItems);	/* DEBUG */
    ShowCursor(FALSE);      /* turn off cursor      */
    SetCursor(hSaveCursor); /* restore the cursor   */
	if (!bIconSwitched) 	/* if haven't already, switch icons	*/
	{
	HANDLE hIcon;

	    hIcon = LoadIcon(hInst,"UNZIPPED"); /* load final icon   */
		assert(hIcon);	/* DEBUG */
		SetClassWord(hMainWnd, GCW_HICON, hIcon);
		bIconSwitched = TRUE;	/* flag that we've switched it	*/
	}

}

/* Display the archive comment using the Info-ZIP engine.
 */
void DisplayComment(void)
{

    hSaveCursor = SetCursor(hHourGlass);
    ShowCursor(TRUE);       /* show it      */
	bRealTimeMsgUpdate = FALSE;
	if (SetUpToProcessZipFile(0, 0, 0, 1, 1, 0, 0, 0,
						0, szFileName, NULL))
		process_zipfile();	/* call into unzip.c		*/

	else 
		MessageBox(hMainWnd, NoMemoryMsg, NULL, 
					MB_OK|MB_ICONEXCLAMATION); 
	
	TakeDownFromProcessZipFile();	/* clean house	*/
    ShowCursor(FALSE);      /* turn off cursor      */
    SetCursor(hSaveCursor); /* restore the cursor   */
	bRealTimeMsgUpdate = TRUE;
	UpdateMsgWndPos();		/* update window now 	*/
}
