#include <windows.h>
#include <assert.h>
#include <string.h>
#include <io.h>
#include <stdio.h>
#include "wizunzip.h"
#include "chdir.h"
#include "helpids.h"


#define FILES        39
#define PATH         -16368

#define FILESPEC_LEN 12

extern char szHelpFileName[];		/* help file name						*/

BOOL FAR PASCAL ChDirProc(HWND hDlg, WORD message, WORD wParam, LONG lParam);


extern char szAppName[];		/* application name				*/
static char szFileSpec[FILESPEC_LEN]; 		// Initial File Specification

BOOL FAR PASCAL ChDirProc  (HWND hDlg, WORD message, WORD wParam, LONG lParam)
    {
    char
        cLastChar = 0x00;           /* chr 0 (last char of string)		*/
    short       nEditLen = 0x00;    /* Length of Edit Field				*/
	int nLBCurSel;					/* return value from LB_GETCURSEL	*/
	int nRetVal;					/* DlgDirList() return value		*/

    switch (message)
        {
        case WM_INITDIALOG:
        	/* Build destination combo box with appropriate entries.
		 	 * and flag the current choice.
         	 */
			strcpy(szFileSpec,"*.*");	/* initialize file spec.	*/
            SendDlgItemMessage (hDlg, CHDIR_IFNAME, EM_LIMITTEXT, MAX_DIRNAME_LEN, 0L);
            DlgDirList (hDlg, szFileSpec, CHDIR_DLIST, CHDIR_FPATH, PATH);
            SetDlgItemText (hDlg, CHDIR_IFNAME, ".");
			/* save original directory in case user cancels			*/
            GetDlgItemText (hDlg, CHDIR_FPATH, szOrigDirName, 
										MAX_DIRNAME_LEN);
            InvalidateRect (hDlg, NULL, TRUE);
            return TRUE;

        case WM_COMMAND:
            switch (wParam)
                {
                case CHDIR_DLIST:
                    switch (HIWORD (lParam))
                        {
                        case LBN_SELCHANGE:
                            DlgDirSelect (hDlg, szDirName, CHDIR_DLIST);
                            SetDlgItemText (hDlg, CHDIR_IFNAME, szDirName);
                            return TRUE;

                        case LBN_DBLCLK:
                            DlgDirSelect (hDlg, szDirName, CHDIR_DLIST);
                            DlgDirList (hDlg, szFileSpec, CHDIR_DLIST, CHDIR_FPATH, PATH);
							assert(strlen(szFileSpec) < FILESPEC_LEN);
                            SetDlgItemText (hDlg, CHDIR_IFNAME, szDirName);
                            SendMessage (hDlg, WM_COMMAND, CHDIR_OK, 0L);
                            return TRUE;
                        }
                    break;

                case CHDIR_OK:
                    GetDlgItemText (hDlg, CHDIR_IFNAME, szDirName, 
									MAX_DIRNAME_LEN);
                    nEditLen = lstrlen (szDirName);
                    cLastChar = *AnsiPrev (szDirName, szDirName + nEditLen);
                    if (strchr (szDirName, '*') || strchr (szDirName, '?'))
                        {
                        if (DlgDirList (hDlg, szDirName, CHDIR_DLIST, CHDIR_FPATH, PATH))
                            {
                            lstrcpy (szFileSpec, szDirName);
							assert(strlen(szFileSpec) < FILESPEC_LEN);
                            SetDlgItemText (hDlg, CHDIR_IFNAME, szFileSpec);
                            }
                        else
                            MessageBeep (0);
                        return TRUE;
                        }
					/* was anything selected in listbox ?
					 */
					nLBCurSel = (int)SendMessage(GetDlgItem(hDlg,CHDIR_DLIST), 
													LB_GETCURSEL, 0, 0L);
					/* If change directory failed or if a directory had
					 * been selected.
					 */
                    if (!(nRetVal = DlgDirList (hDlg, szDirName, CHDIR_DLIST, CHDIR_FPATH, PATH)) ||
						nLBCurSel != LB_ERR)
                        {
						strcpy(szDirName, ".");	/* initialize current dir. */
                        lstrcpy (szFileSpec, szDirName);
						assert(strlen(szFileSpec) < FILESPEC_LEN);
                        SetDlgItemText (hDlg, CHDIR_IFNAME, szFileSpec);
						if (!nRetVal)	/* if user specified invalid dir.	*/
							MessageBeep (0); /* give stiff reprimand */

                        return TRUE;
                        }
                    szDirName [nEditLen] = '\0';
            		GetDlgItemText (hDlg, CHDIR_FPATH, szOrigDirName, 
										MAX_DIRNAME_LEN);
					DoCaption(hMainWnd, szFileName);	/* put name in title bar	*/
                    EndDialog (hDlg, TRUE);
                    return TRUE;

				case IDCANCEL:		/* ESC key						*/
                case CHDIR_CAN:
                    szDirName[0] = 0x00;
					/* save original directory since DlgDirList touches its arg 2 */
           			SetDlgItemText (hDlg, CHDIR_FPATH, szOrigDirName);
					DlgDirList(hDlg, szOrigDirName, 0, 0, 0);	/* restore orig. dir.	*/
            		GetDlgItemText (hDlg, CHDIR_FPATH, szOrigDirName, MAX_DIRNAME_LEN);
                    EndDialog (hDlg, FALSE);
                    return TRUE;
 		case CHDIR_HELP:
               		WinHelp(hDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_CHDIR));
                    return TRUE;
               }
        }
    return FALSE;
    }

