#include <windows.h>
#include <assert.h>
#include <string.h>
#include <io.h>
#include <stdio.h>
#include "filedlg.h"
#include "helpids.h"

#define FILES        39
#define PATH         -16368

#define MAX_FILENAME_LEN 80

char
    szIFileName[MAX_FILENAME_LEN+1] = "";      	/* Input File Name					*/

extern char szAppName[];		/* application name				*/
extern char szFileName[];		/* current file name				*/
extern char szHelpFileName[];	/* help file name					*/

BOOL FAR PASCAL FileDlgProc  (HWND hDlg, WORD message, WORD wParam, LONG lParam)
    {
    char
        cLastChar = 0x00;           // chr 0 (last char of string)
    short       nEditLen = 0x00;    // Length of Edit Field
	OFSTRUCT OfStruct;				/* local open file structure		*/
	static char szFileSpec[12]; 	/* Initial File Specification		*/
    char scratch[80];               // Scratch buffer

    switch (message)
        {
        case WM_INITDIALOG:
			strcpy(szFileSpec, "*.ZIP");	/* initialize file spec	*/
            SendDlgItemMessage (hDlg, IDD_IFNAME, EM_LIMITTEXT, MAX_FILENAME_LEN, 0L);
            DlgDirList (hDlg, szFileSpec, IDD_FLIST, NULL, FILES);
            DlgDirList (hDlg, szFileSpec, IDD_DLIST, IDD_FPATH, PATH);
            SetDlgItemText (hDlg, IDD_IFNAME, szFileSpec);
            InvalidateRect (hDlg, NULL, TRUE);
            SendMessage (hDlg, WM_COMMAND, DLG_OK, 0L);
            return TRUE;

        case WM_COMMAND:
            switch (wParam)
                {
                case IDD_FLIST:
                    switch (HIWORD (lParam))
                        {
                        case LBN_SELCHANGE:
                            DlgDirSelect (hDlg, szIFileName, IDD_FLIST);
                            SetDlgItemText (hDlg, IDD_IFNAME, szIFileName);
                            return TRUE;

                        case LBN_DBLCLK:
                            DlgDirSelect (hDlg, szIFileName, IDD_FLIST);
                            SetDlgItemText (hDlg, IDD_IFNAME, szIFileName);
                            SendMessage (hDlg, WM_COMMAND, DLG_OK, 0L);
                            return TRUE;
                        }
                    break;

                case IDD_DLIST:
                    switch (HIWORD (lParam))
                        {
                        case LBN_SELCHANGE:
                            DlgDirSelect (hDlg, szIFileName, IDD_DLIST);
                            lstrcat (szIFileName, szFileSpec);
                            SetDlgItemText (hDlg, IDD_IFNAME, szIFileName);
                            return TRUE;

                        case LBN_DBLCLK:
                            DlgDirSelect (hDlg, szIFileName, IDD_DLIST);
                            lstrcat (szIFileName, szFileSpec);
                            DlgDirList (hDlg, szFileSpec, IDD_FLIST, NULL, FILES);
                            DlgDirList (hDlg, szFileSpec, IDD_DLIST, IDD_FPATH, PATH);
                            SetDlgItemText (hDlg, IDD_IFNAME, szIFileName);
                            SendMessage (hDlg, WM_COMMAND, DLG_OK, 0L);
                            return TRUE;
                        }
                    break;

                case DLG_OK:
                    GetDlgItemText (hDlg, IDD_IFNAME, szIFileName, 
										(sizeof(szIFileName)-1));
                    nEditLen = lstrlen (szIFileName);
                    cLastChar = *AnsiPrev (szIFileName, szIFileName + nEditLen);
                    if (cLastChar == '\\' || cLastChar == ':')
                        lstrcat (szIFileName, szFileSpec);
                    if (strchr (szIFileName, '*') || strchr (szIFileName, '?'))
                        {
                        DlgDirList (hDlg, szIFileName, IDD_FLIST, NULL, FILES);
                        if (DlgDirList (hDlg, szIFileName, IDD_DLIST, IDD_FPATH, PATH))
                            {
                            lstrcpy (szFileSpec, szIFileName);
                            SetDlgItemText (hDlg, IDD_IFNAME, szFileSpec);
                            }
                        else
                            MessageBeep (0);
                        return TRUE;
                        }
                    lstrcat (lstrcat (szIFileName,"\\"), szFileSpec);
                    DlgDirList (hDlg, szIFileName, IDD_FLIST, NULL, FILES);
                    if (DlgDirList (hDlg, szIFileName, IDD_DLIST, IDD_FPATH, PATH))
                        {
                        lstrcpy (szFileSpec, szIFileName);
                        SetDlgItemText (hDlg, IDD_IFNAME, szFileSpec);
                        return TRUE;
                        }
                    szIFileName [nEditLen] = '\0';
                    if (OpenFile(szIFileName, &OfStruct, OF_EXIST) < 0)
                        {
                        wsprintf (scratch, "Cannot open %s", (LPSTR)szIFileName);
                        MessageBox (hDlg, scratch, szAppName, MB_ICONINFORMATION | MB_OK);
                        return TRUE;
                        }
					strcpy(szFileName, OfStruct.szPathName); /* use valid OEM filename */
                    EndDialog (hDlg, TRUE);
                    return TRUE;

				case IDCANCEL:		/* ESC key						*/
                case DLG_CAN:
                    szIFileName [0] = 0x00;
                    EndDialog (hDlg, FALSE);
                    return TRUE;
 				case IDD_HELP:
            		WinHelp(hDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_OPEN));
            		return TRUE;
                }
        }
    return FALSE;
    }

