#include <windows.h>
#include "wizunzip.h"

/* Keyboard procedure used to sub-class all windows which can be
 * tab stops.
 */

extern char szHelpFileName[];	/* in wndproc.c					*/

/* Keyboard procedure
 * This function allows the user to tab and back-tab among the 
 * listbox, four command buttons,and message window.  
 * It traps VK_TAB messages and sets the
 * focus on the next or previous window as required.
 * Skip any disabled buttons.
 */
long FAR PASCAL KbdProc(HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
int nID = GetWindowWord(hWnd, GWW_ID); /* child window ID no.		*/
int nTabStopTableIndex = nID - TABSTOP_ID_BASE;
int nNextTabStopTableIndex = nTabStopTableIndex;

	switch (message) {
	case WM_KEYDOWN:
		if (wParam == VK_TAB)
		{
		int nRelIndex = /* forward or backward ? 					*/
					(int)(GetKeyState(VK_SHIFT) < 0 ? -1 : 1);

			do {
				nNextTabStopTableIndex += nRelIndex;
				if (nNextTabStopTableIndex < 0)
					nNextTabStopTableIndex = TABSTOP_TABLE_ENTRIES-1;

				else if (nNextTabStopTableIndex >= TABSTOP_TABLE_ENTRIES)
					nNextTabStopTableIndex = 0;
			
			}
			while (!IsWindowEnabled(TabStopTable[nNextTabStopTableIndex].hWnd));

			SetFocus(TabStopTable[nNextTabStopTableIndex].hWnd);

		}
        else if (wParam == VK_F1) {

               /* If Shift-F1, turn help mode on and set help cursor */ 

               if (GetKeyState(VK_SHIFT)<0) {
                   bHelp = TRUE;
                   SetCursor(hHelpCursor);
                   return (CallWindowProc(TabStopTable[nTabStopTableIndex].lpfnOldFunc,
							hWnd, message, wParam, lParam));
               }

               /* If F1 without shift, then call up help main index topic */ 
               else {
                   WinHelp(hMainWnd,szHelpFileName,HELP_INDEX,0L);
               }
           }

        else if (wParam == VK_ESCAPE && bHelp) {

               /* Escape during help mode: turn help mode off */
               bHelp = FALSE;
               SetCursor((HCURSOR)GetClassWord(hMainWnd,GCW_HCURSOR));
        }
		break;
	}
	return CallWindowProc(TabStopTable[nTabStopTableIndex].lpfnOldFunc,
							hWnd, message, wParam, lParam);
}			 
