#include <windows.h>    /* required for all Windows applications */
#include "replace.h"
#include "wizunzip.h"
#include "helpids.h"

extern char szHelpFileName[];	/* name of help file				*/

/****************************************************************************

    FUNCTION: Replace(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "Replace" dialog box

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL Replace(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
char Buffer[200];

    switch (message) {
	case WM_INITDIALOG:
		wsprintf(Buffer, "Replace %s ?", (LPSTR)lParam);
		SetDlgItemText(hDlg, IDM_REPLACE_TEXT, (LPSTR)Buffer);
	    return (TRUE);

	case WM_COMMAND:
	    switch (wParam) {
		case IDCANCEL:				/* ESC key							*/
		case IDOK:					/* Enter key						*/
			EndDialog(hDlg, IDM_REPLACE_NO);
			return TRUE;
		case IDM_REPLACE_ALL:
			MsWinDoAll = 1;			/* do all for life of this command */
		case IDM_REPLACE_YES:
		case IDM_REPLACE_NO:
			EndDialog(hDlg, wParam);
			return TRUE;
 		case IDM_REPLACE_HELP:
            WinHelp(hDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_OVERWRITE));
            return TRUE;
	    }
	return TRUE;
	}
	return FALSE;
}

