#include <windows.h>    /* required for all Windows applications */
#include <assert.h>    /* required for all Windows applications */
#include "wizunzip.h"                /* specific to this program              */

/* sizewndw.c module of WizUnzip.
 * Author: Robert A. Heath
 * I, Robert Heath, place this source code module in the public domain.
 */

#define MIN_LISTBOX_LINES 2

/* Call this when the window size changes or needs to change.
 */
void SizeWindow(HWND hWnd, BOOL bOKtoMovehWnd)
{
WORD wListAreaWidth;			/* width list box and modifiers */
WORD  wMinClientWidth;		/* minimum client width		*/
WORD  wButtonWidth;
int		nListBoxHeight;			/* height of listbox in pix			*/
WORD	wVariableHeight;		/* no. variable pixels on client	*/
WORD	wVariableLines;			/* no. variable lines on client window */
WORD	wMessageBoxHeight;		/* message box height in pixels		*/
int	nCxBorder = GetSystemMetrics(SM_CXBORDER);
int	nCyBorder = GetSystemMetrics(SM_CYBORDER);
int	nCxVscroll = GetSystemMetrics(SM_CXVSCROLL); /* vertical scroll width */
int	nCyHscroll = GetSystemMetrics(SM_CYHSCROLL); /* vertical scroll width */
int nCyCaption = GetSystemMetrics(SM_CYCAPTION); /* caption height		*/
int	nButtonsYpos;
short xClient, yClient; 		/* size of client area	*/
RECT WindowRect;				/* full window rectangle structure			*/
RECT ClientRect;				/* full window rectangle structure			*/

		GetWindowRect(hWnd, &WindowRect);
		GetClientRect(hWnd, &ClientRect);
		xClient = ClientRect.right-ClientRect.left+1; /* x size of client area */
		yClient = ClientRect.bottom-ClientRect.top+1; /* y size of client area */
		if (bStatusMaxed)
		{
					/* position the status window to fill entire client window	 */
			MoveWindow(hWndStatus, 
				0, 
				0,
				xClient,
				yClient, TRUE);
				MessageWinLines = yClient / ychar ;

		}
		else	/* else status window is its normal size			*/
		{
		/* List Box gets roughly 1/2 of lines left over on client
		 * window after subtracting fixed overhead for borders,
		 * horizontal scroll bar,
		 * button margin spacing, header, and trailer lines.
		 */
		wVariableHeight =  yClient - (4 * nCyBorder) - (7 * ychar) - 
							nCyHscroll - nCyCaption;
		wVariableLines = wVariableHeight / ychar;
		ListBoxLines =  wVariableLines / 2 ; 

		if (ListBoxLines < MIN_LISTBOX_LINES)
			ListBoxLines = MIN_LISTBOX_LINES;

		MessageWinLines = wVariableLines - ListBoxLines; /* vis. msg. wnd lines */

		wListAreaWidth = 
		   (!wFormat ? MIN_SHORT_FORMAT_CHARS : MIN_LONG_FORMAT_CHARS) * xchar +
						  nCxVscroll + 2 * nCxBorder;
		wMinClientWidth = wListAreaWidth;
		/* if we moved the hWnd from WM_SIZE, we'd probably get into
		 * a nasty, tight loop since this generates a WM_SIZE.
		 */
		if (bOKtoMovehWnd && xClient < wMinClientWidth)
		{
			xClient = wMinClientWidth;
			MoveWindow(hWnd, WindowRect.left, WindowRect.top, xClient + 2*GetSystemMetrics(SM_CXFRAME), yClient, TRUE);
		}
		/* divide buttons up into 4 equal zones each button separated by
		 * a 1-character buffer.
		 */
		wButtonWidth = (xClient - 5 * xchar)/4 ; /* width of button itself */

		MoveWindow(hWndHeaderLine1, 
				nCxBorder, 0,
				xClient,
				ychar, TRUE);

		MoveWindow(hWndHeaderLine2, 
				nCxBorder, ychar,
				xClient,
				ychar, TRUE);

		nListBoxHeight = ListBoxLines * ychar + 2 * nCyBorder;
		MoveWindow(hWndList, 		
				0, 2*ychar ,
				xClient,
				nListBoxHeight,
				TRUE);


		MoveWindow(hWndTotalLine1, 
				nCxBorder, 
				((ListBoxLines+2) * ychar + (2 * nCyBorder)),
				xClient,
				ychar, TRUE);

		MoveWindow(hWndTotalLine2, 
				nCxBorder, ((ListBoxLines+3) * ychar + (2 * nCyBorder)),
				xClient,
				ychar, TRUE);

		nButtonsYpos = ListBoxLines * ychar + 
						9 * ychar / 2 + (2 * nCyBorder);

		/* position the 4 buttons								*/
		MoveWindow(hExtract, 
				xchar,	  
				nButtonsYpos,
				wButtonWidth ,   2 * ychar,
				TRUE);

		MoveWindow(hDisplay,
				wButtonWidth+ (2 * xchar),	  
					nButtonsYpos,
					wButtonWidth ,   2 * ychar,
				TRUE);

		MoveWindow(hTest,
				2*(wButtonWidth+xchar)+xchar,	  
					nButtonsYpos,
					wButtonWidth ,   2 * ychar,
				TRUE);

		MoveWindow(hShowComment,
				3*(wButtonWidth+xchar)+xchar,	  
					nButtonsYpos,
					wButtonWidth ,   2 * ychar,
				TRUE);


		/* Position the status (Message) window.
		 * The Message windows is positioned relative to the bottom
		 * of the client area rather than relative to the top of the client.
		 */
		wMessageBoxHeight = wVariableHeight - nListBoxHeight + 
							2 * nCyBorder + 
							nCyHscroll + nCyCaption ;

		MoveWindow(hWndStatus, 
				0, yClient - wMessageBoxHeight,
				xClient,
				wMessageBoxHeight, TRUE);
		} /* bottom of status window is normal size			*/
}
