#include <windows.h>    /* required for all Windows applications */
#include <assert.h>    /* required for all Windows applications */
#include "wizunzip.h"                /* specific to this program              */
#include "unzip.h"     

/* updatelb.c module of WizUnzip.
 * Author: Robert A. Heath
 * I, Robert Heath, place this source code module in the public domain.
 */

/* Trailers are the lines just above the totals
 */
static char *Trailers[2] = {
" ------                    -------",
" ------          ------  ---                              -------"
} ;

/* Update Buttons is called when an event possibly modifies the 
 * number of selected items in the listbox. 
 * The function reads the number of selected items. 
 * A non-zero value enables relevant buttons and menu items.
 * A zero value disables them.
 */
void
UpdateButtons(HWND hWnd)
{
BOOL bButtonState;

	if (szFileName[0] &&
		SendMessage(hWndList, LB_GETSELCOUNT, 0, 0L)) /* anything selected ? */
	{
		bButtonState = TRUE;
	}
	else
	{
		bButtonState = FALSE;
	}
	EnableWindow(hExtract, bButtonState);
	EnableWindow(hDisplay, bButtonState);
	EnableWindow(hTest, bButtonState);
	EnableWindow(hShowComment, (BOOL)(szFileName[0] && wCommentLength ? TRUE : FALSE));
}

/* Update List Box attempts to fill the list box on the parent
 * window with the next "ListBoxLines" of personal data from the 
 * current position in the file.
 * UpdateListBox() assumes that the a record has been read in when called.
 * The TotalZippedFiles variable indicates whether or not a record exists.
 * The bForward parameter controls whether updating precedes forward
 * or reverse.
 */
void
UpdateListBox(HWND hWnd)
{

	SetWindowText(hWndHeaderLine1, (LPSTR)Headers[wFormat][0]);
	SetWindowText(hWndHeaderLine2, (LPSTR)Headers[wFormat][1]);
	SetWindowText(hWndTotalLine1 , (LPSTR)Trailers[wFormat]);
	SetWindowText(hWndTotalLine2 , (LPSTR)"");

	SendMessage(hWndList, LB_RESETCONTENT, 0, 0L);
	TotalZippedFiles = 0;		/* assume no personal records 		*/
 	if (szFileName[0]) 		/* file selected ? 					*/
	{	/* if so -- stuff list box				*/
		SendMessage(hWndList, WM_SETREDRAW, FALSE, 0L);
		if (SetUpToProcessZipFile(0, 0, 
				(int)(!wFormat ? 1 : 2), 1, 0, 0, 0, 0,
							0, szFileName, NULL))
			process_zipfile();	/* call into unzip.c		*/

		else 
			MessageBox(hMainWnd, NoMemoryMsg, NULL, 
						MB_OK|MB_ICONEXCLAMATION); 
		
		TakeDownFromProcessZipFile();	/* clean house	*/
#ifndef NEED_EARLY_REDRAW
		SendMessage(hWndList, WM_SETREDRAW, TRUE, 0L);
		InvalidateRect(hWndList, NULL, TRUE);	/* force redraw			*/
#endif
		TotalZippedFiles = (WORD)SendMessage(hWndList, LB_GETCOUNT, 0, 0L);
		assert((int)TotalZippedFiles != LB_ERR);
		if (TotalZippedFiles)	/* if anything went into listbox set to top */
		{
#ifdef NEED_EARLY_REDRAW
			UpdateWindow(hWndList);	/* paint now!					*/
#endif
			SendMessage(hWndList, LB_SETTOPINDEX, 0, 0L);
		}
#ifdef NEED_EARLY_REDRAW
		else /* no files were unarchived!							*/
		{
			/* Add dummy message to initialize list box then clear it
			 * to prevent strange problem where later calls to 
			 * UpdateListBox() do not result in displaying of all contents.
 			 */
			SendMessage(hWndList, LB_ADDSTRING, 0, (LONG)(LPSTR)" ");
			UpdateWindow(hWndList);	/* paint now!					*/
		}
#endif
	}
#ifdef NEED_EARLY_REDRAW
	else
	{
		/* Add dummy message to initialize list box then clear it
		 * to prevent strange problem where later calls to 
		 * UpdateListBox() do not result in displaying of all contents.
 		 */
		SendMessage(hWndList, LB_ADDSTRING, 0, (LONG)(LPSTR)" ");
		UpdateWindow(hWndList);	/* paint now!					*/
	}
#endif

}
