#include <windows.h>    /* required for all Windows applications */
#include <assert.h>    /* required for all Windows applications */
#include "wizunzip.h"                /* specific to this program              */

long FAR PASCAL WizUnzipWndProc(HWND, unsigned, WORD, LONG);

/****************************************************************************

    FUNCTION: WizUnzipInit(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

        Sets up a structure to register the window class.  Structure includes
        such information as what function will process messages, what cursor
        and icon to use, etc.

        This provides an example of how to allocate local memory using the
        LocalAlloc() call instead of malloc().  This provides a handle to
        memory.  When you actually need the memory, LocalLock() is called
        which returns a pointer.  As soon as you are done processing the
        memory, call LocalUnlock so that Windows can move the memory as
        needed.  Call LocalLock() to get a pointer again, or LocalFree() if
        you don't need the memory again.


****************************************************************************/
BOOL WizUnzipInit(HANDLE hInstance)
{
    HANDLE hMemory;                            /* handle to allocated memory */
    PWNDCLASS pWndClass;                       /* structure pointer          */

    hMemory = LocalAlloc(LMEM_MOVEABLE, sizeof(WNDCLASS));
	assert(hMemory);	/* DEBUG */
    pWndClass = (PWNDCLASS) LocalLock(hMemory);

    pWndClass->style = CS_HREDRAW | CS_VREDRAW;
    pWndClass->lpfnWndProc = WizUnzipWndProc;
    pWndClass->hInstance = hInstance;
    pWndClass->hIcon = LoadIcon(hInstance, "WizUnzip");
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
    pWndClass->hbrBackground = BG_SYS_COLOR+1; /* set background color */
    pWndClass->lpszMenuName = (LPSTR) "WizUnzip";
    pWndClass->lpszClassName = (LPSTR) szAppName;
    pWndClass->cbClsExtra     = 0;
    pWndClass->cbWndExtra     = 0;


    if (!RegisterClass(pWndClass))
    {
    	LocalUnlock(hMemory);                           /* Unlocks the memory    */
  	  LocalFree(hMemory);                             /* Returns it to Windows */
	return(FALSE);
    }
	/* define status class
 	 */
    pWndClass->lpszClassName = (LPSTR) szStatusClass;
   pWndClass->style = CS_HREDRAW | CS_VREDRAW;
    pWndClass->lpfnWndProc = StatusProc;
    pWndClass->hInstance = hInstance;
    pWndClass->hIcon = NULL;
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
    pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH);
    pWndClass->lpszMenuName = NULL;
    if (!RegisterClass(pWndClass))
	{
    	LocalUnlock(hMemory);                           /* Unlocks the memory    */
  	  LocalFree(hMemory);                             /* Returns it to Windows */
	return(FALSE);
    }
    LocalUnlock(hMemory);                           /* Unlocks the memory    */
    LocalFree(hMemory);                             /* Returns it to Windows */
   return (TRUE);           /* Returns result of registering the window */
}

