/* Main include file for  Windows Unzip: unzip.h
 * This include file is copied into all `C' source modules specific to 
 * Windows Info-ZIP Unzip.
 * Author: Robert A. Heath, 157 Chartwell Rd., Columbia, SC 29210
 * I, Robert A. Heath, place this module, wizunzip.h, in the public domain.
 */

/* These two are dependent on zip directory listing format string.
 * They help find the filename in the listbox entry.
 */
#define SHORT_FORM_FNAME_INX	27
#define LONG_FORM_FNAME_INX	58

#define MIN_SHORT_FORMAT_CHARS (SHORT_FORM_FNAME_INX+12)
#define MIN_LONG_FORMAT_CHARS (LONG_FORM_FNAME_INX+12)

#define MAX_DIRNAME_LEN 80

/* Arbitrary Constants
 */
#define STATUS_ROWS 6			/* typical no. status box rows		*/
#define BG_SYS_COLOR COLOR_GRAYTEXT /* background color is a system color */

/* Main window menu item positions
 */
#define HELP_MENUITEM_POS		5	/* the Help menu				*/

/* Main Window Message Codes
 */

#define IDM_OPEN            101
#define IDM_EXIT            102

#define IDM_SHORT			104
#define IDM_LONG			105


#define	IDM_HELP			106
#define	IDM_ABOUT			107

#define IDM_RECR_DIR_STRUCT 108
#define IDM_OVERWRITE		109
#define IDM_TRANSLATE		110
#define IDM_UNZIP_TO_ZIP_DIR 111

#define IDM_EDIT           	112
#define IDM_PATH             113


#define IDM_HEADER_LINE1			115
#define IDM_HEADER_LINE2			116
#define IDM_COMMENT			117
#define IDM_TOTAL_LINE1		118
#define IDM_TOTAL_LINE2		119

#define IDM_SELECT_ALL		120

/* These six items are the tab-stop windows whose ID's must be kept
 * in order.
 */
#define IDM_LISTBOX          121
#define IDM_EXTRACT			122
#define IDM_DISPLAY			123
#define	IDM_TEST			124
#define IDM_SHOW_COMMENT	125
#define IDM_STATUS			126
#define TABSTOP_ID_BASE IDM_LISTBOX

#define IDM_MAX_STATUS		127
#define IDM_RESTORE_STATUS	128

#define IDM_LB_EXTRACT		135
#define IDM_LB_DISPLAY		136
#define IDM_LB_TEST			137
#define IDM_DESELECT_ALL	138
#define IDM_CLEAR_STATUS	139
#define IDM_HELP_KEYBOARD	140
#define IDM_HELP_HELP		141
#define IDM_CHDIR			142


/* Help Window Menu and Message ID's
 */
#define INDEX_MENU_ITEM_POS 0

#define IDM_FORWARD 100
#define IDM_BACKWARD 101 


/* Tab-stop table is used to sub-class those main window items to
 * which the tab and back-tab keys will tab and stop.
 */
typedef struct TabStop_tag {
	FARPROC lpfnOldFunc;		/* original function				*/
	HWND hWnd ;			
} TabStopEntry;

typedef TabStopEntry *PTABSTOPENTRY;
#define TABSTOP_TABLE_ENTRIES 6

#define MAKE_TABSTOP_TABLE_ENTRY(WNDHANDLE, ID) \
	{ \
		TabStopTable[ID - TABSTOP_ID_BASE].lpfnOldFunc = \
			(FARPROC)GetWindowLong(WNDHANDLE, GWL_WNDPROC); \
		SetWindowLong(WNDHANDLE, GWL_WNDPROC, (LONG)lpfnKbdProc); \
		TabStopTable[ID - TABSTOP_ID_BASE].hWnd = WNDHANDLE; \
	}

#ifndef NDEBUG
#define WinAssert(exp) \
		{\
		if (!(exp))\
			{\
			char szBuffer[40];\
			sprintf(szBuffer, "File %s, Line %d",\
					__FILE__, __LINE__) ;\
			if (IDABORT == MessageBox(NULL, szBuffer,\
				"Assertion Error",\
				MB_ABORTRETRYIGNORE|MB_ICONSTOP))\
					FatalExit(-1);\
			}\
		}

#else

#define WinAssert(exp)

#endif

		
extern TabStopEntry TabStopTable[]; /* tab-stop control table			*/

extern BOOL bStatusMaxed ;	/* status box is maximized when true		*/
extern WORD wHelpItem;			/* item to pass to Help proc			*/
extern short xchar, ychar;    /* size of char in SYSTEM font in pixels    */

extern HANDLE hFixedFont;

extern HWND hWndComment;		/* comment window						*/

extern HWND	hWndHeaderLine1;	 /* header line 1						*/
extern HWND	hWndHeaderLine2;	 /* header line 2						*/

extern HWND	hWndTotalLine1;	 /* total line 1						*/
extern HWND	hWndTotalLine2;	 /* total line 2						*/

extern HWND hWndList;		/* listbox handle						*/

extern HWND	hMainWnd;		 /* the main window handle. 		*/

extern HWND hExtract;			/* extract button				*/
extern HWND hDisplay;			/*display button				*/
extern HWND hTest;				/* test button					*/
extern HWND hShowComment;		/* show comment button			*/
extern HANDLE hInst;                       /* current instance                      */
extern HMENU  hMenu;			    /* main menu handle			*/
extern HANDLE hAccTable;

extern HANDLE hHourGlass;			  /* handle to hourglass cursor	     */
extern HANDLE hSaveCursor;			  /* current cursor handle	     */
extern HANDLE hHelpCursor;			/* help cursor				*/
extern HANDLE hFixedFont;			/* handle to fixed font				*/
extern HANDLE hOldFont;			/* handle to old font				*/

extern int hFile;				  /* file handle		     */
extern int	MsWinDoAll;				/* referenced in file_io.c		*/
extern HWND hHelpWnd;				/* Help Window handle					*/
extern HWND	hWndList;			  /* list box handle		*/
extern HWND hWndStatus;		/* status	*/
extern HWND hDlgAbout;				/* handle to about box				*/

extern BOOL bHelp;			/* help key has been hit when TRUE			*/
extern BOOL bRealTimeMsgUpdate; /* update messages window in real-time */
extern BOOL bRecreateDirs;	/* re-create directory structures when TRUE */
extern BOOL bTranslate;	/* translate LF to CR-LF					*/
extern WORD wFormat;		/* display format: 0 = short, 1 = long */
extern BOOL bOverwrite;		/* overwrite files: IDM_PROMPT, IDM_OVERWRITE */
extern BOOL bUnzipToZipDir;	/* unzip to .ZIP dir; else keep separate */
extern WORD wLBSelection;	/* default listbox selection action */
extern HWND hDlgHelp;			  	  /* Help dialog handler	     */

extern FARPROC  lpHelpDlg;		/* Help Dialog proc instance		*/

extern HBRUSH hBrush ;			/* brush for  standard window backgrounds  */

extern char szAppName[];		/* application name				*/
extern char szFileName[];		/* current file name in ANSI		*/
extern char szDirName[];  		/* resultant Directory Name		*/
extern char szOrigDirName[];	/* original directory name		*/
extern char szStatusClass[];	/* status class name				*/
extern char *Headers[][2] ;		/* headers to display			*/
extern char FORMAT_KEY[];		/* Format WIN.INI keyword		*/
extern char OVERWRITE_KEY[];	/* Overwrite WIN.INI keyword		*/
extern char TRANSLATE_KEY[];	/* Translate WIN.INI keyword		*/
extern char LBSELECTION_KEY[];	/* LBSelection keyword in WIN.INI */
extern char RECREATE_DIRS_KEY[]; /* re-create directory structure 
									WIN.INI keyword 			*/
extern char UNZIP_TO_ZIP_DIR_KEY[];   /* unzip to .ZIP dir WIN.INI keyword */

extern char *LBSelectionTable[];
extern char NoMemoryMsg[] ;		/* error message			*/
extern WORD wCommentLength ;	/* length of comment in .ZIP file	*/

/* List box stuff
 */
extern WORD	TotalZippedFiles;		/* total personal records in file	*/
extern WORD ListBoxLines; /* max list box lines showing on screen */
extern WORD MessageWinLines; /* max visible lines on message window  */

void DoCaption(HWND hWnd, PSTR szFileName);
int DoFileOpenDlg(HANDLE hInst, HWND hWnd, PSTR szFileSpecIn, PSTR szDefExtIn, 
				WORD wFileAttrIn, PSTR szFileNameOut, POFSTRUCT pofIn);


/* some global functions
 */
void Action(WORD wActionCode);
int unzipmain(int argc, char *argv[]);
void DisplayComment(void);
int GetLBSelCount(HWND hListBox, int **ppnSelItems);
void IndexHelp(HWND hWnd, HMENU hMenu, PSTR HelpFile);	/* index help file	*/
void ReselectLB(HWND hListBox, int nSelCount, int *pnSelItems);
BOOL SetUpToProcessZipFile(int ncflag, int ntflag, int nvflag, int nUflag, 
							int nzflag, int ndflag, int noflag, int naflag,
							int argc, PSTR psZipFN, PSTR *FNV);
void TakeDownFromProcessZipFile(void);
void SizeWindow(HWND hWnd, BOOL bOKtoMovehWnd);
void UpdateButtons(HWND hWnd);
void UpdateListBox(HWND hWnd);
void UpdateMsgWndPos(void);
BOOL WizUnzipInit(HANDLE hInst);
void WriteBufferToMsgWin(LPSTR buffer, int nBufferLen, BOOL bUpdate);
void WriteStringToMsgWin(PSTR String, BOOL bUpdate);

/* Far Proc's
 */
BOOL FAR PASCAL About(HWND hDlg, WORD message, WORD wParam, LONG lParam);
BOOL FAR PASCAL ChDirProc(HWND hDlg, WORD message, WORD wParam, LONG lParam);
BOOL FAR PASCAL FileDlgProc(HWND hDlg, WORD message, WORD wParam, LONG lParam);
long FAR PASCAL HelpWndProc (HWND hWnd, unsigned iMessage, WORD wParam, LONG lParam); 
long FAR PASCAL KbdProc(HWND hWnd, WORD message, WORD wParam, LONG lparam);
BOOL FAR PASCAL Replace(HWND hDlg, WORD message, WORD wParam, LONG lParam);
long FAR PASCAL StatusProc (HWND hWnd, unsigned iMessage, WORD wParam, LONG lParam); 
