#
# Makefile for Windows Info-ZIP Unzip, wizunzip
# A non-profit Windows unzipper.
#
# by Robert Heath, Columbia,SC
# CIS: 71600,437
# April 26, 1992
#
DEFS= -D LINT_ARGS -D _COLOR_ -D MSWIN

# Uncomment following statement to insert CodeView debugging info
# and turn off optimization. Put back as comment for production.
#CDEBUGDEFS=-Zi -Od

# Uncomment following three statements to turn on aliasing and space
# optimization for production. Put back as comment for debugging.
OPT=-Oas
REGISTER=register
CDEBUGDEFS=-DNDEBUG 

CFLAGS=-AM -FPa $(DEFS) -Gsw $(OPT) -W3 -Zpe $(CDEBUGDEFS) -DREGISTER=$(REGISTER)

# Uncomment following statement to insert CodeView debugging information.
# Put comment back for production.
#LDEBUG=/CO

LFLAGS=/M /NOD $(LDEBUG)

.c.obj:
	cl -c $(CFLAGS) -NT wizu_$* $*.c

O=.obj

# original unzip .objs
UNZIPOBJS = unzip$O file_io$O mapname$O match$O misc$O\
       unimplod$O unreduce$O unshrink$O

WINOBJSA=wizunzip.obj filedlg.obj status.obj winit.obj replace.obj
WINOBJSB=wndproc.obj about.obj action.obj sizewndw.obj updatelb.obj
WINOBJSC=kbdproc.obj chdir.obj
OBJS=$(WINOBJSA) $(WINOBJSB) $(WINOBJSC) $(UNZIPOBJS)

all: wizunzip.exe wizunzip.hlp


wizunzip.exe: $(OBJS) wizunzip.def wizunzip.res wizunzip.lnk 
	link @wizunzip.lnk
	rc wizunzip.res


wizunzip.lnk: wizunzip.mk
	echo $(LFLAGS) 			+>$@
	echo $(WINOBJSA)	   +>>$@
	echo $(WINOBJSB)	   +>>$@
	echo $(WINOBJSC)	   +>>$@
	echo $(UNZIPOBJS)		>>$@
	echo wizunzip.exe		>>$@
	echo wizunzip.map		>>$@
	echo libw mlibcaw		>>$@
	echo wizunzip.def		>>$@

wizunzip.hlp: wizunzip.rtf helpids.h wizunzip.hpj
    hc wizunzip

action.obj: action.c wizunzip.h 

chdir.obj: chdir.c wizunzip.h chdir.h helpids.h

filedlg.obj: filedlg.c filedlg.h helpids.h

kbdproc.obj: kbdproc.c wizunzip.h 

replace.obj: replace.c replace.h wizunzip.h helpids.h

sizewndw.obj: sizewndw.c wizunzip.h 

status.obj: status.c wizunzip.h 

updatelb.obj: updatelb.c wizunzip.h 

winit.obj: winit.c wizunzip.h 

wizunzip.obj: wizunzip.c wizunzip.h 

wndproc.obj: wndproc.c wizunzip.h helpids.h


# targets for Windows-independent targets
unimplode.obj unreduce.obj unshrink.obj: unzip.h

# targets for Windows-dependent targets
unzip.obj mapname.obj match.obj misc.obj : unzip.h wizunzip.h

file_io.obj: file_io.c unzip.h wizunzip.h replace.h

wizunzip.res: wizunzip.rc wizunzip.ico about.dlg wizunzip.h filedlg.dlg replace.dlg replace.h help.cur chdir.h chdir.dlg
       rc -r wizunzip.rc

