#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>                
#include <string.h>             
#include <windows.h>    /* required for all Windows applications */
#include <assert.h>    /* required for all Windows applications */
#include "wizunzip.h"                /* specific to this program              */
#include "helpids.h"

/* Windows Info-ZIP Unzip Window Procedure, wndproc.c.
 * Author: Robert A. Heath, 157 Chartwell Rd., Columbia, SC 29210
 * I, Robert Heath, place this source code module in the public domain.
 */

#define BUTTON_CHARS		16	/* button width in chars		*/
#define STATUS_ROWS 6
#define BUTTONS_ROW  16


static char FormatKeyword[2][6] = { "short", "long" };

char szHelpFileName[] = "WIZUNZIP.HLP";

short xchar, ychar;    /* size of char in SYSTEM font in pixels    */

/* button control table	-- one entry for 
 * each of 4 entries. Indexed by the window ID relative to
 * the first tabstop (TABSTOP_ID_BASE).			
 */
TabStopEntry TabStopTable[TABSTOP_TABLE_ENTRIES]; 


/****************************************************************************

    FUNCTION: WizunzipWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

	WM_DESTROY    - destroy window
	WM_SIZE	      - window size has changed
	WM_QUERYENDSESSION - willing to end session?
	WM_ENDSESSION - end Windows session
	WM_CLOSE      - close the window
	WM_SIZE	      - window resized

    COMMENTS:

	WM_COMMAND processing:

	    IDM_OPEN -  open a new file.


	    IDM_EXIT - query to save current file if there is one and it
		       has been changed, then exit.

	    IDM_ABOUT - display "About" box.

****************************************************************************/

long FAR PASCAL WizunzipWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    FARPROC lpProcAbout, lpProcFileDlg, lpProcChDir;

    HDC hDC;			    /* device context 		*/
    TEXTMETRIC	  tm;		    /* text metric structure	*/
static WORD  wButtonWidth ;
static WORD xScreen, yScreen;
POINT point;
BOOL FileDlgRetVal;
FARPROC lpfnKbdProc;
   DWORD   dwHelpContextId;	/* help context ID			*/
char szBuffer[100];


    switch (message) {
	case WM_CREATE:	/* create  window		*/
			xScreen = GetSystemMetrics(SM_CXSCREEN);
			yScreen = GetSystemMetrics(SM_CYSCREEN);
	    	hInst = ((LPCREATESTRUCT)lParam)->hInstance;
			lpfnKbdProc = MakeProcInstance((FARPROC)KbdProc, hInst);
	    	hAccTable = LoadAccelerators(hInst, "WizunzipAccels");
			hBrush = CreateSolidBrush(GetSysColor(BG_SYS_COLOR)); /* background */

    		hMenu = GetMenu(hWnd);		/* get menu handle		     */
			/* Check Menu items to reflect WIN.INI settings
			 */
			CheckMenuItem(hMenu, IDM_RECR_DIR_STRUCT, MF_BYCOMMAND| 
							(WORD)(bRecreateDirs ? MF_CHECKED : MF_UNCHECKED));
			CheckMenuItem(hMenu, (IDM_SHORT+wFormat), MF_BYCOMMAND|MF_CHECKED);
			CheckMenuItem(hMenu,IDM_OVERWRITE,MF_BYCOMMAND|
								(WORD)(bOverwrite ? MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(hMenu,IDM_TRANSLATE,MF_BYCOMMAND|
								(WORD)(bTranslate ? MF_CHECKED:MF_UNCHECKED));
			CheckMenuItem(hMenu,wLBSelection,MF_BYCOMMAND|MF_CHECKED);
			CheckMenuItem(hMenu,IDM_UNZIP_TO_ZIP_DIR,MF_BYCOMMAND|
								(WORD)(bUnzipToZipDir ? MF_CHECKED:MF_UNCHECKED));
			EnableMenuItem(hMenu,IDM_CHDIR,MF_BYCOMMAND|
								(WORD)(bUnzipToZipDir ? MF_GRAYED:MF_ENABLED));
    		 /* Get an hourglass cursor to use during file transfers */

    		hHourGlass = LoadCursor(NULL, IDC_WAIT);
  			hFixedFont = GetStockObject(SYSTEM_FIXED_FONT);
		hDC = GetDC(hWnd);	/* get device context */
  		hOldFont   = SelectObject ( hDC, hFixedFont);
		GetTextMetrics(hDC, &tm);
		ReleaseDC(hWnd, hDC);
		xchar = tm.tmAveCharWidth;
		ychar = tm.tmHeight + tm.tmExternalLeading; 
		wButtonWidth = BUTTON_CHARS* xchar;

		hWndHeaderLine1 = CreateWindow("static", "Header Line1",
				WS_CHILD|WS_VISIBLE|SS_LEFT,
				0, 0,
				sizeof("Header Line2"), ychar,
				hWnd, IDM_HEADER_LINE1,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		SendMessage(hWndHeaderLine1,  WM_SETFONT,  hFixedFont , TRUE);

		hWndHeaderLine2 = CreateWindow("static", "Header Line2",
				WS_CHILD|WS_VISIBLE|SS_LEFT,
				0, ychar,
				sizeof("Header Line2"), ychar,
				hWnd, IDM_HEADER_LINE1,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		SendMessage(hWndHeaderLine2,  WM_SETFONT,  hFixedFont , TRUE);

		hWndList = CreateWindow("listbox", NULL,
				WS_CHILD|WS_VISIBLE| LBS_NOTIFY | WS_VSCROLL| WS_BORDER|
				LBS_EXTENDEDSEL,
				0, 2*ychar,
				40*xchar, 16*ychar,
				hWnd, IDM_LISTBOX,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		MAKE_TABSTOP_TABLE_ENTRY(hWndList, IDM_LISTBOX);
		SendMessage(hWndList,  WM_SETFONT,  hFixedFont , FALSE);
		ShowWindow(hWndList, SW_SHOW);
		UpdateWindow(hWndList);			/* show it now!				*/

		hWndTotalLine1 = CreateWindow("static", "",
				WS_CHILD|WS_VISIBLE|SS_LEFT,
				0, 19*ychar,
				0, ychar,
				hWnd, IDM_TOTAL_LINE1,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		SendMessage(hWndTotalLine1,  WM_SETFONT,  hFixedFont , TRUE);

		hWndTotalLine2 = CreateWindow("static", "",
				WS_CHILD|WS_VISIBLE|SS_LEFT,
				0, 20*ychar,
				0, ychar,
				hWnd, IDM_TOTAL_LINE2,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		SendMessage(hWndTotalLine2,  WM_SETFONT,  hFixedFont , TRUE);

		hWndStatus = CreateWindow(szStatusClass, "Messages",
				WS_CHILD|WS_SYSMENU|WS_VISIBLE|WS_BORDER|WS_HSCROLL|WS_VSCROLL|WS_MAXIMIZEBOX|WS_CAPTION,
				0, 21*ychar,
				0, STATUS_ROWS * ychar,
				hWnd, IDM_STATUS,
				GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
		SendMessage(hWndStatus,  WM_SETFONT,  hFixedFont , TRUE);
		MAKE_TABSTOP_TABLE_ENTRY(hWndStatus, IDM_STATUS);


		hExtract = CreateWindow("button", "E&xtract",  
					WS_CHILD | BS_PUSHBUTTON,
					0,	  
					ychar * BUTTONS_ROW,
					BUTTON_CHARS * xchar,   2 * ychar,
					hWnd, IDM_EXTRACT,
					hInst,
					NULL);
		ShowWindow(hExtract, SW_SHOW);
		MAKE_TABSTOP_TABLE_ENTRY(hExtract, IDM_EXTRACT);


		hDisplay= CreateWindow("button", "&Display",  					
					WS_CHILD | BS_PUSHBUTTON,
					0,	  
					ychar * BUTTONS_ROW,
					BUTTON_CHARS * xchar,   2 * ychar,
					hWnd, IDM_DISPLAY,
					hInst,
					NULL);
		ShowWindow(hDisplay, SW_SHOW);
		MAKE_TABSTOP_TABLE_ENTRY(hDisplay, IDM_DISPLAY);

		hTest= CreateWindow("button", "&Test",  		
					WS_CHILD | BS_PUSHBUTTON,
					0,	  
					ychar  * BUTTONS_ROW,
					BUTTON_CHARS * xchar,   2 * ychar,
					hWnd, IDM_TEST,
					hInst,
					NULL);
		ShowWindow(hTest, SW_SHOW);
		MAKE_TABSTOP_TABLE_ENTRY(hTest, IDM_TEST);
	

		hShowComment= CreateWindow("button", "&Show Comment",  WS_CHILD  |
					BS_PUSHBUTTON,
					0,	  
					ychar  * BUTTONS_ROW,
					BUTTON_CHARS * xchar,   2 * ychar,
					hWnd, IDM_SHOW_COMMENT,
					hInst,
					NULL);
		ShowWindow(hShowComment, SW_SHOW);
		MAKE_TABSTOP_TABLE_ENTRY(hShowComment, IDM_SHOW_COMMENT);

		if (szFileName[0])		/* if file spec'd on entry */
		{
		char *pC;
		extern int ofretval; /* return value from initial open if filename given
								during WinMain()				 */


			OemToAnsi(szFileName, szBuffer); /* translate to ANSI */
			/* If valid filename change dir to where it lives	*/
 			if (ofretval >= 0)
			{
				if ((pC = strrchr(szBuffer, '\\')) ||
	   				 (pC = strrchr(szBuffer, ':')))
					*pC = '\0'; /* take only path portion		*/

				strcpy(szOrigDirName, szBuffer);	/* save current dir	*/
				DlgDirList(hWnd, szBuffer, 0, 0, 0);
			}
			else /* bad file name	*/
			{
				if ((pC = strrchr(szBuffer, '\\')) ||
	   				 (pC = strrchr(szBuffer, ':')))
					pC++;	/* point to filename				*/

				else
					pC = szBuffer;
	
				wsprintf (szBuffer, "Cannot open %s", (LPSTR)pC);
                MessageBox (hWnd, szBuffer, szAppName, MB_ICONINFORMATION | MB_OK);
				szFileName[0] = '\0'; /* pretend filename doesn't exist	*/

			}
		}
		DoCaption(hWnd, szFileName);	/* put name in title bar	*/
		UpdateListBox(hWnd); /* fill in list box */
		UpdateButtons(hWnd);		/* update state of buttons	*/
		SizeWindow(hWnd, TRUE);	/* move things around as necessary	*/

		break;
	case WM_SETFOCUS:	/* hand off focus to child window		*/
		if (bStatusMaxed)	/* if message window is max'd		*/
			SetFocus(hWndStatus); /* pass focus to Messages Window	*/

		else	/* list box gets it								*/
			SetFocus(hWndList); /* pass focus to list box			*/

		break;
	case WM_ACTIVATE:				/* getting focus, max'ing, min'ing */
		DoCaption(hWnd, szFileName);	/* put name in title bar	*/
		return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_SIZE:  /* resize text and listbox to fix new window */
		SizeWindow(hWnd, FALSE);	/* move things around as necessary	*/
		break;
	case WM_CTLCOLOR: /* color background of buttons and statics */
		if (HIWORD(lParam) == CTLCOLOR_STATIC)
		{
			SetBkMode(wParam, TRANSPARENT);
			SetBkColor(wParam, GetSysColor(BG_SYS_COLOR)); /* custom b.g. color */
			SetTextColor(wParam, GetSysColor(COLOR_WINDOWTEXT));
			UnrealizeObject(hBrush);
			point.x = point.y = 0;
			ClientToScreen(hWnd, &point);
			SetBrushOrg(wParam, point.x, point.y);
			return((DWORD)hBrush);
		}
		else
			return DefWindowProc(hWnd, message, wParam, lParam);

		break;
	case WM_SYSCOMMAND:
		/* process sub-message */
		switch( wParam )
			{
		default :
			return(DefWindowProc( hWnd, message, wParam, lParam ));
			break;
		}		
		break;
	case WM_COMMAND:
           /* Was F1 just pressed in a menu, or are we in help mode */
           /* (Shift-F1)? */

           if (bHelp) {
               dwHelpContextId =
                   (wParam == IDM_OPEN)   ? (DWORD) HELPID_OPEN    :
                   (wParam == IDM_EXIT)   ? (DWORD) HELPID_EXIT_CMD    :
                   (wParam == IDM_CHDIR)   ? (DWORD) HELPID_CHDIR    :
                   (wParam == IDM_SHORT)   ? (DWORD) HELPID_SHORT    :
                   (wParam == IDM_LONG)    ? (DWORD) HELPID_LONG     :
                   (wParam == IDM_HELP)  ? (DWORD) HELPID_HELP   :
                   (wParam == IDM_HELP_HELP)  ? (DWORD) HELPID_HELP_HELP   :
                   (wParam == IDM_ABOUT)   ? (DWORD) HELPID_ABOUT    :
                   (wParam == IDM_RECR_DIR_STRUCT)   ? (DWORD) HELPID_RECR_DIR_STRUCT :
                   (wParam == IDM_OVERWRITE)   ? (DWORD) HELPID_OVERWRITE :
                   (wParam == IDM_TRANSLATE)   ? (DWORD) HELPID_TRANSLATE :
                   (wParam == IDM_UNZIP_TO_ZIP_DIR)   ? (DWORD) HELPID_UNZIP_TO_ZIP_DIR :
                   (wParam == IDM_LISTBOX)   ? (DWORD) HELPID_LISTBOX :
                   (wParam == IDM_EXTRACT)   ? (DWORD) HELPID_EXTRACT :
                   (wParam == IDM_DISPLAY)   ? (DWORD) HELPID_DISPLAY :
                   (wParam == IDM_TEST)   ? (DWORD) HELPID_TEST :
                   (wParam == IDM_SHOW_COMMENT)   ? (DWORD) HELPID_SHOW_COMMENT :
                   (wParam == IDM_LB_EXTRACT)   ? (DWORD) HELPID_LB_EXTRACT :
                   (wParam == IDM_LB_DISPLAY)   ? (DWORD) HELPID_LB_DISPLAY :
                   (wParam == IDM_LB_TEST)   ? (DWORD) HELPID_LB_TEST :
                   (wParam == IDM_DESELECT_ALL)   ? (DWORD) HELPID_DESELECT_ALL :
                   (wParam == IDM_SELECT_ALL)   ? (DWORD) HELPID_SELECT_ALL :
                   (wParam == IDM_CLEAR_STATUS)   ? (DWORD) HELPID_CLEAR_STATUS :
                                                           (DWORD) 0L;

               if (!dwHelpContextId)
	       {
                   MessageBox( hWnd, "Help not available for Help Menu item",
			       "Help Example", MB_OK                          );
                   return (DefWindowProc(hWnd, message, wParam, lParam));
	       }

               bHelp = FALSE;
               WinHelp(hWnd,szHelpFileName,HELP_CONTEXT,dwHelpContextId);
        }
		else /* not in help mode									*/
		{
	    switch (wParam) {
		case IDM_OPEN:
			/* If unzipping separately and previous file exists,
			 * go to directory where archive lives.
			 */
			if (!bUnzipToZipDir && szFileName[0])
			{
				PSTR lastchar;

				OemToAnsi(szFileName, szBuffer); /* get scratch copy */
				/* strip off filename to make directory name	*/
				if ((lastchar = strrchr(szBuffer, '\\')) ||
					(lastchar = strrchr(szBuffer, ':')))
						*lastchar = '\0';

                DlgDirList (hWnd, szBuffer, 0, 0, 0); /* change dir */
			}
            lpProcFileDlg = MakeProcInstance(FileDlgProc, hInst);
            FileDlgRetVal = 
                        DialogBox(hInst, "FileDlg", hWnd, lpProcFileDlg);
            FreeProcInstance(lpProcFileDlg);
			if (FileDlgRetVal)	/* if successful file open			*/
			{
				/* If directory follows .ZIP or 1st open			*/
				if (bUnzipToZipDir || !szOrigDirName[0])
				{
				PSTR lastchar;

					/* strip off filename to make directory name	*/
					OemToAnsi(szFileName, szOrigDirName);
					if ((lastchar = strrchr(szOrigDirName, '\\')) ||
					    (lastchar = strrchr(szOrigDirName, ':')))
						*lastchar = '\0';

				}
				UpdateListBox(hWnd); 		/* fill in list box */
				UpdateButtons(hWnd);		/* update state of buttons	*/
			}
			if (szOrigDirName[0]) /* if directory name exists, go there	*/
			{
				strcpy(szBuffer, szOrigDirName); /* get scratch copy */
                DlgDirList (hWnd, szBuffer, 0, 0, 0); /* change dir */
			}
			DoCaption(hWnd, szFileName);
		    break;
		case IDM_CHDIR:
            lpProcChDir = MakeProcInstance(ChDirProc, hInst);
			(void)DialogBox(hInst, "ChDirDlg", hWnd, lpProcChDir);
            FreeProcInstance(lpProcChDir);
		    break;

		case IDM_EXIT:
			SendMessage(hWnd, WM_CLOSE, 0, 0L);
           			 break;

		case IDM_HELP:	/* Display Help							*/
            WinHelp(hWnd,szHelpFileName,HELP_INDEX,0L);

			break;
        case IDM_HELP_HELP:
		   WinHelp(hWnd,"WINHELP.HLP",HELP_INDEX,0L);
                   break;
		case IDM_ABOUT:
		    lpProcAbout = MakeProcInstance(About, hInst);
		    DialogBox(hInst, "About", hWnd, lpProcAbout);
		    FreeProcInstance(lpProcAbout);
		    break;
	    case IDM_LISTBOX:		/* command from listbox		*/
			if (TotalZippedFiles)			/* if any entries	*/
			{
				switch (HIWORD(lParam)) {
				case LBN_SELCHANGE:
					UpdateButtons(hWnd);
					break;
				case LBN_DBLCLK: /* double click action */
					UpdateButtons(hWnd);
					Action(wLBSelection - IDM_LB_EXTRACT); 	/* do action	*/
					break;
				}
			}
			break;
		case IDM_LONG:	/* long version							*/
		case IDM_SHORT:	/* short version						*/
			{ 
				WORD wFormatTmp = wParam - IDM_SHORT;
				int *pnSelItems;			/* pointer to list of selected items	*/
				int	nSelCount ;				/* no. selected items in listbox */


				/* If format change, uncheck old, check new.
				 */
				if (wFormatTmp != wFormat)	/* if format change		*/
				{
					nSelCount = GetLBSelCount(hWndList, &pnSelItems);
					CheckMenuItem(hMenu, (IDM_SHORT+wFormat), MF_BYCOMMAND|MF_UNCHECKED);
					CheckMenuItem(hMenu, (IDM_SHORT+wFormatTmp), MF_BYCOMMAND|MF_CHECKED);
					wFormat = wFormatTmp;
					UpdateListBox(hWnd); /* fill list box				*/
					SizeWindow(hWnd, TRUE);	/* move things around as necessary	*/
					WriteProfileString(szAppName, FORMAT_KEY, 
										(LPSTR)(FormatKeyword[wFormat]));
					if (nSelCount > 0)	/* anything previously selected ? */
					{
						ReselectLB(hWndList, nSelCount, pnSelItems);
    					pnSelItems = (int *)LocalFree((HANDLE)pnSelItems); /* free it to Windows */
						assert(!pnSelItems);	/* DEBUG */
					}
					UpdateButtons(hWnd); /* enable or disable buttons */
				}
			}
			break;
        case IDM_OVERWRITE:
			{ 
 
				/* Toggle value of overwrite flag.
				 */
				bOverwrite = !bOverwrite;
				CheckMenuItem(hMenu,IDM_OVERWRITE,MF_BYCOMMAND|
								(WORD)(bOverwrite ? MF_CHECKED: MF_UNCHECKED));
				WriteProfileString(szAppName, OVERWRITE_KEY, 
						(LPSTR)(bOverwrite ? "yes" : "no" ));
			}
			break;
        case IDM_TRANSLATE:
			{ 
 
				/* Toggle value of translate flag.
				 */
				bTranslate = !bTranslate;
				CheckMenuItem(hMenu,IDM_TRANSLATE,MF_BYCOMMAND|
								(WORD)(bTranslate ? MF_CHECKED: MF_UNCHECKED));
				WriteProfileString(szAppName, TRANSLATE_KEY, 
						(LPSTR)(bTranslate ? "yes" : "no" ));
			}
			break;
		case IDM_UNZIP_TO_ZIP_DIR: /* toggle value of Unzip to .ZIP  */
			bUnzipToZipDir = !bUnzipToZipDir;
			CheckMenuItem(hMenu,IDM_UNZIP_TO_ZIP_DIR,MF_BYCOMMAND|
								(WORD)(bUnzipToZipDir ? MF_CHECKED:MF_UNCHECKED));
			EnableMenuItem(hMenu,IDM_CHDIR,MF_BYCOMMAND|
								(WORD)(bUnzipToZipDir ? MF_GRAYED:MF_ENABLED));
			WriteProfileString(szAppName, UNZIP_TO_ZIP_DIR_KEY, 
						(LPSTR)(bUnzipToZipDir ? "yes" : "no" ));

			if (bUnzipToZipDir && szFileName[0])
			{
				PSTR lastchar;

				/* strip off filename to make directory name	*/
				OemToAnsi(szFileName, szOrigDirName);
				if ((lastchar = strrchr(szOrigDirName, '\\')) ||
					(lastchar = strrchr(szOrigDirName, ':')))
					*lastchar = '\0';

				if (szOrigDirName[0]) /* if directory name exists, go there	*/
				{
					strcpy(szBuffer, szOrigDirName); /* get scratch copy */
               		DlgDirList (hWnd, szBuffer, 0, 0, 0); /* change dir */
				}
				DoCaption(hWnd, szFileName);
			}
			break;
		case IDM_LB_EXTRACT:
		case IDM_LB_DISPLAY:
		case IDM_LB_TEST:
			{ 
				WORD wLBSelectionTmp = wParam; 
 
				/* If overwrite change, uncheck old, check new.
				 */
				if (wLBSelectionTmp != wLBSelection)	/* if format change		*/
				{

					CheckMenuItem(hMenu,wLBSelection,MF_BYCOMMAND|MF_UNCHECKED);

					CheckMenuItem(hMenu,wLBSelectionTmp,MF_BYCOMMAND|MF_CHECKED);

					wLBSelection = wLBSelectionTmp;
					WriteProfileString(szAppName, LBSELECTION_KEY, 
						(LPSTR)(LBSelectionTable[wParam - IDM_LB_EXTRACT]));
				}
			}
			break;
		case IDM_SHOW_COMMENT:	/* display the archive comment in mesg window */
			DisplayComment();
			break;
		case IDM_RECR_DIR_STRUCT:	/* re-create directories structure */
			bRecreateDirs = !bRecreateDirs;	/* toggle state			*/
			CheckMenuItem(hMenu, IDM_RECR_DIR_STRUCT, 
			 MF_BYCOMMAND| (WORD)(bRecreateDirs ? MF_CHECKED : MF_UNCHECKED));
			WriteProfileString(szAppName, RECREATE_DIRS_KEY, 
								(LPSTR)(bRecreateDirs ? "yes" : "no"));
			break;
		case IDM_DISPLAY:
		case IDM_TEST:
		case IDM_EXTRACT:
			Action(wParam - IDM_EXTRACT);	/* Action() does it all	*/
			break;
		case IDM_SELECT_ALL:
		case IDM_DESELECT_ALL:
			{

				if (TotalZippedFiles) /* total listbox entries			*/
				{
					SendMessage(hWndList , LB_SELITEMRANGE, 
							(WORD)(wParam == IDM_DESELECT_ALL ? FALSE : TRUE),
								MAKELONG(0, (TotalZippedFiles-1)));
					UpdateButtons(hWnd); /* enable or disable buttons */
				}
			}
			break;
		case IDM_CLEAR_STATUS:	/* forward to status window			*/
			PostMessage(hWndStatus, WM_COMMAND, IDM_CLEAR_STATUS, 0L);
			break;
		case IDM_MAX_STATUS:	/* status windows went to the max	*/
		case IDM_RESTORE_STATUS:	/* status windows restored	*/
			/* This logic is used for maximizing the message window.
			 * It will either hide all other windows allowing the
			 * message window to grow, or it will show them,
			 * allowing the message box to resume its normal size.
			 * These two messages come from the Message window proc.
			 */
			{
			int nWndState;	/* ShowWindow state		*/
			BOOL bWndEnabled;	/* Enable Window state */
				
				if (wParam == IDM_RESTORE_STATUS)
				{
					ShowWindow(hWndStatus, SW_RESTORE);
					UpdateWindow(hWndStatus);
					bStatusMaxed = FALSE;
					bWndEnabled = TRUE;
					nWndState = SW_SHOWNORMAL;
				}
				else	/* Message window goes to maximum state		*/
				{
					bStatusMaxed = TRUE;
					nWndState = SW_HIDE;	/* assume max state		*/
					bWndEnabled = FALSE;
				}
				EnableWindow( hWndHeaderLine1, bWndEnabled);
				UpdateWindow( hWndHeaderLine1);
				ShowWindow( hWndHeaderLine1, nWndState);

				EnableWindow( hWndHeaderLine2, bWndEnabled);
				ShowWindow( hWndHeaderLine2, nWndState);
				UpdateWindow( hWndHeaderLine2);

				EnableWindow( hWndList, bWndEnabled);
				UpdateWindow( hWndList);
				ShowWindow( hWndList, nWndState);

				EnableWindow( hWndTotalLine1, bWndEnabled);
				ShowWindow( hWndTotalLine1, nWndState);
				UpdateWindow( hWndTotalLine1);

				EnableWindow( hWndTotalLine2, bWndEnabled);
				ShowWindow( hWndTotalLine2, nWndState);
				UpdateWindow( hWndTotalLine2);

				if (wParam == IDM_RESTORE_STATUS) /* uncover buttons	*/
				{
					UpdateButtons(hWnd);	/* restore to proper state	*/
				}
				else	/* else Message window occludes buttons			*/
				{
					EnableWindow( hExtract, bWndEnabled);
					EnableWindow( hTest, bWndEnabled);
					EnableWindow( hDisplay, bWndEnabled);
					EnableWindow( hShowComment, bWndEnabled);
				}
				UpdateWindow( hExtract);
				ShowWindow( hExtract, nWndState);

				ShowWindow( hTest, nWndState);
				UpdateWindow( hTest);

				ShowWindow( hDisplay, nWndState);
				UpdateWindow( hDisplay);

				ShowWindow( hShowComment, nWndState);
				UpdateWindow( hShowComment);

				if (wParam == IDM_MAX_STATUS)	/* message box max'd out */
				{
					ShowWindow(hWndStatus, SW_SHOWMAXIMIZED);
				}
				SetFocus(hWndStatus); /* pass focus to Messages Window	*/
				SizeWindow(hWnd, FALSE);
			}
			break;

		default:
			    return DefWindowProc(hWnd, message, wParam, lParam);


			break;
		      }
			} /* bottom of not in help mode								*/
	       break;
       case WM_SETCURSOR:
           /* In help mode it is necessary to reset the cursor in response */
           /* to every WM_SETCURSOR message.Otherwise, by default, Windows */
           /* will reset the cursor to that of the window class. */

           if (bHelp) {
               SetCursor(hHelpCursor);
               break;
           }
           return (DefWindowProc(hWnd, message, wParam, lParam));
           break;

       case WM_INITMENU:
           if (bHelp) {
               SetCursor(hHelpCursor);
           } 
           return (TRUE);

       case WM_ENTERIDLE:
           if ((wParam == MSGF_MENU) && (GetKeyState(VK_F1) & 0x8000)) {
               bHelp = TRUE;
               PostMessage(hWnd, WM_KEYDOWN, VK_RETURN, 0L);
           }
           break;

	case WM_CLOSE:			     /* message: close the window    */
		DestroyWindow(hWnd);

	    break;

	case WM_DESTROY:		     /* message: destroy the window  */
	    DeleteObject(hBrush);	     /* delete background brush	*/
        WinHelp(hWnd,szHelpFileName,HELP_QUIT,0L);
	    PostQuitMessage(NULL);
	    break;

	default:
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}
