// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1992.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
#include "windows.h"
#include "mem.h"

/****************************************************************************
    MODULE:  memory3.c

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

    MESSAGES:

	WM_COMMAND    - application menu (About dialog box)
	WM_DESTROY    - destroy window

****************************************************************************/


long FAR PASCAL MainWndProc (hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
   FARPROC lpProcAbout;

   switch (message)
      {
   case WM_COMMAND:
      if (wParam == IDM_ABOUT)
      {
         lpProcAbout = MakeProcInstance(About, hInst);
         DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
         FreeProcInstance(lpProcAbout);
         break;
      }
      else
         return (DefWindowProc(hWnd, message, wParam, lParam));

   case WM_DESTROY:
      PostQuitMessage(0);
      break;

   default:
      return (DefWindowProc(hWnd, message, wParam, lParam));
      }
   return (NULL);
}
