#include "statbar.h"

// Globals

HINSTANCE   g_hinst	= NULL;
HINSTANCE   g_hinstPrev = NULL;
LPCSTR	    g_lpCmdLine = NULL;
int	    g_nCmdShow	= 0;
HMODULE     g_hmod	= NULL;
HTASK	    g_htask	= NULL;

HWND	    g_hwndFrame = NULL;

//===========================================================================

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
        LPSTR lpCmdLine, int nCmdShow)
{
    int code;

    g_hinst	= hInstance;
    g_hinstPrev = hPrevInstance;
    g_lpCmdLine = lpCmdLine;
    g_nCmdShow	= nCmdShow;

    g_hmod	= GetInstanceModule(g_hinst);
    g_htask	= GetCurrentTask();

    if (!App_Initialize())
	return 1;

    code = App_Main();

    return code;
}

BOOL App_Initialize(void)
{
    if (!StatBar_Register(g_hinst))
	return FALSE;

    g_hwndFrame = CreateWindowEx(
	    0L, 			    // extendedStyle
	    "StatBar",			    // class name
	    "StatBar Application", 	    // text
	    WS_OVERLAPPEDWINDOW,	    // style
	    CW_USEDEFAULT, CW_USEDEFAULT,   // x, y
	    CW_USEDEFAULT, CW_USEDEFAULT,   // cx, cy
	    NULL,			    // hwndParent
	    NULL,			    // hmenu
	    g_hinst,			    // hInstance
	    NULL);			    // lpParam

    if (g_hwndFrame == NULL)
	return FALSE;

    InitStatBar();

    ShowWindow(g_hwndFrame, g_nCmdShow);


    return TRUE;
}

int App_Main(void)
{
    MSG msg;

    while (GetMessage(&msg, NULL, 0, 0))
    {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return (int)msg.wParam;
}
