/*
    appexec.h

    Header file 

*/

#include <windows.h>
#include <commdlg.h>
#include <dlgs.h>
#include <stdlib.h>
#include <string.h>

//
// Menu ids
//

#define IDM_EXIT        100
#define IDM_WAIT        200

//
// Child windows 
//

#define IDC_EDIT        1
#define IDC_OK          2

//
// return values for ExecApp
//

#define RAN_OK          1
#define NOT_FOUND       2
#define INVALID_NAME    3
#define SOME_ERROR      4

//
// Define a structure usewd to hold info about an app we
// start with ExecApp so that this info can be used again
// later to test if the app is still running
//

typedef struct _EXECAPPINFO {
    HINSTANCE hInstance;            // The instance value
    HWND hWnd;                      // The main window handle
    HTASK hTask;                    // The task handle
} EXECAPPINFO, FAR *LPEXECAPPINFO;

//
// in appexec.c
//

extern HINSTANCE ghInstance;
extern HWND ghwndMain;

//
// in exec.c
//

extern UINT ExecApp(HWND hwndParent,
                    LPSTR pszName,
                    LPSTR pszParams,
                    LPEXECAPPINFO pInfo);

extern BOOL IsAppRunning(LPEXECAPPINFO pInfo);
