/***    DRVINFO.H - Definitions for IsDoubleSpaceDrive
 *
 *      Version 1.00.58  12-Mar-1993
 */

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef BYTE
typedef unsigned char BYTE;
#endif

#ifndef WORD
typedef unsigned short WORD;    // 2 bytes
#endif

#ifndef DWORD
typedef unsigned long  DWORD;   // 4 bytes
#endif




/** FDOP - FlushDrive operations
 *
 *  These are additional operations that can be performed by FlushDrive.
 */
typedef int FDOP;   /* fdop */
#define FDOP_INVALIDATE 0x01            // Flush and *invalidate*
#define FDOP_DISK_RESET 0x02            // Perform disk reset

BOOL FlushDrive(int drive, FDOP fdop);

BOOL IsDoubleSpaceDrive(BYTE drive, BOOL *pfSwapped, BYTE *pdrHost, int *pseq);
