;***    IOCTL.ASM - Demonstrate DoubleSpace System API IOCtl calls
;
;       This code calls DBLSPACE.BIN to flush, and then flush and
;       invalidate, its internal caches for drive C.
;
;       Version 1.00.02  15-Mar-1993


MD_STAMP    EQU     'DM'


;***    DSPACKET - Packet for IOCtl read call to DBLSPACE.BIN
;
;
dspacket    STRUC
dspStamp    DW      ?           ; Identifying stamp ('DM')
dspCommand  DB      ?           ; Command (F or I)
dspResult   DW      ?           ; Result code ('OK' if OK, else unchanged)
dspPadding  DB      5 DUP (?)   ; Padding
dspacket    ENDS


stack   SEGMENT STACK
        DW  500 DUP (?)
stack   ENDS


data    SEGMENT

dsp     dspacket <MD_STAMP>

msgFF   db  'FLUSH call failed',0Dh,0Ah,'$'
msgFS   db  'FLUSH call succeeded',0Dh,0Ah,'$'
msgIF   db  'INVALIDATE call failed',0Dh,0Ah,'$'
msgIS   db  'INVALIDATE call succeeded',0Dh,0Ah,'$'

data    ENDS


code    SEGMENT
    ASSUME  CS:code

main    PROC

        MOV     AX,data
        MOV     DS,AX
    ASSUME  DS:data

;*  Do Flush request

        MOV     AX,4404h            ; IOCtl read command
        MOV     BL,3                ; drive C (1-based!)
        MOV     CX,SIZE dspacket    ; buffer length
        MOV     DX,OFFSET dsp       ; IOCTL packet
        MOV     dsp.dspCommand,'F'  ; Flush command
        MOV     dsp.dspResult,'??'  ; clear success indicator
        INT     21h
        MOV     DX,OFFSET msgFF     ; Assume failure
        CMP     dsp.dspResult,'OK'  ; Test for success
        JNE     ds10                ; Call failed

        MOV     DX,OFFSET msgFS     ; Success

ds10:   MOV     AH,9                ; Print string
        INT     21h

;*  Do Invalidate request

        MOV     AX,4404h            ; IOCtl read command
        MOV     BL,3                ; drive letter (1-based!)
        MOV     CX,SIZE dspacket    ; buffer length
        MOV     DX,OFFSET dsp       ; IOCTL packet
        MOV     dsp.dspCommand,'I'  ; Flush command
        MOV     dsp.dspResult,'??'  ; clear success indicator
        INT     21h
        MOV     DX,OFFSET msgIF     ; Assume failure
        CMP     dsp.dspResult,'OK'  ; Test for success
        JNE     ds20                ; Call failed

        MOV     DX,OFFSET msgIS     ; Success

ds20:   MOV     AH,9                ; Print string
        INT     21h

;*  Return to MS-DOS

        MOV     AX,4C00h
        INT     21h

main    ENDP

code    ENDS

        END     main
