; 286386.asm:
;
;     (C) Copyright Microsoft Corp. 1991.  All rights reserved.
;
;     You have a royalty-free right to use, modify, reproduce and 
;     distribute the Sample Files (and/or any modified version) in 
;     any way you find useful, provided that you agree that 
;     Microsoft has no warranty obligations or liability for any 
;     Sample Application Files which are modified. 
;
; masm -Mx -Zi -DSEGNAME=????? <file>.asm
;

;****************************************************************
;* 286386.ASM - Assembly showing examples of routines		*
;*		for 80286 and 80386				*
;****************************************************************
;

?PLM=1	    ; PASCAL Calling convention is DEFAULT
?WIN=1	    ; Windows calling convention
?386=0	    ; Use 386 code?

.xlist
include cmacros.inc
include windows.inc
.list

	externA	    __WinFlags	    ; in KERNEL
	externA	    __AHINCR	    ; in KERNEL
	externA	    __AHSHIFT	    ; in KERNEL

; The following structure should be used to access high and low
; words of a DWORD.  This means that "word ptr foo[2]" -> "foo.hi".

LONG	struc
lo	dw	?
hi	dw	?
LONG	ends

FARPOINTER	struc
off	dw	?
sel	dw	?
FARPOINTER	ends

; -------------------------------------------------------
;		DATA SEGMENT DECLARATIONS
; -------------------------------------------------------

ifndef SEGNAME
    SEGNAME equ <_TEXT>
endif

createSeg %SEGNAME, CodeSeg, word, public, CODE

sBegin Data
sEnd Data

sBegin CodeSeg
assumes cs,CodeSeg
assumes ds,DATA

;---------------------------Public-Routine------------------------------;
; doit
;
;   no-op routine to demonstrate 286/386 code
;
; Entry:
;	LPSTR lpBuf;
;	char  ch;
;
; Returns:
;	nothing
; Error Returns:
;	None
; Registers Preserved:
;	BP,DS,SI,DI
; Registers Destroyed:
;	AX,BX,CX,DX,FLAGS
; Calls:
;	doit286 or doit386
;-----------------------------------------------------------------------;

cProc doit,<FAR,PUBLIC,NODATA>,<>
;	 ParmD	 lpBuf
;	 ParmB	 ch
; don't generate parameter info or modify stack frame
cBegin	<nogen>
	mov	ax,__WinFlags
	test	ax,WF_CPU286
	jnz	doit286
	errn$	doit386		; assumes 386 routine is next (for speed)

; don't clean up frame 'cause it doesn't need it
cEnd <nogen>

;-------------------------------------------------------------------------

cProc doit386,<FAR,PUBLIC,NODATA>,<>
	 ParmD	 lpBuf
	 ParmB	 ch
; can also put locals here..  see cmacros documentation

; generate stack frame
cBegin

; don't turn .386 on until AFTER cBegin
	.386

; now we can work with the 386 registers

	; for example...
	push	edi

;... code goes here

mf386_exit:
	pop	edi

; turn off .386 BEFORE cEnd
	.286

; cleans up stack frame and returns
cEnd

; still in 286 mode...

;-------------------------------------------------------------------------
cProc doit286,<FAR,PUBLIC,NODATA>,<di>
	 ParmD	 lpBuf
	 ParmB	 ch
cBegin
; we are limited to 286 registers and instructions

mf_exit:

;... code goes here


; cleans up stack frame and returns
cEnd

sEnd

sEnd CodeSeg
end
