;     (C) Copyright Microsoft Corp. 1991.  All rights reserved.
;
;     You have a royalty-free right to use, modify, reproduce and 
;     distribute the Sample Files (and/or any modified version) in 
;     any way you find useful, provided that you agree that 
;     Microsoft has no warranty obligations or liability for any 
;     Sample Application Files which are modified. 


?PLM = 1                ;PASCAL calling Convention
?WIN = 1                ;windows prolog/epilog
WIN3 = 1		; we are compiling for windows

.286

.xlist
include cmacros.inc
include int31.inc
include windows.inc
.list

Int31_SelMgt_Seg_To_Sel   EQU ((Int31_Sel_Mgt shl 8) + SelMgt_Seg_To_Sel   )
Int31_Trans_Sim_Int       EQU ((Int31_Trans_Serv shl 8) + Trans_Sim_Int )
Int31_Trans_Far_Call      EQU ((Int31_Trans_Serv shl 8) + Trans_Far_Call)

IOCTL_READ      =       3       ; IOCTL read
IOCTL_WRITE     =       12      ; IOCTL write

wp equ <WORD PTR>

reqhdr  struc
    rqh_len         db ?
    rqh_unit        db ?
    rqh_cmd         db ?
    rqh_status      dw ?
    rqh_rsvd        db 8 dup(?)
reqhdr  ends

ioctlhdr  struc
    ioctl_rqh       db  (size reqhdr) dup(?)
    ioctl_media     db  ?
    ioctl_xfer      dd  ?
    ioctl_nbytes    dw  ?
    ioctl_sector    dw  ?
    ioctl_volid     dd  ?
ioctlhdr  ends

long struc
    lo	dw  ?
    hi	dw  ?
long ends

hilo struc
    lb	db ?
    hb	db ?
hilo ends

seloff struc
    off  dw ?
    sel  dw ?
seloff ends

ifndef SEGNAME
    SEGNAME equ <_TEXT>
endif

createSeg %SEGNAME, CodeSeg, word, public, CODE

;----------------------------------------------------------------------;
;
;   There are many posible ways we can send a request header to a
;   device driver.
;
;   req_mode will contain one of the following values:
;
;       REQ_NULL            - nothing, fail the request.
;       REQ_MSCDEX          - send request by calling MSCDEX
;       REQ_RMODE           - Running in Real mode
;       REQ_PMODE           - Running in Protected mode
;
;----------------------------------------------------------------------;
REQ_NULL    equ     0
REQ_MSCDEX  equ     1
REQ_RMODE   equ     4
REQ_PMODE   equ     8

ifdef WIN3
    externFP    <GlobalDOSAlloc>
    externFP    <GlobalDOSFree>
    externFP    <GlobalReAlloc>
endif; WIN3

;
; size of buffer allocated in DOS memory space for the request buffer
; and posibly a real mode stack.
;
REQ_MAXBUF  equ     128

sBegin data
        staticW     req_mode,REQ_NULL

        ;
        ;   Stuff for PMODE operation
        ;
        staticW     buf_sel, 0          ; Selector of tmp DOS buffer
        staticW     buf_seg, 0          ; Segment of tmp DOS buffer
        staticW     buf_off, 0          ; Offset of tmp DOS buffer

ifndef WIN3
        req_buf     db      REQ_MAXBUF dup (0)
endif; WIN3

sEnd data

sBegin CodeSeg
        assumes cs,CodeSeg
        assumes ds,DATA
        assumes es,nothing

;----------------------------------------------------------------------;
; initMSCDEX
;
;   returns number of MSCDEX drives
;
;----------------------------------------------------------------------;
cProc initMSCDEX, PUBLIC, <si,di>
        ParmD  pdrives
cBegin
        mov     ax,1500h
        mov     bx,0
        int     2fh
        mov     ax,bx
        or      ax,ax
        jz      msc_exit
        ;
        ;   AX - Number of drives
        ;   CX - first drive that is a CDROM (0=A)
        ;
        les     bx,pdrives      ; pointer to driver array
        push    ax              ; Save driver count
        cCall   is_pmode
        jz      msc_pmode
        ;
        ;   Now get list of drives
        ;
        mov     ax,150Dh
        int     2fh
        mov     req_mode,REQ_MSCDEX + REQ_RMODE
        pop     ax              ; restore driver count
        jmp     short msc_exit

msc_pmode:
        mov     req_mode,REQ_MSCDEX + REQ_PMODE
if 0
        ;
        ;   Only support 1 CD-DRIVER in PMODE!
        ;
        mov     es:[bx],cx
        pop     ax
        mov     ax,1
else
ifdef DEBUG
        ;   es must point into the RequestBuf!!!!
        mov     ax,es
        cmp     ax,buf_sel
        je      @f
        int 3
        pop     ax
        xor     ax,ax
        jz      msc_exit
@@:
endif
        mov     ax,150Dh
        mov     dx,2fh
        cCall   real_mode_int,<dx,buf_seg,buf_seg>

        pop     ax
endif

msc_exit:
cEnd

;----------------------------------------------------------------------;
; versionMSCDEX
;
;   returns the MSCDEX version number
;
;----------------------------------------------------------------------;
cProc  versionMSCDEX, PUBLIC, <>
cBegin
        mov     ax,150Ch
        mov     bx,0
        int     2fh
        mov     ax,bx
cEnd

;----------------------------------------------------------------------;
;
;   send_req(handle,req)
;
;   Send a request to a device driver.
;
;       handle          - drive id of device (0=A, ...)
;                         only used if MSCDEX is used
;       req             - far pointer to a request header.
;                         NOTE! in PMODE this address is assumed to be
;                         the address returned from AllocRequestBuf()
;
;   returns status WORD, if hibit is set ==> ERROR
;
;----------------------------------------------------------------------;
cProc  send_req, PUBLIC, <si, di>
        parmW   handle
        parmD   req
cBegin send_req
        les     bx,req              ; es:bx --> request

ifdef DEBUG
        ;   es must point into the RequestBuf!!!!
        mov     ax,es
        cmp     ax,buf_sel
        je      @f
        int 3
        jmp     sr_error
@@:
endif
        mov     ax,req_mode

        test    ax,REQ_PMODE
        jnz     sr_pmode
        test    ax,REQ_RMODE
        jnz     sr_rmode
        ;
        ;  invalid req_mode, FAIL it!
        ;
sr_error:
        mov     ax,8000h
        jmp     sr_exit

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;
;   We are in Real mode, pass the request to MSCDEX
;
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
sr_rmode:
        mov     cx,handle           ; call extentions
        mov     ax,1510h
        int     2fh
        jmp     short sr_status

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   we are in pmode
;
;   we need to have Win386 simulate the interupt
;
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
sr_pmode:
        mov     cl,es:[bx].rqh_cmd
        cmp     cl,IOCTL_READ
        je      sr_ioctl
        cmp     cl,IOCTL_WRITE
        jne     sr_not_ioctl
sr_ioctl:
        ; we need to translate the selector in the ioctl_xfer field
        ;
        mov     cx,buf_seg
        mov     es:[bx].ioctl_xfer.sel,cx

sr_not_ioctl:
        mov     cx,handle
        mov     ax,1510h
        mov     dx,2fh
        cCall   real_mode_int,<dx,buf_seg,buf_seg>

sr_pstatus:
        les     bx,req              ; es:bx --> request

sr_status:
        mov     ax,es:[bx].rqh_status

sr_exit:
cEnd send_req

;----------------------------------------------------------------------;
;
;   is_pmode()
;
;   Are we running under the Windows DOS extender?
;
;   returns
;       Z   - running in PMODE
;       NZ  - running in real? mode
;
;----------------------------------------------------------------------;
cProc  is_pmode, <NEAR>, <>
cBegin
        mov     ax,1686h
        int     2fh
        or      ax,ax
cEnd

ifdef WIN3

;----------------------------------------------------------------------;
;   AllocRequestBuf
;
;       if we are in protected mode, alloc a DOS buffer to hold the
;       driver request header's
;
;----------------------------------------------------------------------;
cProc   AllocRequestBuf, <PUBLIC>, <>
        ParmW   wBufSize
cBegin
        xor     ax,ax
        cwd
        mov     buf_off,ax
        cmp     wBufSize,REQ_MAXBUF
        jg      arb_gotmem

        ;
        ;   Ask the window kernel for DOS memory, ie below 1Mb
        ;
        mov     ax,REQ_MAXBUF
        cwd
        cCall   GlobalDOSAlloc, <dx,ax>
;
;       AX = selector
;       DX = DOS segment paragraph address (segment)

        mov     buf_seg,dx

        cmp     ax, 0
        je      arb_gotmem

; Allocate shareable to keep it around when the current task dies
        cCall   GlobalReAlloc, <ax, 0, 0, GMEM_SHARE+GMEM_MODIFY>

arb_gotmem:
        mov     buf_sel,ax

        ;
        ; return far pointer to caller, DX:AX
        ;
        mov     dx,ax
        xor     ax,ax
arb_exit:
cEnd

;----------------------------------------------------------------------;
;   FreeRequestBuf
;
;       Free buffer alloc'ed with AllocRequestBuffer
;
;----------------------------------------------------------------------;
cProc   FreeRequestBuf, <PUBLIC>, <>
cBegin
        mov     ax,buf_sel
        or      ax,ax
        jz      frb_exit
        cCall   GlobalDOSFree,<ax>
frb_exit:
        xor     ax,ax
        mov     buf_sel,ax
        mov     buf_seg,ax
cEnd

else; not WIN3

;----------------------------------------------------------------------;
;   AllocRequestBuf
;
;       alloc a DOS buffer to hold the driver request header's
;
;----------------------------------------------------------------------;
cProc   AllocRequestBuf, <PUBLIC>, <>
        ParmW   wBufSize
cBegin
        xor     ax,ax
        cwd
        cmp     wBufSize,REQ_MAXBUF
        jg      arb_exit

        lea     ax,req_buf
        mov     dx,ds
        mov     buf_off,ax
        mov     buf_sel,dx
        mov     buf_seg,dx
arb_exit:
cEnd

;----------------------------------------------------------------------;
;   FreeRequestBuf
;
;       Free buffer alloc'ed with AllocRequestBuffer
;
;----------------------------------------------------------------------;
cProc   FreeRequestBuf, <PUBLIC>, <>
cBegin
cEnd

endif; WIN3

;----------------------------------------------------------------------;
;   red2bin(red)
;----------------------------------------------------------------------;
cProc CDA_red2bin, <FAR,PUBLIC> <si,di>
        ParmD red
cBegin
        ;
        ; REDMINUTE * 75 * 60 -> si:di
        ;
        mov     bx,75*60
        sub     ah,ah
        mov     al, red.hi.lb
        mul     bx
        mov     di,ax
        mov     si,dx
        ;
        ; REDSECOND * 75 -> dx:ax
        ;
        mov     bx,75
        sub     ah,ah
        mov     al,red.lo.hb
        mul     bx
        ;
        ;add dx:ax to si:di
        ;
        add     di,ax
        adc     si,dx
        ;
        ; REDFRAME -> dx:ax
        ;
        sub     ah,ah
        sub     dx,dx
        mov     al,red.lo.lb
        ;
        ;add si:di to dx:ax
        ;
        add     ax,di
        adc     dx,si
        ;
        ; answer is in dx:ax
        ;
cEnd

;----------------------------------------------------------------------;
;bin2red(bin)
;  ((redbook) ((((bin)/((int)75*60))<<16)|
;   (((((bin)%((int)75*60))/(int)75)<<8)|
;   ((bin)%(int)75))))
;----------------------------------------------------------------------;
cProc CDA_bin2red, <FAR,PUBLIC>
        ParmD   bin
cBegin
        ;
        ;       bin/(75*60)
        ;
        mov     dx,bin.hi
        mov     ax,bin.lo
        or      dx,dx
        js      brerr
        mov     cx,75*60
        div     cx
        push    ax
        ;
        ;       bx =  (bin%(75*60))/75
        ;
        mov     ax,dx
        sub     dx,dx
        mov     cx,75
        div     cx
        mov     bx,ax
        ;
        ;       (bin%75)
        ;
        mov     dx,bin.hi
        mov     ax,bin.lo
        mov     cx,75
        div     cx
        mov     ax,dx
        mov     ah,bl
        ;
        ;       return dx:ax
        ;
        pop     dx
brexit:
cEnd
brerr:
        xor     ax,ax
        cwd
        jz      brexit

;----------------------------------------------------------------------;
;
;   real_mode_int
;
;----------------------------------------------------------------------;
cProc  real_mode_int, <NEAR>, <>
        ParmW   real_int
        ParmW   real_ds
        ParmW   real_es
        LocalV  real_mode_regs, %(size Real_Mode_Call_Struc)
cBegin
        mov     real_mode_regs.RealMode_AX,ax
        mov     real_mode_regs.RealMode_BX,bx
        mov     real_mode_regs.RealMode_CX,cx
        mov     real_mode_regs.RealMode_DX,dx
        mov     real_mode_regs.RealMode_SI,si
        mov     real_mode_regs.RealMode_DI,di

        pushf
        pop     real_mode_regs.RealMode_Flags

        mov     ax,real_es
        mov     dx,real_ds
        mov     real_mode_regs.RealMode_ES,ax
        mov     real_mode_regs.RealMode_DS,dx

        xor     ax,ax
        mov     real_mode_regs.RealMode_FS,ax
        mov     real_mode_regs.RealMode_GS,ax
        mov     real_mode_regs.RealMode_SP,ax     ; let Win386 worry about the stack
        mov     real_mode_regs.RealMode_SS,ax
        mov     real_mode_regs.RealMode_BP,ax
        mov     real_mode_regs.RealMode_CS,ax
        mov     real_mode_regs.RealMode_IP,ax

        mov     ax,ss                       ; es:di --> real_mode_regs
        mov     es,ax
        lea     di,real_mode_regs
        mov     ax,Int31_Trans_Sim_Int
        xor     cx,cx                       ; Copy zero stack params
        mov     bx,real_int                 ; bl is interupt, bh is flags
        int     31h                         ; call it!
        ;
        ;   For now DONT! restore the registers, from Call struc
        ;
cEnd

sEnd    CodeSeg

end
