; lv.asm - Lava Flow Simulation
;
;     (C) Copyright Microsoft Corp. 1991.  All rights reserved.
;
;     You have a royalty-free right to use, modify, reproduce and 
;     distribute the Sample Files (and/or any modified version) in 
;     any way you find useful, provided that you agree that 
;     Microsoft has no warranty obligations or liability for any 
;     Sample Application Files which are modified. 
;
?WIN	= 0
?PLM    = 0
?386	= 1
        .xlist
        include cmacros.inc
	.list

        .386p

MAXINT equ 7FFFh
MININT equ 8000h


;       The following two equates are just used as shorthand
;       for the "word ptr" and "byte ptr" overrides.

wptr    equ     word ptr
bptr    equ     byte ptr

; The following structure should be used to access high and low
; words of a DWORD.  This means that "word ptr foo[2]" -> "foo.hi".

LONG    struc
lo      dw      ?
hi      dw      ?
LONG    ends

FARPOINTER      struc
off     dw      ?
sel     dw      ?
FARPOINTER	ends

CHARGE	struc
cgx	dw	?
cgy	dw	?
cgvalue dw	?
CHARGE ends

externNP <ulSqrt>

sBegin Data
lastvalue dw 0
;;;;externW nColors
sEnd

sBegin Code
assumes cs,code
assumes ds,data
;;;
;;;WORD LavaFlowXY(int nCenter, CHARGE aptCenter[], int x, int y)
;;;{
;;;    register int	i;
;;;    DWORD	rgb;
;;;    static int	    n;
;;;    int	nColors;
;;;
;;;    long     dx,dy;
;;;    long	xSum,ySum;
;;;    long	d;
;;;    long     d2;
;;;    long     adj;
;;;
;;;    xSum = ySum = 0;
;;;    for (i=0; i<nCenter; i++)
;;;    {
;;;	dx = aptCenter[i].pt.x - x;
;;;	dy = aptCenter[i].pt.y - y;
;;;
;;;	d2 = dx*dx + dy*dy;
;;;	// d = sqrt(d2);
;;;
;;;	if (d2 == 0)
;;;	   {
;;;	    return n;
;;;	   }
;;;
;;;	adj = dx*dy;
;;;	xSum += (dx*adj*aptCenter[i].value<<4)/(d2);
;;;	ySum += (dy*adj*aptCenter[i].value<<4)/(d2);
;;;    }
;;;
;;;    xSum >>= 4;
;;;    ySum >>= 4;
;;;
;;;    //d = sqrt(xSum*xSum + ySum*ySum);
;;;    d = Sqrt(xSum*xSum + ySum*ySum);
;;;
;;;    n = d;
;;;
;;;    return n;
;;;}

cProc  LavaFlowXY386, PUBLIC
        parmW   nCenter
        parmW   aptCenter
        parmW   x
        parmW   y
        localD  deltax
        localD  deltay
        localD  adj
cBegin
        push    esi
        push    edi
        movzx   eax,ax
        movzx   ebx,bx
        movzx   ecx,cx
        movzx   edx,dx
        movzx   esi,si
        movzx   edi,di

        ;;;Loop vars
        ;;;
        ;;; si   pointer to charge array
        ;;; eax  scratch
        ;;; edx  scratch
        ;;; ebx  xSum
        ;;; ecx  ySum
        ;;; edi  d2

        ;si points to start of charge array
        mov     si,aptCenter
        ;zero xSum and ySum
        xor     ebx,ebx
        mov     ecx,ebx

lava_loop:
        movsx   eax,[si].cgx
        movsx   edx,x
        sub     eax,edx
        mov     deltax,eax
        movsx   edx,[si].cgy
        movsx   edi,y
        sub     edx,edi
        mov     deltay,edx

        ;;; eax holds deltax*deltay
        imul    edx
        mov     adj,eax

        ;;; get back deltas and calculate d2=deltax*deltax+deltay*deltay
        mov     eax,deltax
        imul    eax
        mov     edi,eax
        mov     eax,deltay
        imul    eax
        add     edi,eax

        ; if d2 is zero, we are at a center return last found index
        ;
        mov     ax,lastvalue
        or      edi,edi
        jz      lava_exit

;;; xSum += (dx*adj*aptCenter[i].value<<4)/(d2);
;;;
        mov     eax,deltax
        imul    adj

        ;;; edx:eax holds dx*adj
        movsx   edx,[si].cgvalue
        imul    edx

        shl     eax,1
        idiv    edi
        add     ebx,eax

;;; ySum += (dy*adj*aptCenter[i].value<<4)/(d2);
;;;
        mov     eax,deltay
        imul    adj
        ;;; edx:eax holds dy*adj
        movsx   edx,[si].cgvalue
        imul    edx

        shl     eax,1
        idiv    edi

        ;;; ySum += eax
        add     ecx,eax

lava_next:
        add     si,size CHARGE
        dec     nCenter
        jnz     lava_loop

;;;    xSum >>= 4;
;;;    ySum >>= 4;
;;;
;;;    //d = sqrt(xSum*xSum + ySum*ySum);
;;;    d = Sqrt(xSum*xSum + ySum*ySum);
;;;
;;;    n = d;
;;;
;;;    return n;
;;;
        shr     ebx,1
        shr     ecx,1

        mov     eax,ebx
        imul    eax
        mov     edi,eax
        mov     eax,ecx
        imul    eax
        add     eax,edi

        push    eax
        cCall   ulSqrt
        add     sp,4

;;;;	dont do MOD here let the caller do it
;;;;
;;;;    mov     cx,nColors
;;;;    xor     dx,dx
;;;;    div     cx
;;;;    mov     ax,dx

        ;;; save value in static for use at nodes
        mov     lastvalue,ax
lava_exit:
        pop     edi
        pop     esi
cEnd


sEnd Code

end
