/* file.c
 *
 * File I/O and related functions.
 */

#include "nocrap.h"
#include <windows.h>
#include <stdlib.h>
#include "commdlg.h"
//#include <wincom.h>
#include "MergeDIB.h"
#include "dib.h"


/* FreeDIB(iDIB)
 *
 * Delete <gahdib[iDIB]> and <gahpal[iDIB]>.  If <iDIB> is MERGED_DIB,
 * then also free the elements of <gaplogpal>.
 */
void FAR PASCAL
FreeDIB(int iDIB)
{
	int		i;

	if (gahdib[iDIB] != NULL)
		GlobalFree(gahdib[iDIB]), gahdib[iDIB] = NULL;

	if (gahpal[iDIB] != NULL)
		DeleteObject(gahpal[iDIB]), gahpal[iDIB] = NULL;
	
	if (iDIB == MERGED_DIB)
	{
		for (i = PRIMARY_DIB; i <= MERGED_DIB; i++)
		{
			if (gaplogpal[i] != NULL)
			{
				LocalFree((HANDLE) gaplogpal[i]);
				gaplogpal[i] = NULL;
			}
		}
	}
}


/* fOK = FileOpen(iDIB, szFileName)
 *
 * If <szFileName> is NULL, do a File/Open command to open <gahdib[iDIB]>
 * and <gahpal[iDIB]>.  Otherwise, open <szFileName>.
 *
 * Return TRUE unless the user cancelled or the operation failed.
 */
BOOL FAR PASCAL
FileOpen(int iDIB, LPSTR szFileName)
{
	BOOL		fOK = TRUE;	// function succeeded?
	char		achFileName[_MAX_PATH]; // user-specified file name
	int		fh = -1;	// DOS file handle
	HCURSOR		hcurPrev = NULL; // cursor before hourglass
	BITMAPINFOHEADER bih;		// information about this DIB
	BITMAPINFOHEADER bihOther;	// information about other DIB

	/* put file name into <achFileName> (get from user or <szFileName>) */
	if (szFileName == NULL)
	{
		/* prompt the user for the name of the file to open */
		if (!PromptForFileName(ghwndApp, ghInst, achFileName,
				sizeof(achFileName), IDS_OPEN, OPENFILEFILTER,
				IDS_DEFEXT, PFFN_OPENFILE | PFFN_UPPERCASE))
			goto RETURN_ERROR;
	}
	else
		lstrcpy(achFileName, szFileName);

	/* show hourglass cursor */
	hcurPrev = SetCursor(LoadCursor(NULL, IDC_WAIT));

	/* opening a new primary DIB clears the secondary DIB */
	if (iDIB == PRIMARY_DIB)
		FreeDIB(SECONDARY_DIB);
	
	/* free the old DIB */
	FreeDIB(iDIB);

	/* read the DIB into memory */
	if ((gahdib[iDIB] = OpenDIB(achFileName)) == NULL)
		goto ERROR_OPENING;

	/* create a palette for the DIB */
	if ((gahpal[iDIB] = CreateDibPalette(gahdib[iDIB])) == NULL)
		goto ERROR_OPENING;
	
	/* set the DIB to be DIB_PAL_COLORS */
	SetDibUsage(gahdib[iDIB], gahpal[iDIB], DIB_PAL_COLORS);

	/* get the size etc. of the bitmap */
	DibInfo(gahdib[iDIB], &bih);

	if ((bih.biPlanes != 1) || (bih.biBitCount != 8))
		goto ERROR_BADDIBTYPE;

	if (gahdib[!iDIB] != NULL)
	{
		/* other DIB is loaded -- make sure this DIB is the same
		 * size as the other DIB
		 */
		DibInfo(gahdib[!iDIB], &bihOther);
		if ((bih.biWidth != bihOther.biWidth) ||
		    (bih.biHeight != bihOther.biHeight))
			goto ERROR_BADDIBSIZE;
		
		/* calculate a new merged DIB */
		FreeDIB(MERGED_DIB);
		PostMessage(ghwndApp, WM_COMMAND, IDM_VIEWMERGEDDIB, 0L);
	}
	else
	{
		/* display the DIB */
		PostMessage(ghwndApp, WM_COMMAND,
			IDM_VIEWPRIMARYDIB + iDIB, 0L);
	}

	goto RETURN_SUCCESS;

ERROR_OPENING:				// display generic error message
#ifdef IGNOREERRORS
	ErrorResBox(ghwndApp, ghInst, MB_ICONEXCLAMATION | MB_OK, 
		IDS_APPNAME, IDS_ERROROPEN, (LPSTR) achFileName);
#endif	    
	goto RETURN_ERROR;

ERROR_BADDIBTYPE:			// bad type of DIB

#ifdef IGNOREERRORS
	ErrorResBox(ghwndApp, ghInst, MB_ICONEXCLAMATION | MB_OK, 
		IDS_APPNAME, IDS_BADDIBTYPE);
#endif	    
	goto RETURN_ERROR;

ERROR_BADDIBSIZE:			// bad size of DIB

#ifdef IGNOREERRORS
	ErrorResBox(ghwndApp, ghInst, MB_ICONEXCLAMATION | MB_OK, 
		IDS_APPNAME, IDS_BADDIBSIZE);
#endif	    
	goto RETURN_ERROR;

RETURN_ERROR:				// do error exit without error message

	fOK = FALSE;

RETURN_SUCCESS:				// normal exit

	if (hcurPrev != NULL)
		SetCursor(hcurPrev);
	
	if (!fOK)
		FreeDIB(iDIB);

	return fOK;
}
