/* MergeDIB.h
 */


/* constants */
#define MAXPALSIZE	236		// max. no. entries in a palette
#define PRIMARY_DIB	0		// index into <gahdib> and <gahpal>
#define SECONDARY_DIB	1		// index into <gahdib> and <gahpal>
#define MERGED_DIB	2		// index into <gahdib> and <gahpal>
#define SCROLL_RANGE	10000		// range of scroll bar
#define SCROLL_PAGE	1000		// page up/down scrolls this much
#define SCROLL_LINE	100		// line up/down scrolls this much


/* a window proc */
typedef LONG (FAR PASCAL * LPWNDPROC) ();


/* globals from "MergeDIB.c" */
extern HWND		ghwndApp;	// main application window
extern HMENU		ghmenuApp;	// main application menu
extern HANDLE		ghInst;		// program instance handle
extern GLOBALHANDLE	gahdib[3];	// primary/secondary/merged DIB
extern HPALETTE		gahpal[3];	// primary/secondary/merged palette
extern HPALETTE		ghpal;		// current palette
extern BOOL		giDIBViewed;	// which DIB is being viewed?
extern NPLOGPALETTE	gaplogpal[3];	// primary/secondary/merged color table

/* globals from "rare.c" */
extern char		gachAppName[];	// for title bar etc.


/* <dwFlags> for PromptForFileName() */
#define PFFN_OPENFILE		0x0001	// prompt to open a file
#define PFFN_SAVEFILE		0x0002	// prompt to save a file
#define PFFN_SHOWDEFAULT	0x0004	// init. show what's in <achFileName>
#define PFFN_OVERWRITEPROMPT	0x0008	// prompt the user about overwriting
#define PFFN_UPPERCASE		0x0010	// make the name uppercase


/* RCDATA resources */
#define OPENFILEFILTER		10


/* "File" menu */
#define IDM_OPENPRIMARYDIB	11
#define IDM_OPENSECONDARYDIB	12
#define IDM_EXIT		13
#define IDM_ABOUT		14

/* "Edit" menu */
#define IDM_COPYMERGEDPALETTE	21

/* "View" menu */
#define IDM_VIEWPRIMARYDIB	31
#define IDM_VIEWSECONDARYDIB	32
#define IDM_VIEWMERGEDDIB	33
#define IDM_FADE		34


/* strings */
#define IDS_APPNAME		100	// MergeDIB
#define IDS_UNTITLED		101	// (Untitled)
#define IDS_DEFEXT		102	// <default extension>
#define IDS_OPEN		103	// Open Bitmap
#define IDS_ERROROPEN		104	// Error opening '<file>'
#define IDS_OUTOFMEM		105	// Out of memory
#define IDS_BADDIBTYPE		107	// HackDib only supports...
#define IDS_BADDIBSIZE		108	// Secondary DIB must be same size...
#define IDS_MERGEPALEXCEEDED	109	// Merged DIB would need...


/* prototypes from "MergeDIB.c" */
void FAR PASCAL AppPaint(HWND hwnd, HDC hdc);
void FAR PASCAL InitMenus(void);
int PASCAL WinMain(HANDLE hInst, HANDLE hPrev, LPSTR lpszCmdLine, int iCmdShow);
LONG FAR PASCAL _export AppWndProc(HWND hwnd, WORD wMsg,
	WORD wParam, LONG lParam);

/* prototypes from "file.c" */
void FAR PASCAL FreeDIB(int iDIB);
BOOL FAR PASCAL FileOpen(int iDIB, LPSTR szFileName);

/* prototypes from "rare.c" */
BOOL FAR PASCAL AppInit(HANDLE hInst, HANDLE hPrev);
void FAR PASCAL AppExit(HWND hwnd);
BOOL FAR PASCAL _export AboutDlgProc(HWND hwnd, WORD wMsg,
	WORD wParam, LONG lParam);
BOOL FAR PASCAL PromptForFileName(HWND hwndOwner, HANDLE hInst,
	LPSTR achFileName, WORD cchFileName, WORD idCaption,
	WORD idFilter, WORD idDefExt, DWORD dwFlags);
