/* rare.c
 *
 * Rarely-called (discardable) utility functions.
 */

#include <windows.h>
// commdlg included with 3.1 SDK or package available from MM BBS (206) 936-4082
#include "commdlg.h"
#include "MergeDIB.h"


/* globals */
char		gachAppName[20]; 	// for title bar etc.


/* AppInit(hInst, hPrev)
 *
 * This is called when the application is first loaded into memory.
 * It performs all initialization that doesn't need to be done once
 * per instance.  Returns TRUE iff successful.
 */
BOOL FAR PASCAL
AppInit(hInst, hPrev)
HANDLE		hInst;		// instance handle of current instance
HANDLE		hPrev;		// instance handle of previous instance
{
	WNDCLASS	wndclass;

	/* get the application name from a string resource */
	gachAppName[0] = 0;		// in case of error
	LoadString(ghInst, IDS_APPNAME, gachAppName, sizeof(gachAppName));

#ifdef XDEBUG
	wpfGetDebugLevel(gachAppName);
	dprintf("----- %s -----\n", (LPSTR) gachAppName);
#endif

	if (!hPrev)
	{
		/* register a class for the main application window */
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hIcon = LoadIcon(hInst, "AppIcon");
		wndclass.lpszMenuName = "AppMenu";
		wndclass.lpszClassName = gachAppName;
		wndclass.hbrBackground = (HBRUSH) COLOR_WINDOW + 1;
		wndclass.hInstance = hInst;
		wndclass.style = CS_BYTEALIGNCLIENT | CS_VREDRAW | CS_HREDRAW;
		wndclass.lpfnWndProc = (LPWNDPROC) AppWndProc;
		wndclass.cbWndExtra = 0;
		wndclass.cbClsExtra = 0;

		if (!RegisterClass(&wndclass))
			return FALSE;
	}

	return TRUE;
}


/* AppExit(hwnd)
 *
 * This is called when the application is about to exit.  Global cleanup
 * should be done here.  <hwnd> is the application window, which has *not*
 * been destroyed yet (but is about to be destroyed).
 */
void FAR PASCAL
AppExit(hwnd)
HWND		hwnd;		// application window
{
	FreeDIB(PRIMARY_DIB);
	FreeDIB(SECONDARY_DIB);
	FreeDIB(MERGED_DIB);
}


/* AboutDlgProc(hwnd, wMsg, wParam, lParam)
 *
 * This function handles messages belonging to the "About" dialog box.
 * The only message that it looks for is WM_COMMAND, indicating the use
 * has pressed the "OK" button.  When this happens, it takes down
 * the dialog box.  Returns TRUE iff message has been processed
 */
BOOL FAR PASCAL _export
AboutDlgProc(hwnd, wMsg, wParam, lParam)
HWND     	hwnd;		// window handle of "about" dialog box
WORD		wMsg;		// message number
WORD     	wParam;		// message-dependent parameter
LONG     	lParam;		// message-dependent parameter
{
	switch (wMsg)
	{

	case WM_COMMAND:

		if (wParam == IDOK)
			EndDialog(hwnd, TRUE);
		break;

	case WM_INITDIALOG:

		return TRUE;

	}

	return FALSE;
}


/* fOK = PromptForFileName(hwndOwner, hInst, achFileName, cchFileName,
 *                         idCaption, idFilter, idDefExt, dwFlags)
 *
 * Prompt the user for the name of a file to open or save to.  <hwndOwner>
 * is the window that will own the dialog.  <hInst> is the module that the
 * string resources and RCDATA resource (see below) will be loaded from.
 *
 * The returned file name will be placed in <achFileName>, which must
 * have a capacity of at least <cchFileName> bytes.
 *
 * <idCaption> is the string resource id of the caption to display.
 * <idFilter> is the RCDATA resource id that contains the filter spec
 * (in the format used by COMMDLG).  <idDefExt> is the string resource id
 * of the default extension (without the period).  Any or all of these
 * three parameters may be NULL, for default behaviour.
 *
 * <dwFlags> are used as follows:
 *   -- PFFN_OPENFILE: prompt the user for the name of a file to open
 *   -- PFFN_SAVEFILE: prompt the user for the name of a file to save to
 *   -- PFFN_SHOWDEFAULT: on entry, <achFileName> will contain the name
 *      of a file to display as the "default file name"
 *   -- PFFN_OVERWRITEPROMPT: prompt the user before accepting allowing them
 *      to choose an existing file
 *   -- PFFN_UPPERCASE: make <achFileName> uppercase before returning
 */
BOOL FAR PASCAL
PromptForFileName(hwndOwner, hInst, achFileName, cchFileName,
	idCaption, idFilter, idDefExt, dwFlags)
HWND		hwndOwner;		// window that will own dialog box
HANDLE		hInst;			// module that contains the resources
LPSTR		achFileName;		// where to put file name
WORD		cchFileName;		// size of <achFileName>
WORD		idCaption;		// string ID of caption string
WORD		idFilter;		// resource ID of RCDATA of file filter
WORD		idDefExt;		// string ID of default extension
DWORD		dwFlags;		// random flags
{
	char		achCaption[80];	// caption on Open File dialog
	HANDLE		hResInfo;	// info about filter resource
	HANDLE		hResData;	// handle to filter resource
	char		achDefExt[4];	// default extension
	OPENFILENAME	ofname;		// parameter block
	BOOL		f;

	/* initialize <ofname.lpstrFilter> */
	if (idFilter != NULL)
	{
		/* load the filter spec for GetOpenFileName() */
		hResInfo = FindResource(hInst,
			MAKEINTRESOURCE(idFilter), RT_RCDATA);
		if ((hResData = LoadResource(hInst, hResInfo)) == NULL)
			ofname.lpstrFilter = NULL;
		else
			ofname.lpstrFilter = LockResource(hResData);
	}
	else
		ofname.lpstrFilter = NULL;

	/* initialize <ofname.lpstrTitle> */
	if (idCaption != NULL)
	{
		achCaption[0] = 0;	// in case of error
		LoadString(ghInst, idCaption, achCaption, sizeof(achCaption));
		ofname.lpstrTitle = achCaption;
	}
	else
		ofname.lpstrTitle = NULL;

	/* initialize <ofname.lpstrDefExt> */
	if (idDefExt != NULL)
	{
		achDefExt[0] = 0;	// in case of error
		LoadString(ghInst, idDefExt, achDefExt, sizeof(achDefExt));
		ofname.lpstrDefExt = achDefExt;
	}
	else
		ofname.lpstrDefExt = NULL;

	/* the initial file name is "" unless PFFN_SHOWDEFAULT is given */
	if (!(dwFlags & PFFN_SHOWDEFAULT))
		achFileName[0] = 0;

	/* fill in the other fields of <ofname> */
	ofname.lStructSize = sizeof(ofname);
	ofname.hwndOwner = hwndOwner;
	ofname.hInstance = hInst;
	ofname.lpstrCustomFilter = NULL;
	ofname.nMaxCustFilter = 0;
	ofname.nFilterIndex = 1;
	ofname.lpstrFile = achFileName;
	ofname.nMaxFile = cchFileName;
	ofname.lpstrFileTitle = NULL;
	ofname.nMaxFileTitle = 0;
	ofname.lpstrInitialDir = NULL;
	ofname.Flags = OFN_HIDEREADONLY |
		(dwFlags & PFFN_OVERWRITEPROMPT ? OFN_OVERWRITEPROMPT : 0);
	ofname.lCustData = NULL;
	ofname.lpfnHook = NULL;
	ofname.lpTemplateName = NULL;

	/* prompt the user for the file name */
	if (dwFlags & PFFN_OPENFILE)
		f = GetOpenFileName(&ofname);
	else
		f = GetSaveFileName(&ofname);

	/* unlock the OpenFileFilter resource */
	if (idFilter != NULL)
		UnlockResource(hResData);

	/* make the name uppercase if requested */
	if (f && (dwFlags & PFFN_UPPERCASE))
		AnsiUpper(achFileName);

	return f;
}
