; lstr.asm:
;
; Copyright (C) Microsoft Corporation 1990, 1991.
; All Rights reserved.
;
; masm -Mx -Zi -DSEGNAME=????? lstr.asm
;
	TITLE LSTR.ASM - asm code dude

;****************************************************************
;* LSTR.ASM - ASM string copies					*
;*								*
;****************************************************************
;

?PLM=1	    ; PASCAL Calling convention is DEFAULT
?WIN=1	    ; Windows calling convention

.xlist
include cmacros.inc
.list

; The following structure should be used to access high and low
; words of a DWORD.  This means that "word ptr foo[2]" -> "foo.hi".

LONG    struc
lo      dw      ?
hi      dw      ?
LONG    ends

FARPOINTER      struc
off     dw      ?
sel     dw      ?
FARPOINTER      ends

; -------------------------------------------------------
;               DATA SEGMENT DECLARATIONS
; -------------------------------------------------------

ifndef SEGNAME
    SEGNAME equ <_TEXT>
endif

.286
createSeg %SEGNAME, CodeSeg, word, public, CODE

sBegin Data
sEnd Data

sBegin CodeSeg
assumes cs,CodeSeg
assumes ds,DATA



cProc lstrncpy,<FAR,PUBLIC,NODATA>,<>
	ParmD	lpDest
	ParmD	lpSource
	ParmW	n
cBegin
	mov	cx, n
	or	cx, cx
	jz	ncpy_exit	; if 0 given for size, bail out now

	push	si		; Preserve C registers
	push	di
	push	ds

	cld
	les	di, lpDest	; Load source, dest, and count
	lds	si, lpSource

ncpy_copy:
	lodsb			; byte from source to al, inc src
	stosb			; al into dest, inc dest
	or	al,al		; load zero flag for the byte
	loopnz	ncpy_copy	; dec cx, if cx=0 or byte=0, break;

if 0
	; Pad the rest of dest string with NULLs
	xor	al, al			; zero out the byte to store
	rep stosb byte ptr es:[di]	; zero fill
endif

	pop	ds		; note: pop regs before the lstrncpy_exit
	pop	di		; label, which is called before regs pushed
	pop	si
ncpy_exit:
        mov     ax,lpDest.off   ; return something consistent
        mov     dx,lpDest.sel
cEnd






cProc lstrncat,<FAR,PUBLIC,NODATA>,<>
	ParmD	lpDest
	ParmD	lpSource
	ParmW	n
cBegin
	test	n, 0ffffh		; check if zero count specified
	jz	ncat_nocopy_exit

	; preserve appropriate registers
	push	di
	push	si
	push	ds

	; Find end of the destination string
	cld
	les	di, lpDest
	mov	cx, 0ffffh		; is this bogus?

	xor	al, al			; test for zero

	repnz	scasb			; find first NULL character

	or	cx, cx			; check overrun.  We've probably GP
	jz	ncat_exit		; faulted by now...

	; Now copy the first n chars of lpSource onto lpDest
	lds	si, lpSource

	dec	di			; copy over src's \0
	mov	cx, n			; mbr: gee, maybe this line would help

ncat_copy:
	lodsb			; byte from source to al, inc src
	stosb			; al into dest, inc dest
	or	al,al		; load zero flag if the byte == \0
	loopnz	ncat_copy	; dec cx, if cx=0 or byte=0, break;

	jz	ncat_exit	; if last character copied was NULL, we don't
				; need to null terminate the dest string.
	mov	byte ptr es:[di], 0h

ncat_exit:
	pop	ds
	pop	si
	pop	di

ncat_nocopy_exit:
        mov     ax,lpDest.off   ; return something consistent
        mov     dx,lpDest.sel
cEnd	


sEnd CodeSeg
end
