/* mmplay.h - Header file for MMPLAY movie player sample application.
 */


/* Resource IDs.
 */
#define ABOUTBOX            150
#define MMPLAYACCELS        1000

#define IDM_OPEN            101
#define IDM_CLOSE           102
#define IDM_EXIT            103
#define IDM_ABOUT           104

#define IDM_COPYFRAME       201

#define IDM_START           301
#define IDM_STOP            302
#define IDM_REWIND          303
#define IDM_STEPFORWARD     304
#define IDM_STEPBACKWARD    305
#define IDM_STARTSTOP       306

#define IDM_LOADOPTIONS     400
#define IDM_MUTE            401
#define IDM_LOOPMOVIE       402
#define IDM_FULLSCREEN      403

#define OPTIONS             500
#define IDD_NOSTATIC        501
#define IDD_ONDEMAND        502
#define IDD_EXPANDDIBS      503


#define PALVERSION          0x300

#define WM_MMPLAY_SWITCH     (WM_USER+10)


/* Function Prototypes.
 */
int PASCAL WinMain ( HANDLE, HANDLE, LPSTR, int );
HWND AppInit ( HANDLE, HANDLE );

LONG FAR PASCAL MainWndProc (HWND, unsigned, WORD, LONG);
LONG HandleCommands (HWND, int, WORD, LONG);
LONG FAR PASCAL StageWndProc (HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL AppAbout (HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL LoadOptions (HWND , unsigned , WORD , LONG);

BOOL OpenDriverInstance (HWND);
BOOL CreateStage (void);
BOOL OpenMovie (BOOL);
void SetupStageWindow (HWND, MMPID);
void SetMenuStates (HWND);
void ShowMMPError (void);
HPALETTE CopyPalette (HPALETTE);
void CopyFrame (HWND);
void near AppClose(void);

void WriteFlags (void);
void ReadFlags (void);

