/*
     (C) Copyright Microsoft Corp. 1991.  All rights reserved.

     You have a royalty-free right to use, modify, reproduce and 
     distribute the Sample Files (and/or any modified version) in 
     any way you find useful, provided that you agree that 
     Microsoft has no warranty obligations or liability for any 
     Sample Application Files which are modified. 
	 
 Draws an images with transparent portions.  The transparent areas are a
 color in the source image.  Demonstrates the 'old' way and the new MM way
 to do transparent drawings.
     
 */

#include <windows.h>
// If you don't have mmsystem.h, just remove the line.  all that is
// really needed is below...
#include <mmsystem.h>
#include "transblt.h"


VOID NEAR PASCAL transbltCommand ( HWND hwnd, WPARAM wParam, LPARAM lParam );
BOOL FAR PASCAL _export AboutDlgProc ( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);



// this is what is needed from mmsystem.h...
#ifndef C1_TRANSPARENT
    #define CAPS1           94          // other caps
    #define C1_TRANSPARENT  0x0001      // new raster cap
    #define NEWTRANSPARENT  3           // use with SetBkMode()

    #define QUERYROPSUPPORT 40          // use to determine ROP support
#endif  // ifndef C1_TRANSPARENT


#define  DSNA  0x00220326L

HANDLE hInst;

char	gach[120];
char    szMsg1[] = "L button for driver method of transparency";
char    szMsg2[] = "R button for traditional method of transparency";

/* handles used for the various bitmaps */

HBITMAP hBitmap=NULL;
HBITMAP hBitmapMask=NULL;

HBITMAP hOBitmapMask;
HBITMAP hOBitmapImage;

COLORREF transColor=RGB(0xFF, 0x00, 0xFF);


HDC hDC;                             /* handle to device context           */
HDC hImageDC;                        /* handle to memory device context    */
HDC hMaskDC;                         /* handle to memory device context    */


BOOL fMask=FALSE;
BOOL fScreen=FALSE;
WORD nBitmap=0;

WORD dummy;

BITMAP Bitmap;                         /* bitmap structure                   */

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    MSG msg;

    if (!hPrevInstance)
	if (!InitApplication(hInstance))
	    return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL)) 
    {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return (msg.wParam);
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
    WNDCLASS  wc;

    wc.style = CS_VREDRAW | CS_HREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, "appicon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "transblt";
    wc.lpszClassName = "TransbltWClass";
    

    return (RegisterClass(&wc));
}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;
    int             nCmdShow;
{
    HWND            hwnd;

    hInst = hInstance;

    hwnd = CreateWindow(
        "TransbltWClass",
        "Transparent Bitmap Sample Application",
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL
    );

    if (!hwnd)
        return (FALSE);

    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    return (TRUE);

}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

        WM_CREATE      - create window and objects
        WM_LBUTTONUP   - end selection, draw bitmap
        WM_DESTROY     - destroy window

****************************************************************************/

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{

    RECT	rc;
    PAINTSTRUCT	ps;
    HBITMAP     tempBit;
    HDC         tempDC;
    HANDLE      hOldObj;
static    int         bTrans;
    TEXTMETRIC  tm;
    WORD	i;
    WORD	xOff, yOff;


    switch (message) 
    {

	case WM_CREATE:

            hDC = GetDC(hWnd);
	    
	    hBitmap = LoadBitmap(hInst, "Image");
	    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &Bitmap);
            bTrans = GetDeviceCaps(hDC, CAPS1) & C1_TRANSPARENT;
	    nBitmap=0;

            ReleaseDC(hWnd, hDC);
	    hDC=NULL;
	    break;
	    

	case WM_PAINT:
	    BeginPaint(hWnd, &ps);

            GetTextMetrics(ps.hdc, &tm);

	    lstrcpy(gach,szMsg1);
	    if(bTrans)
		lstrcat(gach," (Is Supported)");
	    else
		lstrcat(gach," (Not Supported)");
	    
            TextOut(ps.hdc, 0, 0, gach, lstrlen(gach));
            TextOut(ps.hdc, 0, tm.tmHeight, szMsg2, lstrlen(szMsg2));

	    EndPaint(hWnd, &ps);
	    break;


        case WM_LBUTTONDOWN:

            if (bTrans)
	    {
		hDC = GetDC(hWnd);
		SetBkColor(hDC, transColor);
		SetBkMode(hDC, NEWTRANSPARENT);

		// Get source image...
		    hImageDC   = CreateCompatibleDC(hDC);
		hOBitmapImage=SelectObject(hImageDC, hBitmap);
	    


		BitBlt (hDC, LOWORD(lParam), HIWORD(lParam),
		      Bitmap.bmWidth, Bitmap.bmHeight, hImageDC,
		      0, 0,SRCCOPY);
		  
		SelectObject(hImageDC, hOBitmapImage);
		DeleteDC(hImageDC);
	    
		ReleaseDC(hWnd, hDC);
	    }
            else 
	    {
		MessageBeep(MB_ICONEXCLAMATION);
		MessageBox(hWnd, (LPSTR)"Driver does not support transparency",
                         (LPSTR)"GetDeviceCaps", MB_ICONEXCLAMATION);
            }



            break;

	case WM_RBUTTONDOWN:

            hDC = GetDC(hWnd);

	    hImageDC   = CreateCompatibleDC(hDC);
	    hMaskDC    = CreateCompatibleDC(hDC);

	    hOBitmapImage=SelectObject(hImageDC, hBitmap);

	    
	    // We can optimize speed more by saving mask bitmap instead of
	    // re-creating it every time, but this takes up more memory

	    if(!fMask && hBitmapMask)
	    {
		DeleteObject(hBitmapMask);
		hBitmapMask=NULL;
	    }
	    
	    if(!hBitmapMask)
	    {
		hBitmapMask = CreateBitmap(Bitmap.bmWidth, Bitmap.bmHeight, 1, 1, NULL);
		hOBitmapMask=SelectObject(hMaskDC, hBitmapMask);
	    
		// set background color for color-to-mono conversion
		// (bk color will be white(1), all else is black (0) )
		SetBkColor(hImageDC, transColor);
		
		BitBlt(hMaskDC,  0, 0, Bitmap.bmWidth, Bitmap.bmHeight,
		    hImageDC, 0, 0, SRCCOPY);
	       
		// invert 1s and 0s to get valid mask... (could also use
		// bitblt() and DSTINVERT ROP
		rc.left=rc.top=0;
		rc.right=Bitmap.bmWidth;
		rc.bottom=Bitmap.bmHeight;
		InvertRect(hMaskDC,&rc);
		
#ifdef MASKDEBUG
		BitBlt(hDC, 0, 0, Bitmap.bmWidth, Bitmap.bmHeight,
		    hMaskDC, 0, 0, SRCCOPY);
#endif
	    }
	    else
	    {
		// re-use mask bitmap from last time.
		    
		hOBitmapMask=SelectObject(hMaskDC, hBitmapMask);
		
#ifdef MASKDEBUG
		BitBlt(hDC, 0, 0, Bitmap.bmWidth, Bitmap.bmHeight,
		    hMaskDC, 0, 0, SRCCOPY);
#endif
	    }
	       
	    // now we have mask bitmap: we can continue
		
	    if(!fScreen)
	    {
		// Do work off-screen so we don't see flash of INVERTS
		// This is a little slower (but if you're keeping an off-screen
		// bitmap of the screen anyway you should use it)
		
		tempDC = CreateCompatibleDC (hDC);
		tempBit = CreateCompatibleBitmap(hDC, Bitmap.bmWidth, Bitmap.bmHeight);
		hOldObj = SelectObject (tempDC, tempBit);

		// copy what's on the screen first
		BitBlt (tempDC, 0, 0, Bitmap.bmWidth,Bitmap.bmHeight, hDC,
			LOWORD(lParam), HIWORD(lParam), SRCCOPY);
		xOff=0;
		yOff=0;
	    }
	    else
	    {
		// faster, but uglier
		    
		tempDC=hDC;	// do work directly on screen
		xOff=LOWORD(lParam);
	        yOff=HIWORD(lParam);
	    }

	    // these three blits do the work...
		
	
	    BitBlt(tempDC,   xOff, yOff, Bitmap.bmWidth, Bitmap.bmHeight,
		   hImageDC, 0, 0, SRCINVERT);

	    BitBlt(tempDC,   xOff, yOff, Bitmap.bmWidth, Bitmap.bmHeight,
		   hMaskDC,  0, 0, DSNA);

	    BitBlt(tempDC,   xOff, yOff, Bitmap.bmWidth, Bitmap.bmHeight,
		   hImageDC, 0, 0, SRCINVERT);

	    if(!fScreen)
	    {
		// put it all on the physical device
		    
		BitBlt (hDC, LOWORD(lParam), HIWORD(lParam),
			Bitmap.bmWidth, Bitmap.bmHeight, tempDC,
			0, 0,SRCCOPY);
		    
		// clean up off-screen bitmaps
		SelectObject(tempDC, hOldObj);
		DeleteDC(tempDC);
		DeleteObject(tempBit);
	    }

	    SelectObject(hMaskDC, hOBitmapMask);
	    DeleteDC(hMaskDC);
	    
	    SelectObject(hImageDC, hOBitmapImage);
	    DeleteDC(hImageDC);
	    
	    if(!fMask)
	    {
		DeleteObject(hBitmapMask);
		hBitmapMask=NULL;
	    }

            ReleaseDC(hWnd, hDC);
            break;

	case WM_DESTROY:
	    DeleteObject(hBitmap);
	    if(hBitmapMask)
		DeleteObject(hBitmapMask);
		    
	    PostQuitMessage(0);
	    break;
	    
	case WM_COMMAND:
	    transbltCommand(hWnd, wParam, lParam);
	    break;
	    
	case WM_INITMENU:
	    CheckMenuItem((HMENU)wParam, IDM_MASK, fMask ? MF_CHECKED : MF_UNCHECKED);
	    CheckMenuItem((HMENU)wParam, IDM_SCREEN, fScreen ? MF_CHECKED : MF_UNCHECKED);
	    for (i=IDM_DEFAULT;i<=IDM_BITMAP_LAST; i++)
		CheckMenuItem((HMENU)wParam, i, MF_UNCHECKED);
	
	    CheckMenuItem((HMENU)wParam, IDM_DEFAULT + nBitmap, MF_CHECKED);

	    break;
	

	default:
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}


VOID NEAR PASCAL transbltCommand ( HWND hwnd, WPARAM wParam, LPARAM lParam )
{
    
    switch (wParam)
    {
	case IDM_CAT:
	    if(nBitmap== (wParam-IDM_DEFAULT))
		break;
	    nBitmap=wParam-IDM_DEFAULT;
	    
	    DeleteObject(hBitmap);
	    if(hBitmapMask)		// mask bitmap
		DeleteObject(hBitmapMask);

	    hBitmapMask=NULL;
	    
            hDC = GetDC(hwnd);
	    hBitmap = LoadBitmap(hInst, "Cat");
	    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &Bitmap);
            ReleaseDC(hwnd, hDC);
	    hDC=NULL;
	    break;
	    
	case IDM_DEFAULT:
	    if(nBitmap== (wParam-IDM_DEFAULT))
		break;
	    
	    nBitmap=wParam-IDM_DEFAULT;
	    
	    DeleteObject(hBitmap);
	    if(hBitmapMask)		// mask bitmap
		DeleteObject(hBitmapMask);

	    hBitmapMask=NULL;
	    
            hDC = GetDC(hwnd);
	    hBitmap = LoadBitmap(hInst, "Image");
	    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &Bitmap);
            ReleaseDC(hwnd, hDC);
	    hDC=NULL;
            break;

	case IDM_HELPABOUT:
	{
	    // Bring up the ubiquitous Ego box
	    FARPROC lpfn;

	    lpfn = MakeProcInstance(AboutDlgProc, hInst);
	    DialogBox (hInst, IDD_ABOUT, hwnd, lpfn);
	    FreeProcInstance (lpfn);
	    break;
	}
	case IDM_MASK:
	    fMask=!fMask;
	    break;
	case IDM_SCREEN:
	    fScreen=!fScreen;
	    break;

    }
}


BOOL FAR PASCAL _export AboutDlgProc ( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    char ach[128];
    
    switch (msg)
    {
	case WM_INITDIALOG:
	    // nothing to initialize 
	    wsprintf(ach,"Compiled: %s %s",(LPSTR)__DATE__,(LPSTR)__TIME__);
	    SetDlgItemText(hwnd,IDD_TEXT,ach);
	    break;

	case WM_COMMAND:
	    switch (wParam)
	    {
		case IDOK:
		case IDCANCEL:
		    EndDialog(hwnd, 0);
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default:
	    return FALSE;
    }

    return TRUE;
}
