#include <windows.h>
#include "4d.h"

/*
     (C) Copyright Microsoft Corp. 1991.  All rights reserved.

     You have a royalty-free right to use, modify, reproduce and 
     distribute the Sample Files (and/or any modified version) in 
     any way you find useful, provided that you agree that 
     Microsoft has no warranty obligations or liability for any 
     Sample Application Files which are modified. 
 */

#define PI	    3.1415926535897931216823
#define FXPI	    205887

#define fDebug 0
/* extern int fDebug; */
TRANSFORM *CTM;    /* global, current transform */

int vAppendTransform (TRANSFORM *T,void *arg);

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
TRANSFORM *NewTransform()
{
    TRANSFORM *pT;

    pT = (TRANSFORM *)LocalAlloc (LPTR, sizeof(TRANSFORM));
    InitTransform (pT);
    return pT;
}

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
TRANSFORM *MakeTM(a)
{
    TRANSFORM *pT;

    pT = NewTransform();
    if (pT != NULL) {
       vAppendTransform (pT,&a);
    }
    return pT;
}

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
int FreeTransform (pT)
    TRANSFORM *pT;
{
    LocalUnlock((HANDLE)pT);
    LocalFree((HANDLE)pT);
    return 1;
}

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/

int AppendTransform (T,...)
    TRANSFORM *T;
{
    return vAppendTransform (T,(&T) + 1);
}


/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/

int SetTransform (T,...)
    TRANSFORM *T;
{
    InitTransform (T);
    return vAppendTransform (T,(&T) + 1);
}

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/

void InitTransform (T)
    TRANSFORM *T;
{
    T->T    = Identity4D();
    T->Tinv = Identity4D();
}

/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/

void ComposeTransform (T,T1)
    TRANSFORM *T;
    TRANSFORM *T1;
{
    /*
     *	T *= T1
     */

    T->T    = TxT4D (&T->T,&T1->T);
    T->Tinv = TxT4D (&T1->Tinv,&T->Tinv);
}

void PreposeTransform (T,T1)
    TRANSFORM *T;
    TRANSFORM *T1;
{
    /*
     *	T *= T1 * T
     */

    T->T    = TxT4D (&T1->T,&T->T);
    T->Tinv = TxT4D (&T->Tinv,&T1->Tinv);
}



/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/

int vAppendTransform (TRANSFORM *T,void *arg)
{
  FIXED4D x,y,z;
  MATRIXFX Temp;
  int op;

  while (*(int*)arg != END) {
    switch (op = *((int*)arg)++) {
      case SCALE:
      case SCALE4D:
	x = *((FIXED4D *)arg)++; y = *((FIXED4D *)arg)++; z = *((FIXED4D *)arg)++;
#if 0	
	if (fDebug) {
	    printf ("SCALE ");
	    PrintFx(x);
	    PrintFx(y);
	    PrintFx(z);
	    printf("\n");
	    }
#endif	    
	Temp = Scale4D(CreatePoint4D(x,y,z,ONE));
        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
	Temp = Scale4D(CreatePoint4D (FXDIV(ONE,x),FXDIV(ONE,y),FXDIV(ONE,z),ONE));
        T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
	if (op==SCALE4D) *((FIXED4D *)arg)++;
        break;

      case TRANSLATE:
      case TRANSLATE4D:
	x = *((FIXED4D *)arg)++; y = *((FIXED4D *)arg)++; z = *((FIXED4D *)arg)++;
#if 0	
	if (fDebug) {
	    printf ("TRANSLATE ");
	    PrintFx(x);
	    PrintFx(y);
	    PrintFx(z);
	    printf("\n");
	    }
#endif	    
        Temp = Translate4D(CreateVector4D(x,y,z));
        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
        Temp = Translate4D(CreateVector4D(-x,-y,-z));
	T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
	if (op==TRANSLATE4D) *((FIXED4D *)arg)++;
	break;

      case ROTATEX:
	x = *((FIXED4D *)arg)++;
#if 0	
	if (fDebug) {
	    printf ("ROTATEX ");
	    PrintFx(x);
	    printf("\n");
	    }
#endif	    
	Temp = RotateX(x);
        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
	Temp = RotateX(-x);
	T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
        break;

      case ROTATEY:
	x = *((FIXED4D *)arg)++;
#if 0	
	if (fDebug) {
	    printf ("ROTATEY ");
	    PrintFx(x);
	    printf("\n");
	    }
#endif	    
	Temp = RotateY(x);
        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
	Temp = RotateY(-x);
	T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
        break;

      case ROTATEZ:
	x = *((FIXED4D *)arg)++;
#if 0	
	if (fDebug) {
	    printf ("ROTATEZ ");
	    PrintFx(x);
	    printf("\n");
	    }
#endif	    
	Temp = RotateZ(x);
        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
	Temp = RotateZ(-x);
	T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
        break;

      case PROJECT4D:
      case PROJECT:
	Temp.T[0][0] = *((FIXED4D *)arg)++;
	Temp.T[0][1] = *((FIXED4D *)arg)++;
	Temp.T[0][2] = *((FIXED4D *)arg)++;
	Temp.T[0][3] = FX(0);
	if (op==PROJECT4D)  ((FIXED4D *)arg)++;

	Temp.T[1][0] = *((FIXED4D *)arg)++;
	Temp.T[1][1] = *((FIXED4D *)arg)++;
	Temp.T[1][2] = *((FIXED4D *)arg)++;
	Temp.T[1][3] = FX(0);
	if (op==PROJECT4D)  ((FIXED4D *)arg)++;

	Temp.T[2][0] = *((FIXED4D *)arg)++;
	Temp.T[2][1] = *((FIXED4D *)arg)++;
	Temp.T[2][2] = *((FIXED4D *)arg)++;
	Temp.T[2][3] = FX(0);
	if (op==PROJECT4D)  ((FIXED4D *)arg)++;

	Temp.T[3][0] = FX(0);
	Temp.T[3][1] = FX(0);
	Temp.T[3][2] = FX(0);
	Temp.T[3][3] = FX(1);

        T->T = TxT4D(&T->T,&Temp);
#ifdef INVERSE
	Temp = Transpose4D(Temp);
	T->Tinv = TxT4D(&Temp,&T->Tinv);
#endif
        break;


      default:
        return 0;
    }
  }
  return 1;
}
