/* assumes 4d.h included */

/*
 * Constants assumed as transform opcodes
 */

#define END        0
#define SCALE      1
#define TRANSLATE  2
#define ROTATEX    3
#define ROTATEY    4
#define ROTATEZ    5
#define PROJECT    6
#define VIEWBOX    7

#define PROJECT4D    10
#define SCALE4D      11
#define TRANSLATE4D  12

struct TRANSFORM_STRUCT {
    MATRIXFX T;
    MATRIXFX Tinv;
};

typedef struct TRANSFORM_STRUCT TRANSFORM;

extern TRANSFORM *NewTransform	      (void);
extern TRANSFORM *MakeTM	      ();

extern int	  FreeTransform       (TRANSFORM *);
extern int	  SetTransform	      (TRANSFORM *,...);
extern int	  AppendTransform     (TRANSFORM *,...);
extern int	  ComposeTransform    (TRANSFORM *,TRANSFORM *);
extern void	  InitTransform       (TRANSFORM *);
extern int	  SetCTM	      (TRANSFORM *);
extern int	  TransformPoint      (POINTFX);
extern int	  UnTransformPoint    (POINTFX);

/*-----------------------------------------------------------------------------
  Global variables and macros for transforming points.
-----------------------------------------------------------------------------*/

extern	TRANSFORM *CTM;    /* current transform */
#define SetCTM(T)	    (CTM = &(T))
#define TransformPoint(P)   (PxT4D ((P),&CTM->T))
#define UnTransformPoint(P) (PxT4D ((P),&CTM->Tinv))
#define TransformRay(R)     (RayxT4D ((R),&CTM->T))
#define UnTransformRay(R)   (RayxT4D ((R),&CTM->Tinv))
/*
 *  Inplace transform of a ray
 */
#define TRay(R)   ((R).P0=  TransformPoint((R).P0),(R).P1=  TransformPoint((R).P1))
#define UnTRay(R) ((R).P0=UnTransformPoint((R).P0),(R).P1=UnTransformPoint((R).P1))

/*
 * Example:
 *
 *  TRANSFORM T;
 *  POINT     P = {10.0,10.0,10.0,1.0};
 *
 *  MakeTransform (&T,
 *		     ,TRANSLATE,  1.0, 1.0, 1.0
 *		     ,SCALE,	  1.0, 1.0, 1.0
 *		     ,PROJECT,	  1.0, 1.0, 1.0
 *		     ,		  1.0, 1.0, 1.0
 *		     ,		  1.0, 1.0, 1.0
 *		     ,ROTATEX,	  90.0
 *		     ,ROTATEY,	  90.0
 *		     ,ROTATEZ,	  90.0
 *		     ,TRANSLATE4D,1.0, 1.0, 1.0, 1.0
 *		     ,SCALE4D,	  1.0, 1.0, 1.0, 1.0
 *		     ,PROJECT4D,  1.0, 1.0, 1.0, 1.0
 *		     ,		  1.0, 1.0, 1.0, 1.0
 *		     ,		  1.0, 1.0, 1.0, 1.0
 *		     ,END	     <= Dont forget the END!!!
 *		   );
 *
 *  SetCTM (T);
 *  P = TransformPoint (P);
 *  P = UnTransformPoint (P);
 *
 */
