/* ---------------------------------------------------- */
/*              INCLUDE FILE DEFINITIONS                */
/* ---------------------------------------------------- */

/*
     (C) Copyright Microsoft Corp. 1991.  All rights reserved.

     You have a royalty-free right to use, modify, reproduce and 
     distribute the Sample Files (and/or any modified version) in 
     any way you find useful, provided that you agree that 
     Microsoft has no warranty obligations or liability for any 
     Sample Application Files which are modified. 
 */

#include <windows.h>
#include <stdlib.h>
#include "4d/4d.h"
#include "view.h"


#define isspace(c) ((c) == ' ' || (c) == ',' || (c) == '\t')
#define iseol(c)   ((c) == '\n' || (c) == '\r')

#define ungetc(c,pqch) ((*(pqch))--)
#define getc(pqch)     (**(pqch) ?  *(*(pqch))++ :  0)
#define feof(pqch)     (**(pqch) == 0)
#define strcmpi        lstrcmp

NewEdge( int p1, int p2);
char    *GetTok (LPSTR *fh);
DWORD PolyShade(LPPOLY pPoly, POINTFX4D color);



DWORD PolyShade(LPPOLY pPoly, POINTFX4D color)
{
    VECTORFX  n,v;
    FIXED4D     nv;
    int       r,g,b;

    n = Normalize(pPoly->nvec);
    v = Normalize(Pdiff(light,POINTSQ[pPoly->ipt[0]]));
    nv = Dot4D(n,v);

    if (nv < ZERO)
	nv = ZERO;

    nv += MAKEFX(0,4000);

    r = FXINT(FXMUL(color.x,FXMUL(FX(255),nv)));
    g = FXINT(FXMUL(color.y,FXMUL(FX(255),nv)));
    b = FXINT(FXMUL(color.z,FXMUL(FX(255),nv)));

    if (r > 255) r = 255;
    if (g > 255) g = 255;
    if (b > 255) b = 255;

    return RGB(r,g,b);
}



char    *GetTok (LPSTR *fh)
{
    static char    tok[81];
    char    c;
    int    i;

loop:
    c = (char)getc(fh);

    while (isspace(c))            /* eat all spaces and commas */
        c = (char)getc(fh);

    if ((c == '!') || (c == ';'))    /* If comment char eat char until EOL */
    {
        while (!feof(fh) && (c = (char)getc(fh)) && !iseol(c))
            ;
        goto loop;
/* return NULL; */
    }

    if (feof(fh))
        return NULL;

    if (iseol(c))
    {
        while (iseol(c))
            c = getc(fh);
        ungetc(c, fh);
        return NULL;
    }

    i = 0;
    while (!isspace(c) && !feof(fh) && !iseol(c))
    {
        tok[i++] = c;
        c = (char)getc(fh);
    }
    tok[i] = 0;
    AnsiUpper(tok);
    ungetc(c, fh);
    return tok;
}


NewEdge( int p1, int p2)
{
    int    i;
    for (i = 0; i < macEdge; i++)
    {
        if ( (EDGES[i].p1 == p1 && EDGES[i].p2 == p2) || 
            (EDGES[i].p1 == p2 && EDGES[i].p2 == p1) )
            return i;
    }

    EDGES[macEdge].p1 = p1;
    EDGES[macEdge].p2 = p2;
    EDGES[macEdge].f  = 0;

    if (macEdge < MAXEDGE)
        return macEdge++;
    else
    {
//        WinPrintf("%AEdge Table overflow");
        return macEdge;
    }
}


/*****************************************************************************
 ParseFile - Reads a text file in reconizing two syntax statements:
            PNT  N, x, y, z
            POLY p1,p2,p3,...pn

            building a table of points and a table of polygons.
*****************************************************************************/

ParseFile ( LPSTR qch)
{
    int    PntOffset = 0;
    char    *tok;
    int    FirstPNT = 1;
    int    i, n, last, first, nPnt;
    POINTFX4D   translate;
    LPSTR    * fh = &qch;
    SURFACE   surface;
    PSTR      szTexture;
    HBITMAP   hbmTexture;

    if (POINTSQ == NULL)
    {
        PNTS    = (VOID FAR * )GlobalLock(GlobalAlloc(GHND, (LONG)MAXPTS  * sizeof(POINT)));
        POINTSQ  = (VOID FAR * )GlobalLock(GlobalAlloc(GHND, (LONG)MAXPTS  * sizeof(PNT) ));
        CPOINTSQ = (VOID FAR * )GlobalLock(GlobalAlloc(GHND, (LONG)MAXPTS  * sizeof(PNT) ));
        EDGES   = (VOID FAR * )GlobalLock(GlobalAlloc(GHND, (LONG)MAXEDGE * sizeof(EDGE)));
        POLYS   = (VOID FAR * )GlobalLock(GlobalAlloc(GHND, (LONG)MAXPOLY * sizeof(POLY)));

    }


    if (!qch)
        return FALSE;

    macPoint = 0;
    macPoly  = 0;
    macEdge  = 0;

    translate.x = FX(0);
    translate.y = FX(0);
    translate.z = FX(0);

    light.x = FX(0);
    light.y = FX(0);
    light.z = FX(0);

    color.x = FX(0);
    color.y = FX(0);
    color.z = FX(0);

    rgbBackground = RGB(0, 0, 255);

    hbmTexture = NULL;

    while (!feof(fh)) 
    {
        tok = GetTok (fh);
        if (tok == NULL) 
            continue;
/*
     * Test for a PNT definition
     */
        if (strcmpi(tok, "PNT") == 0) 
        {
            i = atoi (GetTok(fh));
            if (FirstPNT) 
            {
                FirstPNT = FALSE;
                PntOffset = macPoint - 1;
                nPnt = 1;
            }

            if (i == 0)
                i = nPnt;

            i += PntOffset;

            POINTSQ[i].x = translate.x + atofx(GetTok(fh));
            POINTSQ[i].y = translate.y + atofx(GetTok(fh));
            POINTSQ[i].z = translate.z + atofx(GetTok(fh));
            POINTSQ[i].w = ONE;
            if (macPoint < MAXPTS)
                macPoint++;
            else
		;
//                WinPrintf("%APoint Table overflow");

            nPnt++;
        }
/*
     * Test for a POLY definition
     */
        else if (strcmpi(tok, "POLY") == 0) 
        {
            FirstPNT = TRUE;
            n     = 0;
            i     = -1;
            tok   = GetTok(fh);
            while (tok != NULL)
            {
                last = i;
                i = PntOffset + atoi(tok);
#if 0
                if (last >= 0)
                {
                    POLYS[macPoly].ied[n++] = (BYTE)NewEdge(last, i);
                }
                else
                {
                    first = i;
                }
#endif		
                POLYS[macPoly].ipt[n]     = (BYTE)i;
                tok = GetTok(fh);
#if 1		
		n++;
#endif	    
#if 0
                if (n == MAXPT)
                    WinPrintf("%AToo many points in a Polygon");
#endif		
            }

//            POLYS[macPoly].ied[n++]   = NewEdge(i, first);
//            POLYS[macPoly].ipt[n]     = (BYTE)i;
            POLYS[macPoly].len        = n;
       POLYS[macPoly].nvec       = PolyNormal(&POLYS[macPoly],POINTSQ);
       POLYS[macPoly].rgb        = PolyShade(&POLYS[macPoly], color);
//      POLYS[macPoly].hbmTexture = hbmTexture;
////////POLYS[macPoly].rgb        = RGB(FXINT(color.x), FXINT(color.y), FXINT(color.z));
      

            if (macPoly < MAXPOLY)
                macPoly++;
#if 0	    
            else
                WinPrintf("%APoly Table overflow");
#endif
        }
        else if (strcmpi(tok, "TRANSLATE") == 0) 
        {
            translate.x = atofx(GetTok(fh));
            translate.y = atofx(GetTok(fh));
            translate.z = atofx(GetTok(fh));
        }
        else if (strcmpi(tok, "COLOR") == 0) 
        {
            color.x = atofx(GetTok(fh));
            color.y = atofx(GetTok(fh));
            color.z = atofx(GetTok(fh));
        }
        else if (strcmpi(tok, "LIGHT") == 0) 
        {
            light.x = atofx(GetTok(fh));
            light.y = atofx(GetTok(fh));
            light.z = atofx(GetTok(fh));
        }
        else if (strcmpi(tok, "SURFACE") == 0) 
        {
            szTexture = GetTok(fh);
//            hbmTexture = bmOpenBitmap(szTexture, BM_DEFAULT);
        }
        else if (strcmpi(tok, "BACKGROUND") == 0) 
        {
            int    r, g, b;

            background.x = atofx(GetTok(fh));
            background.y = atofx(GetTok(fh));
            background.z = atofx(GetTok(fh));

            r = FXINT(background.x);
            g = FXINT(background.y);
            b = FXINT(background.z);

            if (r > 255) 
                r = 255;
            if (g > 255) 
                g = 255;
            if (b > 255) 
                b = 255;

            rgbBackground = RGB(r, g, b);
        }
/*
     *  Otherwise it is a error
     */
        else 
        {
/* ignore it .... */
/* return 0; */
        }
    }


#if 0
    WinPrintf("%MPoints= %d\nEdges= %d\nPolys=%d", macPoint, macEdge, macPoly);
#endif
    return 1;

}

