/*----------------------------------------------------------------------------*\
|   tri.c - A sample app to demonstrate the DIB Driver			       |
|                                                                              |
\*----------------------------------------------------------------------------*/

/*
     (C) Copyright Microsoft Corp. 1991.  All rights reserved.

     You have a royalty-free right to use, modify, reproduce and 
     distribute the Sample Files (and/or any modified version) in 
     any way you find useful, provided that you agree that 
     Microsoft has no warranty obligations or liability for any 
     Sample Application Files which are modified. 
 */


/*----------------------------------------------------------------------------*\
|                                                                              |
|   g e n e r a l   c o n s t a n t s                                          |
|                                                                              |
\*----------------------------------------------------------------------------*/

#define MAXSTR   80

/*----------------------------------------------------------------------------*\
|                                                                              |
|   i n c l u d e   f i l e s                                                  |
|                                                                              |
\*----------------------------------------------------------------------------*/

#define SWAP(x,y)   ((x)^=(y)^=(x)^=(y))

// define if we want to force bitmap to <64K (ie, 320x200)
// note: bitmap include BITMAPINFOHEADER and pal 

//#define SMALLBITMAP


#define  NOLFILEIO
#include <windows.h>
#include <stdlib.h>	// for rand()
#include "triq.h"
#include "dib.h"

/*----------------------------------------------------------------------------*\
|                                                                              |
|   g l o b a l   v a r i a b l e s                                            |
|                                                                              |
\*----------------------------------------------------------------------------*/
static  char    szAppName[]="Triangle App";

static  HANDLE  hInstApp;
static  HWND    hwndApp;
static  HPALETTE hpalApp;
static  HPALETTE hpalT1;
static  HPALETTE hpalT2;

BOOL    fActiveApp=TRUE;

BOOL	fUseBlit=TRUE;
BOOL	fUseDIB=FALSE;
BOOL	fUseCustom=FALSE;
BOOL    fUseGDI=FALSE;
BOOL    fSolidColors=FALSE;
BOOL    fNullPen=TRUE;
BOOL    fBoxes=FALSE;
unsigned wUseSkip=MENU_EVERY;
unsigned wskipmask=0xffff;


PSTR    szText;
char    szString[MAXSTR];
short   xClient, yClient;


HDC     hdcDib1;
HANDLE  hdib1   = NULL;      // memory DIB

HDC	hdcDib2;
HANDLE  hdib2   = NULL;      // memory DIB

LPSTR	lpdib1;
LPSTR   lpdib2;

BOOL	fDibCur=0;

HPALETTE hpalEx;
HPALETTE hpalSystem;
HPALETTE hpalPalette   = NULL;      // current real-palette
HPALETTE hpalCurrent   = NULL;      // current dib-palette
HANDLE   hdibCurrent   = NULL;      // memory DIB

WORD askipmask[MENU_SKIP_MAX - MENU_SKIP_MIN +1]=
{
    0xffff,	// MENU_EVERY
    0xfffe,	// MENU_SKIP2
    0xfff7,	// MENU_SKIP4
    0xfff0,     // MENU_SKIP8
    0xffe0,	// MENU_SKIP16
    0x0000	// MENU_SKIPALL
};

/*----------------------------------------------------------------------------*\
|                                                                              |
|   f u n c t i o n   d e f i n i t i o n s                                    |
|                                                                              |
\*----------------------------------------------------------------------------*/

LONG FAR PASCAL AppWndProc (HWND hwnd, unsigned uiMessage, WORD wParam, LONG lParam);
VOID FAR PASCAL Triangle(HDC hDC, LPPOINT lpPoints);
VOID FAR PASCAL DIBTriangle(LPSTR lpdib, LPPOINT lpPoints, WORD crCol);
BOOL fDialog(int id,HWND hwnd,FARPROC fpfn);

int ErrMsg (LPSTR sz,...);

void redraw(void);

/*----------------------------------------------------------------------------*\
|   AppAbout( hDlg, uiMessage, wParam, lParam ) 			       |
|									       |
|   Description:							       |
|	This function handles messages belonging to the "About" dialog box.    |
|	The only message that it looks for is WM_COMMAND, indicating the use   |
|	has pressed the "OK" button.  When this happens, it takes down	       |
|	the dialog box. 						       |
|									       |
|   Arguments:								       |
|	hDlg		window handle of about dialog window		       |
|	uiMessage	message number					       |
|	wParam		message-dependent				       |
|	lParam		message-dependent				       |
|									       |
|   Returns:								       |
|	TRUE if message has been processed, else FALSE			       |
|									       |
\*----------------------------------------------------------------------------*/
BOOL FAR PASCAL AppAbout( hDlg, uiMessage, wParam, lParam )
    HWND     hDlg;
    unsigned uiMessage;
    WORD     wParam;
    long     lParam;
{
    switch (uiMessage) 
    {
        case WM_COMMAND:
            if (wParam == IDOK)
                EndDialog(hDlg,TRUE);
	    break;

	case WM_INITDIALOG:
	    return TRUE;
    }
    return FALSE;
}

/*----------------------------------------------------------------------------*\
|   AppInit( hInst, hPrev)						       |
|									       |
|   Description:							       |
|	This is called when the application is first loaded into	       |
|	memory.  It performs all initialization that doesn't need to be done   |
|	once per instance.						       |
|									       |
|   Arguments:								       |
|	hInstance	instance handle of current instance		       |
|	hPrev		instance handle of previous instance		       |
|									       |
|   Returns:								       |
|	TRUE if successful, FALSE if not				       |
|									       |
\*----------------------------------------------------------------------------*/
BOOL AppInit(HANDLE hInst,HANDLE hPrev,WORD sw,LPSTR szCmdLine)
{
    WNDCLASS cls;
    int      dx,dy;
    char     ach[80];
    HMENU    hmenu;

    /* Save instance handle for DialogBoxs */
    hInstApp = hInst;

    if (!hPrev) 
    {
	/*
	 *  Register a class for the main application window
	 */
        cls.hCursor        = LoadCursor(NULL,IDC_ARROW);
        cls.hIcon          = LoadIcon(hInst,MAKEINTATOM(ID_APP));
        cls.lpszMenuName   = MAKEINTATOM(ID_APP);
        cls.lpszClassName  = MAKEINTATOM(ID_APP);
        cls.hbrBackground  = (HBRUSH)COLOR_WINDOW + 1;
        cls.hInstance      = hInst;
        cls.style          = CS_BYTEALIGNCLIENT | CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
        cls.lpfnWndProc    = AppWndProc;
        cls.cbWndExtra     = 0;
        cls.cbClsExtra     = 0;

        if (!RegisterClass(&cls))
	    return FALSE;
    }

    
    hpalApp = CreateExplicitPalette();

    dx = GetSystemMetrics (SM_CXSCREEN);
    dy = GetSystemMetrics (SM_CYSCREEN);

    hwndApp = CreateWindow (MAKEINTATOM(ID_APP),    // Class name
                            szAppName,              // Caption
                            WS_OVERLAPPEDWINDOW,    // Style bits
                            CW_USEDEFAULT, CW_USEDEFAULT,       // Position
                            CW_USEDEFAULT, CW_USEDEFAULT,       // Size
                            (HWND)NULL,             // Parent window (no parent)
                            (HMENU)NULL,            // use class menu
                            (HANDLE)hInst,          // handle to window instance
                            (LPSTR)NULL             // no params to pass on
                           );
		       
    ShowWindow(hwndApp,sw);

    return TRUE;
}

static drawcount=0;

void DrawTriangle(void)
{
    HBRUSH  hBrush;
    DWORD   rgb;
    POINT   pts[10];
    int     n;
    int     nPoints;
    short   nRed, nGreen, nBlue;
    LPSTR lpdib;

    HPALETTE hpalT;
    HDC hdc;

    if(!fUseDIB)
    {
	hdc = GetDC(hwndApp);
	if (hpalApp)
	{
	    hpalT = SelectPalette(hdc,hpalApp,FALSE);
	    RealizePalette(hdc);
	}

    }
    else
    {
	if(fDibCur)
	{
	    hdc=hdcDib2;
	    lpdib=lpdib2;
	}
	else
	{
	    hdc=hdcDib1;
	    lpdib=lpdib1;
	}
	
    }

    nPoints = fBoxes ? 4 : 3 ;
    
    for (n=0; n<nPoints; n++)
    {
	pts[n].x = rand() % xClient;
	pts[n].y = rand() % yClient;
    }

    pts[n] = pts[0];
    
    nRed    = rand() % 255;
    nGreen  = rand() % 255;
    nBlue   = rand() % 255;
    
    rgb = RGB(nRed, nGreen, nBlue);
    
    if (fSolidColors)
	rgb = PALETTEINDEX(nRed);

    hBrush = CreateSolidBrush(rgb);
    
    hBrush = SelectObject(hdc, hBrush);

    if (fNullPen)
	SelectObject(hdc, GetStockObject(NULL_PEN));

    if(fUseCustom)
    {
	DIBTriangle(lpdib, pts, nRed);
	if (!fNullPen)
	    Polyline(hdc, pts, nPoints+1);
    }
    else if (fUseGDI) 
    {
	Polygon(hdc, pts, nPoints);
    }
    else // use special pat blit
    {
	Triangle(hdc, pts);
	if (!fNullPen)
	    Polyline(hdc, pts, nPoints+1);
    }
    
    DeleteObject(SelectObject(hdc, hBrush));
    
    drawcount++;
    
    if(!fUseDIB)
    {
	if (hpalApp)
	    SelectPalette(hdc,hpalT,FALSE);
	
	    
	ReleaseDC(hwndApp,hdc);
    }
    else
    {
	if((drawcount & wskipmask) == drawcount)
	    redraw();
	
	if(!fUseBlit)
	{
	    // switch current dibs if delta-frame
	    fDibCur=!fDibCur;
	    // need to copy cur to last...
	}
    }
}

void redraw(void)
{
    HDC hdc;
    HPALETTE hpalT;
    
    hdc = GetDC(hwndApp);
    if (hpalApp)
    {
	hpalT = SelectPalette(hdc,hpalApp,FALSE);
	RealizePalette(hdc);
    }
    
    DibBlt(hdc,0,0,-1,-1,fDibCur ? hdib2 : hdib1, 0,0, SRCCOPY, DIB_PAL_COLORS);
    
    if (hpalApp)
	SelectPalette(hdc,hpalT,FALSE);
    
    ReleaseDC(hwndApp,hdc);
}

/*----------------------------------------------------------------------------*\
|   WinMain( hInst, hPrev, lpszCmdLine, cmdShow )			       |
|                                                                              |
|   Description:                                                               |
|       The main procedure for the App.  After initializing, it just goes      |
|       into a message-processing loop until it gets a WM_QUIT message         |
|       (meaning the app was closed).                                          |
|                                                                              |
|   Arguments:                                                                 |
|	hInst		instance handle of this instance of the app	       |
|	hPrev		instance handle of previous instance, NULL if first    |
|       szCmdLine       ->null-terminated command line                         |
|       cmdShow         specifies how the window is initially displayed        |
|                                                                              |
|   Returns:                                                                   |
|       The exit code as specified in the WM_QUIT message.                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
int PASCAL WinMain(HANDLE hInst, HANDLE hPrev, LPSTR szCmdLine, WORD sw)
{
    MSG     msg;

    /* Call initialization procedure */
    if (!AppInit(hInst,hPrev,sw,szCmdLine))
        return FALSE;
    
    hdib1 = CreateDib(8,xClient,yClient);
    hdib2 = CreateDib(8,xClient,yClient);
    
    SetDibUsage(hdib1, hpalApp, DIB_PAL_COLORS);
    SetDibUsage(hdib2, hpalApp, DIB_PAL_COLORS);
    
    lpdib1=GlobalLock(hdib1);
    lpdib2=GlobalLock(hdib2);
    
    hdcDib1 = CreateDC("DIB",NULL,NULL,lpdib1);
    hdcDib2 = CreateDC("DIB",NULL,NULL,lpdib2);

    if (hpalApp)
    {
	hpalT1 = SelectPalette(hdcDib1,CreateExplicitPalette(),FALSE);
	RealizePalette(hdcDib1);
	hpalT2 = SelectPalette(hdcDib2,CreateExplicitPalette(),FALSE);
	RealizePalette(hdcDib2);
    }
    
    
    /*
     * Polling messages from event queue
     */

    while (TRUE) 
    {
	if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) 
	{
	    if (msg.message == WM_QUIT)
		break;

	    TranslateMessage(&msg);
	    DispatchMessage(&msg);
	}
	else if(fActiveApp)
	{
	    DrawTriangle();

	}
	else
	{
	    // wait for a message so we don't chew time with loop
            WaitMessage();
	}

    }
    if (hpalApp)
    {
	DeleteObject(SelectPalette(hdcDib1,hpalT1,FALSE));
	DeleteObject(SelectPalette(hdcDib2,hpalT2,FALSE));
    }
    
    DeleteDC(hdcDib1);
    DeleteDC(hdcDib2);
    
    GlobalUnlock(hdib1);
    GlobalUnlock(hdib2);
    GlobalFree(hdib1);
    GlobalFree(hdib2);

    return msg.wParam;
}

/*----------------------------------------------------------------------------*\
|                                                                              |
|   w i n d o w   p r o c s                                                    |
|                                                                              |
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
|   AppWndProc( hwnd, uiMessage, wParam, lParam )			       |
|                                                                              |
|   Description:                                                               |
|       The window proc for the app's main (tiled) window.  This processes all |
|       of the parent window's messages.                                       |
|                                                                              |
|   Arguments:                                                                 |
|	hwnd		window handle for the window			       |
|       uiMessage       message number                                         |
|       wParam          message-dependent                                      |
|       lParam          message-dependent                                      |
|                                                                              |
|   Returns:                                                                   |
|       0 if processed, nonzero if ignored                                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
LONG FAR PASCAL AppWndProc(hwnd, msg, wParam, lParam)
    HWND     hwnd;
    unsigned msg;
    WORD     wParam;
    long     lParam;
{
    PAINTSTRUCT ps;
    BOOL        f;
    HDC         hdc;
    DWORD       dwTime;
    int         i;
    HPALETTE    hpalT;

    switch (msg) 
    {
	case WM_ACTIVATEAPP:
	    fActiveApp=wParam;
	    break;
	case WM_INITMENU:
	    if(fUseCustom)
	    {
		CheckMenuItem((HMENU)wParam,MENU_USEGDI, MF_UNCHECKED);
		CheckMenuItem((HMENU)wParam,MENU_USEPAT, MF_UNCHECKED);
		CheckMenuItem((HMENU)wParam,MENU_USECUSTOM, MF_CHECKED);
	    }
	    else
	    {
		CheckMenuItem((HMENU)wParam,MENU_USEGDI,
			fUseGDI ? MF_CHECKED : MF_UNCHECKED);
		CheckMenuItem((HMENU)wParam,MENU_USEPAT,
			fUseGDI ? MF_UNCHECKED : MF_CHECKED);
		CheckMenuItem((HMENU)wParam,MENU_USECUSTOM, MF_UNCHECKED);
	    }
	    for(i=MENU_DIB_MIN;i<=MENU_DIB_MAX;i++)
	    {
		EnableMenuItem((HMENU)wParam, i ,
			    fUseDIB ?  MF_ENABLED : MF_GRAYED);
		CheckMenuItem((HMENU)wParam, i, MF_UNCHECKED);
	    }
	    CheckMenuItem((HMENU)wParam, wUseSkip, MF_CHECKED);
	    
            EnableMenuItem((HMENU)wParam,MENU_DIB,
			hdcDib1 ?  MF_ENABLED : MF_GRAYED);
		    
            EnableMenuItem((HMENU)wParam,MENU_USECUSTOM,
			fUseDIB ?  MF_ENABLED : MF_GRAYED);
		    
	    CheckMenuItem((HMENU)wParam,MENU_DIB,
			fUseDIB ? MF_CHECKED : MF_UNCHECKED);
	    CheckMenuItem((HMENU)wParam,MENU_SCREEN,
			fUseDIB ? MF_UNCHECKED : MF_CHECKED);
	    
	    CheckMenuItem((HMENU)wParam,MENU_SOLID,
			fSolidColors ? MF_CHECKED : MF_UNCHECKED);
	    CheckMenuItem((HMENU)wParam,MENU_NULLPEN,
			fNullPen ? MF_CHECKED : MF_UNCHECKED);
	    CheckMenuItem((HMENU)wParam,MENU_BOXES,
			fBoxes ? MF_CHECKED : MF_UNCHECKED);
	    break;

	case WM_COMMAND:
	    switch (wParam) 
	    {
		case MENU_ABOUT:
		    fDialog(ABOUTBOX,hwnd,AppAbout);
		    break;
	    
		case MENU_USECUSTOM:
		    fUseCustom=!fUseCustom;
		    break;
		    
		case MENU_SKIP2:
		case MENU_SKIP4:
		case MENU_SKIP8:
		case MENU_SKIP16:
		case MENU_SKIPALL:
		case MENU_EVERY:
		    wskipmask=askipmask[wParam-MENU_SKIP_MIN];
		    wUseSkip=wParam;
		    break;
		    
		case MENU_REDRAW:
		    redraw();
		    break;
		    
		    
		case MENU_DIB:
		case MENU_SCREEN:
		    fUseDIB=!fUseDIB;
		    if(!fUseDIB)
			fUseCustom=FALSE;
		    break;
		    
		case MENU_EXIT:
		    PostMessage(hwnd,WM_CLOSE,0,0L);
		    break;

		case MENU_USEPAT:
		case MENU_USEGDI:
		    fUseGDI = !fUseGDI;
		    fUseCustom=FALSE;
		    break;
		    
		case MENU_BOXES:
		    fBoxes = !fBoxes;
		    break;

		case MENU_SOLID:
		    fSolidColors = !fSolidColors;
		    break;

		case MENU_NULLPEN:
		    fNullPen = !fNullPen;
		    break;

                case MENU_TIMEIT:
		    InvalidateRect(hwnd,NULL,TRUE);
		    UpdateWindow(hwnd);
		    
		    #define N 512

#if 0		
			hdc = GetDC(hwnd);

		    if (hpalApp)
		    {
			hpalT = SelectPalette(hdc,hpalApp,FALSE);
			RealizePalette(hdc);
		    }
#endif
		    dwTime = GetCurrentTime();
		    
		    for (i=0; i<N; i++)
			DrawTriangle();

		    dwTime = GetCurrentTime() - dwTime;
#if 0
		    if (hpalApp)
			SelectPalette(hdc,hpalT,FALSE);

		    ReleaseDC(hwnd,hdc);
#endif
		    redraw();
		
		    ErrMsg("%d Tri's in %d.%04d sec\n%d.%04d sec per Tri",
			    N,
			    (WORD)(dwTime / 1000), (WORD)(dwTime % 1000),
			    (WORD)((dwTime/N)/1000), (WORD)((dwTime/N) % 1000)
				    );

		    break;
	    }
	    break;

	case WM_SIZE:
#ifndef SMALLBITMAP	    
	    xClient = LOWORD(lParam);
	    yClient = HIWORD(lParam);
#else
	    xClient = 320;
	    yClient = 200;
#endif	    
	    break;

	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

    }

    return DefWindowProc(hwnd,msg,wParam,lParam);
}

/*----------------------------------------------------------------------------*\
|   ErrMsg - Opens a Message box with a error message in it.  The user can     |
|	     select the OK button to continue or the CANCEL button to kill     |
|	     the parent application.					       |
\*----------------------------------------------------------------------------*/
int ErrMsg (LPSTR sz,...)
{
    char ach[128];

    wvsprintf (ach,sz,(LPSTR)(&sz+1));   /* Format the string */
    MessageBox(NULL,ach,NULL,MB_OK);
    return FALSE;
}

#if 0

void NEAR PASCAL DIBOutScan(LPSTR lpBuf, WORD curY, WORD start, WORD end, WORD val)
{
    // using huge allows big bitmaps... if you know bitmap is <64K, use
    // just far for faster operation
#ifndef SMALLBITMAP	
    char huge * hpBuf;
#else
    char far * hpBuf;
#endif
    LPBITMAPINFOHEADER    lpbi;
    WORD cy;

    
    lpbi=(LPBITMAPINFOHEADER)lpBuf;

#if 1
    if(end<start)
	SWAP(end,start);
#endif 
    // invert coord system
    cy=lpbi->biHeight-1 - curY;
    
    // assume 8-bit dib. (therefore, 256 pal entries)
    // assume BITMAPINFOHEADER (therfore, RGBQUAD)
	
    hpBuf=lpBuf;
    hpBuf+=(lpbi->biSize + 256*sizeof(RGBQUAD));
//    hpBuf+=(char huge *)lpBuf;
    hpBuf+=(WORD)(cy* (((WORD)lpbi->biWidth+3)&~3)) + start;
    
    cy=end-start+1;   // cy is num of pels
    
    while(cy--)
    {
	*hpBuf++=(BYTE)val;
    }
}

#endif

/*----------------------------------------------------------------------------*\
|   fDialog(id,hwnd,fpfn)						       |
|									       |
|   Description:                                                               |
|	This function displays a dialog box and returns the exit code.	       |
|	the function passed will have a proc instance made for it.	       |
|									       |
|   Arguments:                                                                 |
|	id		resource id of dialog to display		       |
|	hwnd		parent window of dialog 			       |
|	fpfn		dialog message function 			       |
|                                                                              |
|   Returns:                                                                   |
|	exit code of dialog (what was passed to EndDialog)		       |
|                                                                              |
\*----------------------------------------------------------------------------*/
BOOL fDialog(int id,HWND hwnd,FARPROC fpfn)
{
    BOOL	f;
    HANDLE	hInst;

    hInst = GetWindowWord(hwnd,GWW_HINSTANCE);
    fpfn  = MakeProcInstance(fpfn,hInst);
    f = DialogBox(hInst,MAKEINTRESOURCE(id),hwnd,fpfn);
    FreeProcInstance (fpfn);
    return f;
}

